function Initialize(tile, engine, system)
{
	tile.disableState("Max");
    this.ui = tile.getContainerFrame();
    
    this.ui.Type.currentIndexChanged.connect(this, this.changeType);
    var idx = this.ui.Type.currentIndex();
    this.changeType(idx);
    
    this.ui.Type.hide();
    
    this.ui.Symbols.currentIndexChanged.connect(this, this.changeSymbols);
    var idx = this.ui.Symbols.currentIndex();
    this.changeSymbols(idx);
    
    this.ui.CurrentPlot.currentIndexChanged.connect(this, this.changePlot);
    this.changePlot();
    
    this.ui.Cycle.clicked.connect(this, this.cyclePlot);
 
 	this.ui.Rate.hide();
 	this.ui.Rate.currentIndexChanged.connect(this, this.changeTypeToNxdn);   
}

Initialize.prototype.changeType = function(idx)
{
	switch(Number(idx))
	{
		case 2: //P25
			this.ui.DistributionPlot.XBottomLowerLimit = -2400;
			this.ui.DistributionPlot.XBottomUpperLimit = 2400;
			var ar = [-1800, -600, 600, 1800];
			this.ui.DistributionPlot.setTicks( ar );
			//this.ui.DistributionPlot.setTicks(-1800, -600, 600, 1800);
			
			this.ui.EyePlot.YLeftLowerLimit = -3000;
			this.ui.EyePlot.YLeftUpperLimit = 3000;
			this.ui.EyePlot.YLines = 5;
			break;
		case 3: //DMR
			this.ui.DistributionPlot.XBottomLowerLimit = -2400;
			this.ui.DistributionPlot.XBottomUpperLimit = 2400;
			var ar = [-1944, -648, 648, 1944];
			this.ui.DistributionPlot.setTicks( ar );
			//this.ui.DistributionPlot.setTicks(-1944, -648, 648, 1944);
			
			this.ui.EyePlot.YLeftLowerLimit = -3240;
			this.ui.EyePlot.YLeftUpperLimit = 3240;
			this.ui.EyePlot.YLines = 5;
			break;
		case 4: //NXDN
			this.changeTypeToNxdn();
			break;
		case 5: //dPMR
			this.ui.DistributionPlot.XBottomLowerLimit = -1400;
			this.ui.DistributionPlot.XBottomUpperLimit = 1400;
			var ar = [-1050, -350, 350, 1050];
			this.ui.DistributionPlot.setTicks( ar );
			//this.ui.DistributionPlot.setTicks(-1050, -350, 350, 1050);
			
			this.ui.EyePlot.YLeftLowerLimit = -1750;
			this.ui.EyePlot.YLeftUpperLimit = 1750;
			this.ui.EyePlot.YLines = 5;
			break;
		case 6: //ARIB
			this.ui.DistributionPlot.XBottomLowerLimit = -1260;
			this.ui.DistributionPlot.XBottomUpperLimit = 1260;
			var ar = [-945, -315, 315, 945];
			this.ui.DistributionPlot.setTicks( ar );
			//this.ui.DistributionPlot.setTicks(-945, -315, 315, 945);
			
			this.ui.EyePlot.YLeftLowerLimit = -1575;
			this.ui.EyePlot.YLeftUpperLimit = 1575;
			this.ui.EyePlot.YLines = 5;
			break;	
		case 8: //P25 HCPM
			this.ui.DistributionPlot.XBottomLowerLimit = -4000;
			this.ui.DistributionPlot.XBottomUpperLimit = 4000;
			var ar = [-3000, -2000, -1000, 0, 1000, 2000, 3000];
			this.ui.DistributionPlot.setTicks( ar );
			//this.ui.DistributionPlot.setTicks(-3000, -2000, -1000, 0, 1000, 2000, 3000);
			
			this.ui.EyePlot.YLeftLowerLimit = -4000;
			this.ui.EyePlot.YLeftUpperLimit = 4000;
			this.ui.EyePlot.YLines = 8;
			break;
		case 9: //P25 HDQPSK
			this.ui.DistributionPlot.XBottomLowerLimit = -3000;
			this.ui.DistributionPlot.XBottomUpperLimit = 3000;
			var ar = [-2250, -750, 750, 2250];
			this.ui.DistributionPlot.setTicks( ar );
			//this.ui.DistributionPlot.setTicks(-2250, -750, 750, 2250);
			
			this.ui.EyePlot.YLeftLowerLimit = -3750;
			this.ui.EyePlot.YLeftUpperLimit = 3750;
			this.ui.EyePlot.YLines = 5;
			break;
			
		case 11: //arc
			this.ui.DistributionPlot.XBottomLowerLimit = -2880;
			this.ui.DistributionPlot.XBottomUpperLimit = 2880;
			var ar = [-2160, -720, 720, 2160];
			this.ui.DistributionPlot.setTicks( ar );
			//this.ui.DistributionPlot.setTicks(-1050, -350, 350, 1050);
			
			this.ui.EyePlot.YLeftLowerLimit = -3600;
			this.ui.EyePlot.YLeftUpperLimit = 3600;
			break;
		default:
			break;
	}
}

Initialize.prototype.changeTypeToNxdn = function()
{
	var type = this.ui.Type.currentIndex();
	if (type == 4)
	{
		var rate = this.ui.Rate.currentIndex();
		switch(rate)
		{
			case 0: //4800
				this.ui.DistributionPlot.XBottomLowerLimit = -1400;
				this.ui.DistributionPlot.XBottomUpperLimit = 1400;
				var ar = [-1050, -350, 350, 1050];
				this.ui.DistributionPlot.setTicks( ar );
				//this.ui.DistributionPlot.setTicks(-1050, -350, 350, 1050);
				
				this.ui.EyePlot.YLeftLowerLimit = -1750;
				this.ui.EyePlot.YLeftUpperLimit = 1750;
				break;
			case 1: //9600
				this.ui.DistributionPlot.XBottomLowerLimit = -3200;
				this.ui.DistributionPlot.XBottomUpperLimit = 3200;
				var ar = [-2400, -800, 800, 2400];
				this.ui.DistributionPlot.setTicks( ar );
				//this.ui.DistributionPlot.setTicks(-2400, -800, 800, 2400);
				
				this.ui.EyePlot.YLeftLowerLimit = -4000;
				this.ui.EyePlot.YLeftUpperLimit = 4000;
				break;
		}
	}
}

Initialize.prototype.changeSymbols = function(idx)
{
	this.ui.EyePlot.XBottomUpperLimit = idx;
	this.ui.EyePlot.XLines = idx;
}

Initialize.prototype.changePlot = function()
{
	var idx = this.ui.CurrentPlot.currentIndex();
	switch (idx)
	{
		case 0:	//distribution
			this.ui.DistributionPlot.show();
			
			this.ui.ConstellationPlot.hide();
			this.ui.EyePlot.hide();
			this.ui.Symbols.hide();
			break;
		case 2:	//eye
			this.ui.EyePlot.show();
			this.ui.Symbols.show();
			
			this.ui.ConstellationPlot.hide();
			this.ui.DistributionPlot.hide();
			break;
		case 3:	//constellation
			this.ui.ConstellationPlot.show();
			
			this.ui.DistributionPlot.hide();
			this.ui.EyePlot.hide();
			this.ui.Symbols.hide();
			break;
	}
}

Initialize.prototype.cyclePlot = function()
{
	var idx = this.ui.CurrentPlot.currentIndex();
	if (idx == 0)
		idx = 2;
	else if (idx == 2)
		idx = 3;
	else
		idx = 0;
	
	var filter = this.ui.CurrentPlot.getEventFilter();
	filter.submitWidgetValue(idx);
}