function Initialize(tile, engine, system)
{
	tile.disableState("Max");
    this.ui = tile.getContainerFrame();
    //this.ui.StartPlay.hide();
    //this.ui.ProgressBar.hide();
	this.ui.StopPlay.hide();
	this.ui.StopRecord.hide();
	this.ui.Modulation.hide();
	this.ui.ShowPlay.hide();
	this.ui.ShowProgress.hide();
	
	
	this.ui.Modulation.currentIndexChanged.connect(this, this.modulationChanged);
	this.modulationChanged();
	
	this.ui.ShowPlay.toggled.connect(this, this.playStateChanged);
	this.ui.ShowProgress.toggled.connect(this, this.progressStateChanged);
}

Initialize.prototype.modulationChanged = function()
{
	var idx = this.ui.Modulation.currentIndex();
	if (idx == 3 || idx == 5 || idx == 2 || idx == 4 || idx == 6)
	{
		this.ui.StartRecord.show();
		this.ui.InfoLabel.hide();
		this.ui.Threshold.show();
		this.ui.StartPlay.show();
		this.ui.ProgressBar.show();
		this.ui.Abort.show();
	}
	else
	{
		this.ui.StartRecord.hide();
		this.ui.InfoLabel.show();
		this.ui.Threshold.hide();
		this.ui.StartPlay.hide();
		this.ui.ProgressBar.hide();
		this.ui.Abort.hide();
	}
	
	if (idx == 3)
	{
		this.ui.ChannelMode.show();		
	}
	else
	{
		this.ui.ChannelMode.hide();		
	}
	
	if(idx == 3 || idx == 5 || idx ==2 || idx == 4 || idx == 6)
	{
		this.ui.Threshold.show();
	}
	else
	{
		this.ui.Threshold.hide();
	}
}

Initialize.prototype.playStateChanged = function(val)
{
	if (val)
	{
		this.ui.StartPlay.show();
	}
	else
	{
		this.ui.StartPlay.hide();
	}
}

Initialize.prototype.progressStateChanged = function(val)
{
	if (val)
	{
		this.ui.ProgressBar.show();
	}
	else
	{
		this.ui.ProgressBar.hide();
	}
}
