function Initialize(tile, engine, system)
{
	tile.disableState("Max");
	this.ui = tile.getContainerFrame();
	
	this.ui.ModType.hide();
	this.ui.ModType.currentIndexChanged.connect(this, this.modTypeChanged);
	this.modTypeChanged();
}

Initialize.prototype.modTypeChanged = function()
{
	var idx = this.ui.ModType.currentIndex();
	switch (idx)
	{
		case 2: //P25
		case 8: //Phase 2
		case 9: //Phase 2
			this.ui.Tab.showTab(1);
			this.ui.Tab.showTab(2);
			this.ui.Tab.setTabText(3, "Sym Dev");
			this.ui.Tab.showTab(4);
			this.ui.Tab.setTabText(4, "Mod Fidly");
			this.ui.Tab.showTab(5);
			this.ui.Tab.showTab(6);
			this.ui.Tab.showTab(7);
			this.ui.Tab.showTab(8);
			this.ui.Tab.hideTab(9);
			this.ui.Tab.hideTab(10);
			this.ui.Tab.hideTab(11);
			this.ui.Tab.hideTab(12);
			break;
		case 7: // PTC
			this.ui.Tab.showTab(1);
			this.ui.Tab.showTab(2);
			this.ui.Tab.showTab(4);
			this.ui.Tab.setTabText(4, "EVM");
			this.ui.Tab.showTab(9);
			this.ui.Tab.hideTab(8);
			this.ui.Tab.hideTab(3);
			this.ui.Tab.hideTab(5);
			this.ui.Tab.hideTab(6);
			this.ui.Tab.hideTab(7);
			this.ui.Tab.hideTab(10);
			this.ui.Tab.hideTab(11);
			this.ui.Tab.hideTab(12);
			break;
		case 10: //FM P25 Phase 2
			this.ui.Tab.hideTab(1);
			this.ui.Tab.hideTab(2);
			this.ui.Tab.setTabText(3, "Dev");
			this.ui.Tab.hideTab(4);
			this.ui.Tab.hideTab(5);
			this.ui.Tab.hideTab(6);
			this.ui.Tab.hideTab(7);
			this.ui.Tab.hideTab(8);
			this.ui.Tab.hideTab(9);
			//show rf pow?
			this.ui.Tab.hideTab(10);
			this.ui.Tab.hideTab(11);
			this.ui.Tab.hideTab(12);
			break;
		case 12: //TETRA
			this.ui.Tab.showTab(1);
			this.ui.Tab.showTab(2);
			this.ui.Tab.hideTab(3);
			this.ui.Tab.hideTab(4);
			this.ui.Tab.hideTab(5);
			this.ui.Tab.hideTab(6);
			this.ui.Tab.hideTab(7);
			this.ui.Tab.hideTab(8);
			this.ui.Tab.hideTab(9);
			this.ui.Tab.showTab(10);
			this.ui.Tab.showTab(11);
			this.ui.Tab.showTab(12);
			break;
		default:
			this.ui.Tab.showTab(1);
			this.ui.Tab.showTab(2);
			this.ui.Tab.setTabText(3, "Sym Dev");
			this.ui.Tab.setTabText(4, "FSK Err");
			this.ui.Tab.showTab(4);
			this.ui.Tab.showTab(5);
			this.ui.Tab.showTab(6);
			this.ui.Tab.showTab(7);
			this.ui.Tab.showTab(8);
			this.ui.Tab.hideTab(9);
			this.ui.Tab.hideTab(10);
			this.ui.Tab.hideTab(11);
			this.ui.Tab.hideTab(12);
			break;
	}
}