function Initialize(tile, engine, system)
{
	tile.enableState("Thumb");
	tile.disableState("Max");
	tile.configureState("Thumb","400|200");
	tile.configureState("Min","400|400");
	tile.setDefaultState("Thumb");
	this.ui = tile.getContainerFrame();
	
    tile.changeSize.connect(this, this.resize);
   	this.resize("Thumb");
	
	this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1Freq_Thumb['unitChanged(int)'].connect(this, this.Gen1UnitChanged);
	this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen1Freq_Min['unitChanged(int)'].connect(this, this.Gen1UnitChanged);
    var idx = this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1Freq_Thumb.unitIndex();
    this.Gen1UnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen2Freq_Min['unitChanged(int)'].connect(this, this.Gen2UnitChanged);
    idx = this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen2Freq_Min.unitIndex();
    this.Gen2UnitChanged(idx);
    
    
	this.ui.stackedWidget.page_Thumb.Tab.widget(1).TwoToneLevel_Thumb['unitChanged(int)'].connect(this, this.TwoToneLevelUnitChanged);
	this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneLevel_Min['unitChanged(int)'].connect(this, this.TwoToneLevelUnitChanged);
    idx = this.ui.stackedWidget.page_Thumb.Tab.widget(1).TwoToneLevel_Thumb.unitIndex();
    this.TwoToneLevelUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneAFreq_Min['unitChanged(int)'].connect(this, this.TwoToneFreqAUnitChanged);
    idx = this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneAFreq_Min.unitIndex();
    this.TwoToneFreqAUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneBFreq_Min['unitChanged(int)'].connect(this, this.TwoToneFreqBUnitChanged);
    idx = this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneBFreq_Min.unitIndex();
    this.TwoToneFreqBUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneADuration_Min['unitChanged(int)'].connect(this, this.TwoToneDurationAUnitChanged);
	idx = this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneADuration_Min.unitIndex();
    this.TwoToneDurationAUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneBDuration_Min['unitChanged(int)'].connect(this, this.TwoToneDurationBUnitChanged);
	idx = this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneBDuration_Min.unitIndex();
    this.TwoToneDurationBUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneSpace_Min['unitChanged(int)'].connect(this, this.TwoToneSpaceUnitChanged);
	idx = this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneSpace_Min.unitIndex();
    this.TwoToneSpaceUnitChanged(idx);
	
	this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq1_Min['unitChanged(int)'].connect(this, this.ToneRemoteFreq1UnitChanged);
	idx = this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq1_Min.unitIndex();
    this.ToneRemoteFreq1UnitChanged(idx);
    
	this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq2_Min['unitChanged(int)'].connect(this, this.ToneRemoteFreq2UnitChanged);
	idx = this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq2_Min.unitIndex();
    this.ToneRemoteFreq2UnitChanged(idx);
    
	this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq3_Min['unitChanged(int)'].connect(this, this.ToneRemoteFreq3UnitChanged);
	idx = this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq3_Min.unitIndex();
    this.ToneRemoteFreq3UnitChanged(idx);
    
	this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration1_Min['unitChanged(int)'].connect(this, this.ToneRemoteDuration1UnitChanged);
	idx = this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration1_Min.unitIndex();
    this.ToneRemoteDuration1UnitChanged(idx);
    
	this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration2_Min['unitChanged(int)'].connect(this, this.ToneRemoteDuration2UnitChanged);
	idx = this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration2_Min.unitIndex();
    this.ToneRemoteDuration2UnitChanged(idx);
    
	this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration3_Min['unitChanged(int)'].connect(this, this.ToneRemoteDuration3UnitChanged);
	idx = this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration3_Min.unitIndex();
    this.ToneRemoteDuration3UnitChanged(idx);
    
    this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1LevelUnit_Thumb.currentIndexChanged.connect(this, this.GenLevelUnitChanged);
    idx = this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1LevelUnit_Thumb.currentIndex();
    this.GenLevelUnitChanged(idx);
    
    this.ui.stackedWidget.page_Thumb.Tab.widget(1).TwoToneFlagStatus_Thumb.valueChanged.connect(this, this.TwoToneRunningStatusChanged);
    this.ui.stackedWidget.page_Thumb.Tab.widget(2).ToneRemoteFlagStatus_Thumb.valueChanged.connect(this, this.ToneRemoteRunningStatusChanged);
    this.ui.stackedWidget.page_Thumb.Tab.widget(3).ToneSeqFlagStatus_Thumb.valueChanged.connect(this, this.ToneSeqRunningStatusChanged);
}

Initialize.prototype.resize = function(size)
{
    if (size == "Thumb") {
        this.ui.stackedWidget.setCurrentIndex(0);
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(1);
	}
}

Initialize.prototype.TwoToneRunningStatusChanged = function(running)
{
	if (running)
	{
		this.ui.stackedWidget.page_Thumb.Tab.widget(1).TwoToneRun_Thumb.LabelText = "Stop";	
		this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneRun_Min.LabelText = "Stop";
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.Tab.widget(1).TwoToneRun_Thumb.LabelText = "Run";	
		this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneRun_Min.LabelText = "Run";
	}
}

Initialize.prototype.ToneRemoteRunningStatusChanged = function(running)
{
	if (running)
	{
		this.ui.stackedWidget.page_Thumb.Tab.widget(2).ToneRemoteRun_Thumb.LabelText = "Stop";	
		this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteRun_Min.LabelText = "Stop";
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.Tab.widget(2).ToneRemoteRun_Thumb.LabelText = "Run";	
		this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteRun_Min.LabelText = "Run";
	}
}

Initialize.prototype.ToneSeqRunningStatusChanged = function(running)
{
	if (running)
	{
		this.ui.stackedWidget.page_Thumb.Tab.widget(3).ToneSeqRun_Thumb.LabelText = "Stop";	
		this.ui.stackedWidget.page_Min.Tab_2.widget(3).ToneSeqRun_Min.LabelText = "Stop";
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.Tab.widget(3).ToneSeqRun_Thumb.LabelText = "Run";	
		this.ui.stackedWidget.page_Min.Tab_2.widget(3).ToneSeqRun_Min.LabelText = "Run";
	}
}

Initialize.prototype.Gen1UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1Freq_Thumb.Precision = 4;
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen1Freq_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1Freq_Thumb.Precision = 1;
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen1Freq_Min.Precision = 1;
			break;
	}
	
	this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1Freq_Thumb.setUnitIndex(idx);
	this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen1Freq_Min.setUnitIndex(idx);
}

Initialize.prototype.Gen2UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen2Freq_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen2Freq_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.TwoToneLevelUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Thumb.Tab.widget(1).TwoToneLevel_Thumb.Precision = 2;
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneLevel_Min.Precision = 2;
			break;
		case 1:
			this.ui.stackedWidget.page_Thumb.Tab.widget(1).TwoToneLevel_Thumb.Precision = 0;
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneLevel_Min.Precision = 0;
			break;
	}
	
	this.ui.stackedWidget.page_Thumb.Tab.widget(1).TwoToneLevel_Thumb.setUnitIndex(idx);
	this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneLevel_Min.setUnitIndex(idx);
}

Initialize.prototype.TwoToneFreqAUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneAFreq_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneAFreq_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.TwoToneFreqBUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneBFreq_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneBFreq_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.TwoToneDurationAUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneADuration_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneADuration_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.TwoToneDurationBUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneBDuration_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneBDuration_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.TwoToneSpaceUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneSpace_Min.Precision = 3;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(1).TwoToneSpace_Min.Precision = 0;
			break;
	}
}

Initialize.prototype.ToneRemoteFreq1UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq1_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq1_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.ToneRemoteFreq2UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq2_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq2_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.ToneRemoteFreq3UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq3_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteFreq3_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.ToneRemoteDuration1UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration1_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration1_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.ToneRemoteDuration2UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration2_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration2_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.ToneRemoteDuration3UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration3_Min.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.Tab_2.widget(2).ToneRemoteDuration3_Min.Precision = 1;
			break;
	}
}

Initialize.prototype.GenLevelUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0: //volts
			this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1Level_Thumb.Precision = 3;
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen1Level_Min.Precision = 3;
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen2Level_Min.Precision = 3;
			break;
		case 1: //millivolts
			this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1Level_Thumb.Precision = 0;
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen1Level_Min.Precision = 0;
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen2Level_Min.Precision = 0;
			break;
		case 2: //dBm
			this.ui.stackedWidget.page_Thumb.Tab.widget(0).Gen1Level_Thumb.Precision = 2;
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen1Level_Min.Precision = 2;
			this.ui.stackedWidget.page_Min.Tab_2.widget(0).Gen2Level_Min.Precision = 2;
			break;
	}
}
