function Initialize(tile, engine, system)
{
	tile.disableState("Max");
	this.ui = tile.getContainerFrame();
	this.system = system;
    this.fileBrowser = this.system.getSystemScreen("FileBrowser3550");
    this.ui.BrowseButton.clicked.connect(this, this.showFileBrowser);
    this.ui.LastFilePath.hide();
}

Initialize.prototype.showFileBrowser = function()
{
	this.fileBrowser.fileSelected.connect(this, this.fileSelected);
	this.fileBrowser.setRootPath("/USER/freqlist");
	this.updateLastPath(this.ui.LastFilePath.text);
	this.fileBrowser.setButtonText("Select");
	this.fileBrowser.show();
}

Initialize.prototype.fileSelected = function(fileName)
{
	var filter = this.ui.FilePathName.getEventFilter();
	filter.submitWidgetValue(fileName);
	this.fileBrowser.fileSelected.disconnect(this, this.fileSelected);
}

Initialize.prototype.updateLastPath = function(path)
{
	if (this.ui.LastFilePath.text != "")
    {
    	this.fileBrowser.setCurrentPath(path);
    }
}