function Initialize(tile, engine, system)
{
    this.ui = tile.getContainerFrame();
    this.system = system;
    this.fileBrowser = this.system.getSystemScreen("FileBrowser3550");
    this.ui.BrowseButton.clicked.connect(this, this.showFileBrowser);
    this.ui.Range['valueChanged(int)'].connect(this, this.updateRange);
    this.updateRange();
    
    var widgetConnector = system.getModule("WidgetConnector");
    var filter = widgetConnector.connectWidget(this.ui.FilePathName);
    filter.submit.connect(this, this.fileNameChanged);
    
    this.ui.FilePath.hide();
    this.ui.QCPPushButton_3.hide();
    
    if (this.ui.FilePath.text != "")
    {
    	filter = this.ui.FilePath.getEventFilter();
		filter.submitWidgetValue(this.ui.FilePath.text);
	}	
	
	this.ui.FilePath.textChanged.connect(this, this.updateFileInfo);
	this.updateFileInfo();
}

Initialize.prototype.showFileBrowser = function()
{
	this.fileBrowser.fileSelected.connect(this, this.fileSelected);
	this.fileBrowser.setRootPath("/USER/freqlist");
	this.fileBrowser.setButtonText("Select");
	this.fileBrowser.show();
}

Initialize.prototype.fileSelected = function(fileName)
{
	var filter = this.ui.FilePath.getEventFilter();
	filter.submitWidgetValue(fileName);
	this.fileBrowser.fileSelected.disconnect(this, this.fileSelected);
}

Initialize.prototype.updateFileInfo = function()
{	
	var fullPath = this.ui.FilePath.text;	
	var fileArr = fullPath.split("/");
	
	var filePathStr = "";
	for (var i = 0; i < fileArr.length-1; i++)
	{
		filePathStr += fileArr[i] + "/";
	}	
	this.ui.FilePathDirectory.text = filePathStr;
	
	var fileNameStr = fileArr[fileArr.length-1];
	this.ui.FilePathName.text = fileNameStr;
}

Initialize.prototype.fileNameChanged = function(fileName)
{
	var filter = this.ui.FilePath.getEventFilter();
	filter.submitWidgetValue(this.ui.FilePathDirectory.text + fileName);
}

Initialize.prototype.updateRange = function()
{
	var range = this.ui.Range.value();
	
	var num1 = range;
	var num2 = range+1;
	var num3 = range+2;
	var num4 = range+3;
	
	this.ui.RowLabel1.setText(num1.toString());
	this.ui.RowLabel2.setText(num2.toString());
	this.ui.RowLabel3.setText(num3.toString());
	this.ui.RowLabel4.setText(num4.toString());
}