function Initialize(tile, engine, system)
{
    this.ui = tile.getContainerFrame();
    this.ui.TCXO_RunState.currentIndexChanged.connect(this, this.toggleSave);
    this.ui.TCXO_RunState.hide();
    this.tile = tile;
    
    var state = this.ui.TCXO_RunState.currentIndex();
    this.toggleSave(state);
    
    this.ui.FlagStatus_Cal.changeState.connect(this, this.showCal);
    this.ui.FlagStatus_Run.changeState.connect(this, this.checkButtons);
    this.ui.PushButton_Run.clicked.connect(this, this.showRun);
    this.showRun();
    
    tile.WindowOpened.connect(this, this.showEvent);
    
    this.system = system;
}

Initialize.prototype.toggleSave = function(newState) 
{
	if (newState == 1) {
		this.ui.QCPNumeric.show();
		this.ui.PushButton_Save.show();
	} else {
		this.ui.QCPNumeric.hide();
		this.ui.PushButton_Save.hide();
	}
}

Initialize.prototype.showCal = function(state) 
{
	//we don't care about the state of the cal, but if it changes,
	//cal needs to be shown
	this.ui.FlagStatus_Run.hide();
	this.ui.FlagStatus_Cal.show();
}

Initialize.prototype.checkButtons = function(state)
{	
	if (state == "Tripped")
	{		
		this.ui.PushButton_Export.hide();
		this.ui.PushButton_Import.hide();
	}
	else if (state == "Normal")
	{		
		this.ui.PushButton_Export.show();
		this.ui.PushButton_Import.show();
	}
}

Initialize.prototype.showRun = function() 
{
	this.ui.FlagStatus_Cal.hide();
	this.ui.FlagStatus_Run.show();
}

Initialize.prototype.showEvent = function()
{
	var screen = this.system.getSystemScreen("3550_Calibration_Login");
	if (screen != null)
	{
		if (screen.getContainerFrame().TextEntry_Pw.text != "9992")
		{
			this.tile.hide();
			screen.show();
		}
	}
}