function Initialize(tile, engine, system)
{
	this.system = system;
	tile.changeSize.connect(this, this.resize);
    this.ui = tile.getContainerFrame();
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Type.currentIndexChanged.connect(this, this.typeChanged);
    var idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Type.currentIndex();
    this.typeChanged(idx);
    this.ui.stackedWidget.page_2.Tab.widget(2).QCPComboBox_Scale.currentIndexChanged.connect(this, this.scaleChanged);
    this.ui.stackedWidget.page_2.Tab.widget(2).Numeric_Top['valueChanged(double, QString)'].connect(this, this.rescale);
    this.ui.stackedWidget.page_2.Tab.widget(2).Numeric_Bottom['valueChanged(double, QString)'].connect(this, this.rescale);
    
	tile.WindowOpened.connect(this, this.showEvent);
	tile.WindowClosed.connect(this, this.hideEvent);
	
	this.fileBrowser = this.system.getSystemScreen("FileBrowser3550");
    
    this.ui.stackedWidget.page_2.Tab.widget(4).Button_StoreTrace.clicked.connect(this, this.showStoreBrowser);
    this.ui.stackedWidget.page_2.Tab.widget(4).Button_RecallTrace.clicked.connect(this, this.showRecallBrowser);
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_StoreCable.clicked.connect(this, this.showStoreCableBrowser);
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_RecallCable.clicked.connect(this, this.showRecallCableBrowser);
    
    this.ui.stackedWidget.page_2.Tab.widget(4).Button_Save.hide();
    this.ui.stackedWidget.page_2.Tab.widget(4).Button_Load.hide();
    this.ui.stackedWidget.page_2.Tab.widget(4).QCPTextEntry.hide();
    
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(2).QCPComboBox_Scale.currentIndex();
    this.scaleChanged(idx); 
    
    this.rescale(0, "base_unit");
    
    try 
    { 
        this.ui.stackedWidget.page_2.Tab.widget(1).PlotMarker.attachPlot(this.ui.PlotManager);
    } 
    catch(e) 
    { 
        print("Failed to attach: "+e); 
    }
    
    this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Start['unitChanged(int)'].connect(this, this.startFreqUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Stop['unitChanged(int)'].connect(this, this.stopFreqUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Freq['unitChanged(int)'].connect(this, this.centerFreqUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Span['unitChanged(int)'].connect(this, this.spanUnitChanged);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Start.unitIndex();
    this.startFreqUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Stop.unitIndex();
    this.stopFreqUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Freq.unitIndex();
    this.centerFreqUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Span.unitIndex();
    this.spanUnitChanged(idx);
    
    this.showEvent();
    
    this.ui.stackedWidget.page_2.Tab.widget(3).Text_Cable.hide();
    this.ui.stackedWidget.page_2.Tab.widget(3).Text_Cable.textChanged.connect(this, this.updateCableLabel);
    this.updateCableLabel();
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
    } else if (size == "Min") {
        this.ui.stackedWidget.setCurrentIndex(0);
    }
}

Initialize.prototype.typeChanged = function(idx)
{

	if (Number(idx) == 1) {
	
		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Freq.hide();
		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Start.hide();
		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Stop.hide();
		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Span.hide();
		
		this.ui.stackedWidget.page_2.Tab.widget(2).QCPComboBox_EstLength.show();
		this.ui.stackedWidget.page_2.Tab.widget(2).QCPComboBox_Unit.show();
		//this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Loss.show();
		//this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Velocity.show();
		//this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Cable.show();
		this.ui.stackedWidget.page_2.Tab.widget(0).Combo_DtfYUnit.show();
	
	} else {
		this.ui.stackedWidget.page_2.Tab.widget(2).QCPComboBox_EstLength.hide();
		this.ui.stackedWidget.page_2.Tab.widget(2).QCPComboBox_Unit.hide();
		//this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Loss.hide();
		//this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Velocity.hide();
		//this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Cable.hide();
		this.ui.stackedWidget.page_2.Tab.widget(0).Combo_DtfYUnit.hide();
	
		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Freq.show();
		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Start.show();
		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Stop.show();
		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Span.show();
	}	

}

Initialize.prototype.scaleChanged = function(idx)
{
	if (Number(idx) == 0) {
		this.ui.stackedWidget.page_2.Tab.widget(2).Numeric_Top.hide();
		this.ui.stackedWidget.page_2.Tab.widget(2).Numeric_Bottom.hide();
	} else {
		this.ui.stackedWidget.page_2.Tab.widget(2).Numeric_Top.show();
		this.ui.stackedWidget.page_2.Tab.widget(2).Numeric_Bottom.show();
	}
}


Initialize.prototype.rescale = function(value, unit) {


	var ul = this.ui.stackedWidget.page_2.Tab.widget(2).Numeric_Top.value(); 
	var ll = this.ui.stackedWidget.page_2.Tab.widget(2).Numeric_Bottom.value();

	this.ui.PlotManager.YLeftUpperLimit = ul;
	this.ui.PlotManager.YLeftLowerLimit = ll;
	
	this.ui.PlotManager.YRightUpperlimit = ul;
	this.ui.PlotManager.YRightLowerLimit = ll;


}

Initialize.prototype.showEvent = function() 
{
	var engName = "Tracking Generator";
	var instNum = "1";
    
    //var trackGenEnable = this.system.getModule("AdapterList").scriptResolve(engName+":"+instNum, "State1");
    //trackGenEnable.set(false);
    
    engName = "Analyzer";

    var analyzerEnable = this.system.getModule("AdapterList").scriptResolve(engName+":"+instNum, "State1");
    analyzerEnable.set(false);

	//get analyzer and track gen and hide them
	var screen = this.system.getSystemScreen("3550_Analyzer");
	if (screen != null)
	{
		screen.hide();
	}
	
	screen = this.system.getSystemScreen("3550_WideAnalyzer");
	if (screen != null)
	{
		screen.hide();
	}
	
	screen = this.system.getSystemScreen("3550_Tracking_Gen");
	if (screen != null)
	{
		screen.hide();
	}
	
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).QCPToggleButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(true);
	}
}

Initialize.prototype.hideEvent = function()
{
	//turn off
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).QCPToggleButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(false);
	}
}

Initialize.prototype.startFreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Start.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Start.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Start.Precision = 3;
			break;
	}
}

Initialize.prototype.stopFreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Stop.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Stop.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Stop.Precision = 3;
			break;
	}
}

Initialize.prototype.centerFreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Freq.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Freq.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Freq.Precision = 3;
			break;
	}
}

Initialize.prototype.spanUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Span.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Span.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Span.Precision = 3;
			break;
	}
}

Initialize.prototype.showStoreBrowser = function()
{
	this.fileBrowser.WindowClosed.connect(this, this.hideStoreBrowserEvent);
	this.fileBrowser.fileSelected.connect(this, this.storeTrace);
	this.fileBrowser.setRootPath("/USER/traces_ant_cable");
	this.fileBrowser.setButtonText("Store");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.showRecallBrowser = function()
{
	this.fileBrowser.WindowClosed.connect(this, this.hideRecallBrowserEvent);
	this.fileBrowser.fileSelected.connect(this, this.recallTrace);
	this.fileBrowser.setRootPath("/USER/traces_ant_cable");
	this.fileBrowser.setButtonText("Recall");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.hideStoreBrowserEvent = function()
{
	this.fileBrowser.fileSelected.disconnect(this, this.storeTrace);
	this.fileBrowser.WindowClosed.disconnect(this, this.hideStoreBrowserEvent);
}

Initialize.prototype.hideRecallBrowserEvent = function()
{
	this.fileBrowser.fileSelected.disconnect(this, this.recallTrace);
	this.fileBrowser.WindowClosed.disconnect(this, this.hideRecallBrowserEvent);
}

Initialize.prototype.storeTrace = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(4).QCPTextEntry.getEventFilter();
	filter.submitWidgetValue(fileName);
	
	filter = this.ui.stackedWidget.page_2.Tab.widget(4).Button_Save.getEventFilter();
	filter.submitWidgetVoid();
	
	this.fileBrowser.fileSelected.disconnect(this, this.storeTrace);
}

Initialize.prototype.recallTrace = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(4).QCPTextEntry.getEventFilter();
	filter.submitWidgetValue(fileName);
	
	filter = this.ui.stackedWidget.page_2.Tab.widget(4).Button_Load.getEventFilter();
	filter.submitWidgetVoid();
	
	this.fileBrowser.fileSelected.disconnect(this, this.recallTrace);
}

Initialize.prototype.showStoreCableBrowser = function()
{
	this.fileBrowser.fileSelected.connect(this, this.cableSelected);
	this.fileBrowser.setRootPath("/USER/cable");
	this.fileBrowser.setButtonText("Store");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.showRecallCableBrowser = function()
{
	this.fileBrowser.fileSelected.connect(this, this.cableSelected);
	this.fileBrowser.setRootPath("/USER/cable");
	this.fileBrowser.setButtonText("Recall");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.cableSelected = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(3).Text_Cable.getEventFilter();
	filter.submitWidgetValue(fileName);
	this.fileBrowser.fileSelected.disconnect(this, this.cableSelected);
}

Initialize.prototype.updateCableLabel = function()
{
	var strArr = this.ui.stackedWidget.page_2.Tab.widget(3).Text_Cable.text.split("/");
	var labelText = strArr[strArr.length-1];
	strArr = labelText.split(".");
	labelText = strArr[0];
	this.ui.stackedWidget.page_2.Tab.widget(3).CableLabel.text = labelText;
}