function Initialize(tile, engine, system)
{
	tile.enableState("Thumb");
	tile.disableState("Max");
    tile.configureState("Min", "200|400");
    tile.configureState("Thumb", "200|200");
    tile.setDefaultState("Thumb");
    tile.showSendToBackButton(false);
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    this.resize("Thumb");
    
    this.ui.stackedWidget.page_2.QCPNumericValueObj_4['unitChanged(int)'].connect(this, this.freqThumbUnitChanged);
    this.ui.stackedWidget.page.QCPNumericValueObj['unitChanged(int)'].connect(this, this.freqMinUnitChanged);
    
    var idx = this.ui.stackedWidget.page_2.QCPNumericValueObj_4.unitIndex();
    this.freqThumbUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page.QCPNumericValueObj.unitIndex();
    this.freqMinUnitChanged(idx);
    
    this.ui.stackedWidget.page.Combo_Modulation.currentIndexChanged.connect(this, this.modulationChanged);
    this.ui.stackedWidget.page_2.Combo_ThumbMod.currentIndexChanged.connect(this, this.modulationChanged);
    
    idx = this.ui.stackedWidget.page.Combo_Modulation.currentIndex();
    this.modulationChanged(idx);
    
    this.ui.stackedWidget.page.QCPNumericValueObj_2['valueChanged(double, QString)'].connect(this, this.offsetValueChanged);
    var val = this.ui.stackedWidget.page.QCPNumericValueObj_2.value();
    this.offsetValueChanged(val, "");
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(0);
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(1);
    }   	
}

Initialize.prototype.freqThumbUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_2.QCPNumericValueObj_4.Precision = 6;
			break;
		case 1:
			this.ui.stackedWidget.page_2.QCPNumericValueObj_4.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.QCPNumericValueObj_4.Precision = 3;
			break;
		case 3:
			this.ui.stackedWidget.page_2.QCPNumericValueObj_4.Precision = 0;
			break;
	}
}

Initialize.prototype.freqMinUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page.QCPNumericValueObj.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page.QCPNumericValueObj.Precision = 6;
			break;
		case 2:
    		this.ui.stackedWidget.page.QCPNumericValueObj.Precision = 3;
			break;
		case 3:
    		this.ui.stackedWidget.page.QCPNumericValueObj.Precision = 0;
			break;
	}
}

Initialize.prototype.modulationChanged = function(idx)
{
	if ( (this.ui.stackedWidget.page.Combo_Modulation.text() == "PTC") || idx > 1)
	{
		if((this.ui.stackedWidget.page.Combo_Modulation.text() != "DMR"))
		{
			this.ui.stackedWidget.page.QCPComboBox.hide();
			this.ui.stackedWidget.page.QCPComboBox_2.hide();
		
			this.ui.stackedWidget.page_2.QCPComboBox_5.hide();
			this.ui.stackedWidget.page_2.QCPComboBox_8.hide();

			this.ui.stackedWidget.page.PushButton.show();
			
			if (idx == 10)
			{
				this.ui.stackedWidget.page.QCPComboBox.show();
				this.ui.stackedWidget.page_2.QCPComboBox_8.show();
			}
			
		} else {
			this.ui.stackedWidget.page.QCPComboBox.hide();
			this.ui.stackedWidget.page.QCPComboBox_2.hide();
		
			this.ui.stackedWidget.page_2.QCPComboBox_5.hide();
			this.ui.stackedWidget.page_2.QCPComboBox_8.hide();

			this.ui.stackedWidget.page.PushButton.hide();

		}
	}
	else
	{
		this.ui.stackedWidget.page.QCPComboBox.show();
		this.ui.stackedWidget.page.QCPComboBox_2.show();
		
		this.ui.stackedWidget.page_2.QCPComboBox_5.show();
		this.ui.stackedWidget.page_2.QCPComboBox_8.show();

		this.ui.stackedWidget.page.PushButton.show();
	}
}

Initialize.prototype.offsetValueChanged = function(value, unit)
{
	if (value < 0)
		this.ui.stackedWidget.page.QCPNumericValueObj_2.LabelText = "Loss";
	else if (value == 0)
		this.ui.stackedWidget.page.QCPNumericValueObj_2.LabelText = "Offset";
	else
		this.ui.stackedWidget.page.QCPNumericValueObj_2.LabelText = "Gain"; 
}