function Initialize(tile, engine, system)
{
	tile.disableState("Max");
    this.ui = tile.getContainerFrame();
    this.ui.MeasureType.currentIndexChanged.connect(this, this.typeChanged);
    var idx = this.ui.MeasureType.currentIndex();
    this.typeChanged(idx);
    this.ui.BirdSensor.toggled.connect(this, this.toggleAll);
    this.ui.Internal.toggled.connect(this, this.toggleAll);
    var state = this.ui.BirdSensor.activeState();
    this.toggleAll(state);
    
    this.ui.State.hide();
    this.ui.StateButton.hide();
    this.ui.BirdSensor.hide();
    this.ui.Test.hide();
    this.ui.Internal.hide();
    this.ui.Temperature.hide();
    
    this.ui.ForwardUnits.currentIndexChanged.connect(this, this.forwardUnitsChanged);
    this.ui.ReflectedUnits.currentIndexChanged.connect(this, this.reflectedUnitsChanged);
    
    this.forwardUnitsChanged();
    this.reflectedUnitsChanged();
    
    tile.WindowOpened.connect(this, this.showEvent);
	tile.WindowClosed.connect(this, this.hideEvent);
}

Initialize.prototype.toggleAll = function()
{
	var birdState = this.ui.BirdSensor.State;
	var internalState = this.ui.Internal.State;
	
	if (birdState)
	{
		this.ui.MeasureType.show();
		this.ui.Filter.show();
		this.ui.Offset.show();
		this.ui.Zero.show();
		this.ui.Forward.show();
		this.ui.ForwardUnits.show();
		this.ui.DutyCycleAvg.show();
		this.ui.Temperature.show();
		
		var idx = this.ui.MeasureType.currentIndex();
		this.typeChanged(idx);
		
		this.ui.EmptyLabel.hide();
	}
	else
	{
		if (internalState)
		{
			this.ui.EmptyLabel.Text = "Connecting to In-Line Power Sensor";
		}
		else
		{
			this.ui.EmptyLabel.Text = "Connect External Power Sensor";
		}
		
		this.ui.EmptyLabel.show();
		this.ui.MeasureType.hide();
		this.ui.Filter.hide();
		this.ui.Offset.hide();
		this.ui.Zero.hide();
		this.ui.Forward.hide();
		this.ui.ForwardUnits.hide();
		this.ui.Reflected.hide();
		this.ui.ReflectedUnits.hide();
		this.ui.Match.hide();
		this.ui.MatchUnits.hide();
		this.ui.DutyCycle.hide();
		this.ui.CCDF.hide();
		this.ui.DutyCycleAvg.hide();
		this.ui.Temperature.hide();
	}
}

Initialize.prototype.typeChanged = function(idx)
{
	var state = this.ui.BirdSensor.activeState();
	if (state)
	{
	    this.ui.Reflected.hide();
	    this.ui.ReflectedUnits.hide();
	    this.ui.Match.hide();
	    this.ui.MatchUnits.hide();
	    this.ui.DutyCycle.hide();
	    this.ui.CCDF.hide();
	    this.ui.Offset.show();
	    this.ui.DutyCycleAvg.hide();
	
		switch (Number(idx))
	    {
	        case 1:
	            this.ui.Reflected.show();
	            this.ui.ReflectedUnits.show();
	            this.ui.Match.show();
	    		this.ui.MatchUnits.show();
	    		this.ui.DutyCycleAvg.show();
	            break;
	        case 2:
	        	this.ui.Match.show();
	        	this.ui.MatchUnits.show();
	        	break;
	        case 3:
	            this.ui.DutyCycle.show();
	            break;
	        case 4:
	        	this.ui.Offset.hide();
	        	break;
	        case 5:
	            this.ui.CCDF.show();
	            this.ui.Offset.hide();
	            break;
	    }
    }
}

Initialize.prototype.forwardUnitsChanged = function()
{
	var idx = this.ui.ForwardUnits.currentIndex();
	
	if (idx == 6)
	{
		this.ui.Forward.Precision = 1;
	}
	else
	{
		this.ui.Forward.Precision = 2;
	}
}

Initialize.prototype.reflectedUnitsChanged = function()
{
	var idx = this.ui.ReflectedUnits.currentIndex();
	
	if (idx == 6)
	{
		this.ui.Reflected.Precision = 1;
	}
	else
	{
		this.ui.Reflected.Precision = 2;
	}
}

Initialize.prototype.showEvent = function() 
{
	var filter = this.ui.StateButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(true);
	}
}

Initialize.prototype.hideEvent = function()
{
	var filter = this.ui.StateButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(false);
	}
}