function Initialize(tile, engine, system)
{
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_VOffset['valueChanged(double, QString)'].connect(this, this.vOffsetChanged);
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Source.currentIndexChanged.connect(this, this.sourceChanged);
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_VertScale.currentIndexChanged.connect(this, this.rescale);
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_4.currentIndexChanged.connect(this, this.horizontalRescale);
    var idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Source.currentIndex();
    this.sourceChanged(idx);
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_VertScale.currentIndex();
    this.rescale(idx);
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_4.currentIndex();
    this.horizontalRescale(idx);
    
    
	tile.WindowClosed.connect(this, this.hideEvent);
	tile.WindowOpened.connect(this, this.showEvent);
    
    try 
    { 
        this.ui.stackedWidget.page_2.Tab.widget(2).PlotMarker.attachPlot(this.ui.PlotManager);
    } 
    catch(e) 
    { 
        print("Failed to attach: "+e); 
    }
    
    this.fileBrowser = system.getSystemScreen("FileBrowser3550");
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_StoreTrace.clicked.connect(this, this.showStoreBrowser);
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_RecallTrace.clicked.connect(this, this.showRecallBrowser);
    
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_Save.hide();
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_Load.hide();
    this.ui.stackedWidget.page_2.Tab.widget(3).Text_File.hide();
    
    if (tile.isVisible())
    {
    	this.showEvent();
    }
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
    } else if (size == "Min") {
        this.ui.stackedWidget.setCurrentIndex(0);
    }
}

Initialize.prototype.sourceChanged = function(idx)
{
    switch(Number(idx)) {
        case 0:	//DVM
            this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Div.show();
            this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_InputRange.hide();
            this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_InputLoad.hide();
            this.ui.stackedWidget.page_2.Tab.widget(0).PushButton_Zero.show();
            break;
        case 1:	//Demod
        	this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Div.hide();
            this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_InputRange.hide();
            this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_InputLoad.hide();
            this.ui.stackedWidget.page_2.Tab.widget(0).PushButton_Zero.hide();
        	break;
        case 2:	//Audio In
            this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Div.hide();
            this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_InputRange.show();
            this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_InputLoad.show();
            this.ui.stackedWidget.page_2.Tab.widget(0).PushButton_Zero.hide();
            break;
    }
}

Initialize.prototype.rescale = function(idx)
{
	var scale = 0.00
	var ul = 0.00;
	var ll = 0.00;
	var vOffset = 0.00;
	
	var source = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_Source.currentIndex();

    if (source == 0 || source == 2) {

	    switch(Number(idx)) {
		    case 0:
                scale = .01
			    break;
		    case 1:
                scale = .02
			    break;	
		    case 2:
                scale = .05
			    break;
		    case 3:
                scale = .1
			    break;
		    case 4:
                scale = .2
			    break;
		    case 5:
                scale = .5
			    break;
		    case 6:
                scale = 1.0
			    break;
		    case 7:
                scale = 2.0
			    break;
		    case 8:
                scale = 5.0
			    break;
		    case 9:
                scale = 10.0
			    break;
			default:
				scale = 0;
				break;
	    }
    } else {
    
		//if AM    
		var text = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_VertScale.text();
		if (text.search("kHz") == -1) {
	    	switch(Number(idx)) {
	    		case 0:
					scale = 5;
					break;
				case 1:
					scale = 10;
					break;
				case 2:
					scale = 20;
					break;
				case 3:
					scale = 50;
					break;
				default:
					scale = 0;
					break;
	    	}
	    	
	    } else {
	    	switch(Number(idx)) {
	    		case 0:
	    			scale = 0.1;
	    			break;
	    		case 1:
	    			scale = 0.2;
	    			break;
    			case 2:
	    			scale = 0.5;
	    			break;
	    		case 3:
	    			scale = 1;
	    			break;
	    		case 4:
	    			scale = 2;
	    			break;
	    		case 5:
	    			scale = 5;
	    			break;
	    		case 6:
	    			scale = 10;
	    			break;
    			case 7:
	    			scale = 20;
	    			break;
	    		case 8:
	    			scale = 50;
	    			break;
	    	}
	    	
	    }
    }
    
    vOffset =  Number(this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_VOffset.value());
    
    ul = scale * 4 + vOffset;
    ll = scale * -4 + vOffset;
	
	this.ui.PlotManager.YLeftUpperLimit = ul;
	this.ui.PlotManager.YLeftLowerLimit = ll;
	this.ui.PlotManager.YRightUpperlimit = ul;
	this.ui.PlotManager.YRightLowerLimit = ll;
}

Initialize.prototype.horizontalRescale = function(idx) {

	var span = 0.0;
	switch(Number(idx)) {
	
		case 0:
			span = 0.5;
			break;
		case 1:
			span = 1.0;
			break;
		case 2:
			span = 2.0;
			break;
		case 3:
			span = 4.0;
			break;
		case 4:
			span = 6.0;
			break;
		case 5:
			span = 10.0;
			break;
		case 6:
			span = 20.0;
			break;
		case 7:
			span = 50.0;
			break;
		case 8:
			span = 100.0;
			break;

	}
	
	this.ui.PlotManager.XBottomLowerLimit = 0;
	this.ui.PlotManager.XBottomUpperLimit = span*10;

}

Initialize.prototype.vOffsetChanged = function(value, unit) {
	
	var idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_VertScale.currentIndex();
    this.rescale(idx);	

}

Initialize.prototype.showStoreBrowser = function()
{
	this.fileBrowser.WindowClosed.connect(this, this.hideStoreBrowserEvent);
	this.fileBrowser.fileSelected.connect(this, this.storeTrace);
	this.fileBrowser.setRootPath("/USER/traces_oscope");
	this.fileBrowser.setButtonText("Store");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.showRecallBrowser = function()
{
	this.fileBrowser.WindowClosed.connect(this, this.hideRecallBrowserEvent);
	this.fileBrowser.fileSelected.connect(this, this.recallTrace);
	this.fileBrowser.setRootPath("/USER/traces_oscope");
	this.fileBrowser.setButtonText("Recall");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.hideStoreBrowserEvent = function()
{
	this.fileBrowser.fileSelected.disconnect(this, this.storeTrace);
	this.fileBrowser.WindowClosed.disconnect(this, this.hideStoreBrowserEvent);
}

Initialize.prototype.hideRecallBrowserEvent = function()
{
	this.fileBrowser.fileSelected.disconnect(this, this.recallTrace);
	this.fileBrowser.WindowClosed.disconnect(this, this.hideRecallBrowserEvent);
}

Initialize.prototype.storeTrace = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(3).Text_File.getEventFilter();
	filter.submitWidgetValue(fileName);
	
	filter = this.ui.stackedWidget.page_2.Tab.widget(3).Button_Save.getEventFilter();
	filter.submitWidgetVoid();
}

Initialize.prototype.recallTrace = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(3).Text_File.getEventFilter();
	filter.submitWidgetValue(fileName);
	
	filter = this.ui.stackedWidget.page_2.Tab.widget(3).Button_Load.getEventFilter();
	filter.submitWidgetVoid();
}

Initialize.prototype.hideEvent = function()
{
	//turn off
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).QCPToggleButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(false);
	}
}

Initialize.prototype.showEvent = function()
{
	//turn on
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).QCPToggleButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(true);
	}
}