var DatabaseController;

function Initialize(tile, engine, system)
{	
    this.ui = tile.getContainerFrame();
    this.system = system;
    this.setupObjectReferences();
    this.connectButtons();
    
    var storedMetaRadio = DatabaseController.getStoredMetaRadio();
    var storedModelBand = DatabaseController.getStoredModelBand();
    var storedMenu = DatabaseController.getStoredMenu();
    
	this.ui.stackedWidget.MainPage.Tab.widget(1).SimpleScrollArea.setWidg(this.RowContainer);
    this.ui.stackedWidget.MainPage.Tab.widget(1).SimpleScrollArea.setVBar(this.ui.stackedWidget.MainPage.Tab.widget(1).VBar);
    
    this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.setMetaData(DatabaseController.getMetaRadioList());
    this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.setIndex(0);
    
    var widgetConnector = system.getModule("WidgetConnector");
    widgetConnector.connectWidget(this.ui.stackedWidget.MainPage.ControlBar.MetaRadio);
    widgetConnector.connectWidget(this.ui.stackedWidget.MainPage.ControlBar.RadioSelection);
    widgetConnector.connectWidget(this.ui.stackedWidget.MainPage.ControlBar.RadioMenu);
    widgetConnector.connectWidget(this.BrowseResultsTableEnum);
    widgetConnector.connectWidget(this.ManageConfigTableEnum);
    widgetConnector.connectWidget(this.MessageBeepButton);
    widgetConnector.connectWidget(this.EOTBeepButton);
    widgetConnector.connectWidget(this.ExtAttenStateButton);
    widgetConnector.connectWidget(this.ExtLogButton);
    
    this.ExtAttenStateButton.State = DatabaseController.getExtAttenState();
    this.setExtAttenState(this.ExtAttenStateButton.State);
    
    this.MessageBeepButton.toggled.connect(this, this.messageBeepToggled);
    this.EOTBeepButton.toggled.connect(this, this.eotBeepToggled);
    this.ExtLogButton.toggled.connect(this, this.extLogToggled);
    this.ResetSkipButton.clicked.connect(this, this.resetSkipClicked);
    
    for (var i = 0; i < this.optionsToggle.length; i++)
    {
    	widgetConnector.connectWidget(this.optionsToggle[i]);
	}
	this.optionsToggle[0].toggled.connect(this, this.option0Toggled);
	this.optionsToggle[1].toggled.connect(this, this.option1Toggled);
	this.optionsToggle[2].toggled.connect(this, this.option2Toggled);
	this.optionsToggle[3].toggled.connect(this, this.option3Toggled);
	this.optionsToggle[4].toggled.connect(this, this.option4Toggled);
	
	var optionsTextFilter = widgetConnector.connectWidget(this.optionsText[0]);
	optionsTextFilter.submit.connect(this, this.optionIp0Changed);
	
	optionsTextFilter = widgetConnector.connectWidget(this.optionsText[1]);
	optionsTextFilter.submit.connect(this, this.optionIp1Changed);
	
	optionsTextFilter = widgetConnector.connectWidget(this.optionsText[2]);
	optionsTextFilter.submit.connect(this, this.optionIp2Changed);
	
	optionsTextFilter = widgetConnector.connectWidget(this.optionsText[3]);
	optionsTextFilter.submit.connect(this, this.optionIp3Changed);
	
	optionsTextFilter = widgetConnector.connectWidget(this.optionsText[4]);
	optionsTextFilter.submit.connect(this, this.optionIp4Changed);
    
	for (var i = 0; i < this.configLowerLimit.length; i++)
	{
		var ll = this.configLowerLimit[i];
		var filter = widgetConnector.connectWidget(ll, "ValueDouble");
		var emitter = this.llEmitter[i];
		filter['submit(double, QString)'].connect(emitter.sendSignal);
	}
	
	for (var i = 0; i < this.configUpperLimit.length; i++)
	{
		var ul = this.configUpperLimit[i];
		var filter = widgetConnector.connectWidget(ul, "ValueDouble");
		var emitter = this.ulEmitter[i];
		filter['submit(double, QString)'].connect(emitter, emitter.sendSignal);
	}
	
	for (var i = 0; i < this.configTarget.length; i++)
	{
		var target = this.configTarget[i];
		var filter = widgetConnector.connectWidget(target, "ValueDouble");
		var emitter = this.targetEmitter[i];
		filter['submit(double, QString)'].connect(emitter, emitter.sendSignal);
	}
	
	for (var i = 0; i < this.configInfo.length; i++)
	{
		var info = this.configInfo[i];
		var filter = widgetConnector.connectWidget(info);
		var emitter = this.infoEmitter[i];
		filter.submit.connect(emitter, emitter.sendSignal);
	}
	
	for (var i = 0; i < this.configType4Numeric.length; i++)
	{
		var configType4Numeric = this.configType4Numeric[i];
		var filter = widgetConnector.connectWidget(configType4Numeric, "ValueDouble");
		var emitter = this.type4Emitter[i];
		filter['submit(double, QString)'].connect(emitter, emitter.sendSignal);
	}
	
	for (var i = 0; i < this.configType5Numeric.length; i++)
	{
		var configType5Numeric = this.configType5Numeric[i];
		configType5Numeric.Precision = 0;
		var filter = widgetConnector.connectWidget(configType5Numeric, "Double");
		var emitter = this.type5Emitter[i];
		filter['submit(double)'].connect(emitter, emitter.sendSignal);
	}
	
	for (var i = 0; i < this.configToggle.length; i++)
	{
		var configToggle = this.configToggle[i];
		var filter = widgetConnector.connectWidget(configToggle);
		var emitter = this.toggleEmitter[i];
		filter.submit.connect(emitter, emitter.sendSignal);
	}
	
	for (var i = 0; i < this.cableLoss.length; i++)
	{
		var cableLoss = this.cableLoss[i];
		var filter = widgetConnector.connectWidget(cableLoss, "ValueDouble");
		var emitter = this.cableLossEmitter[i];
		filter['submit(double, QString)'].connect(emitter, emitter.sendSignal);
	}
	
	for (var i = 0; i < this.extAtten.length; i++)
	{
		var extAtten = this.extAtten[i];
		var filter = widgetConnector.connectWidget(extAtten, "ValueDouble");
		var emitter = this.extAttenEmitter[i];
		filter['submit(double, QString)'].connect(emitter, emitter.sendSignal);
	}
	
    this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.currentIndexChanged.connect(this, this.updateModelBand);
    this.updateModelBand();
    
    //this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.currentIndexChanged.connect(this, this.updateMenu);
    this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.currentIndexChanged.connect(this, this.updateMenu);
    this.updateMenu();
    
    DatabaseController.enableDualBand.connect(this, this.enableDualBand);
    
    this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.currentIndexChanged.connect(this, this.getTestList);
    DatabaseController.updateTest.connect(this, this.updateTestName);
    DatabaseController.updateConfiguration.connect(this, this.updateConfiguration);
    DatabaseController.updateCableLoss.connect(this, this.updateCableLoss);
    DatabaseController.updateExtAtten.connect(this, this.updateExtAtten);
    DatabaseController.doneUpdatingTests.connect(this, this.updateSelectedTests);
    DatabaseController.updateOptionToggle.connect(this, this.updateOptionToggle);
    DatabaseController.updateOptionText.connect(this, this.updateOptionText);
    
    this.ui.stackedWidget.MainPage.ControlBar.OverallStatus.hide();
    
 	this.SocketController.updateStatus.connect(this, this.updateStatus);
 	this.SocketController.updateTest.connect(this, this.updateTestStatus);
 	this.SocketController.updateTestB.connect(this, this.updateTestStatusB);
 	this.SocketController.updateRadio.connect(this, this.updateRadio);
 	this.SocketController.updateRunningRadio.connect(this, this.updateRunningRadio);
 	
 	this.ui.stackedWidget.MainPage.FreqList.currentIndexChanged.connect(this.SocketController, this.SocketController.sendFreqListSelection);
 	this.ui.stackedWidget.MainPage.FreqList.hide();
 	
 	this.getTestList();
 	
 	this.DebugLabel = this.ui.stackedWidget.MainPage.ControlBar.DebugLabel;
 	this.ui.stackedWidget.MainPage.ControlBar.DebugScrollArea.setWidg(this.DebugLabel);
 	this.ui.stackedWidget.MainPage.ControlBar.DebugScrollArea.hide();
 	this.SocketController.displayDebug.connect(this, this.updateDebugDisplay);
 	this.SocketController.showDebug.connect(this, this.showDebugDisplay);
 	this.SocketController.hideDebug.connect(this, this.hideDebugDisplay);
 	
 	this.ResultsLabel = this.ui.stackedWidget.ResultsPage.ResultsGroupBox.ResultsLabel;
 	this.ResultsVBar = this.ui.stackedWidget.ResultsPage.ResultsGroupBox.ResultsVBar;
 	this.ui.stackedWidget.ResultsPage.ResultsGroupBox.ResultsScrollArea.setWidg(this.ResultsLabel);
 	this.ui.stackedWidget.ResultsPage.ResultsGroupBox.ResultsScrollArea.setVBar(this.ResultsVBar);
 	
 	this.goToHomePage();
 	this.initUnitMap();
 	
    this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.setText(storedMetaRadio);
    this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.setText(storedModelBand);
    this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.setText(storedMenu);
    
    var name = DatabaseController.getStoredConfigName();
    if (name == "")
    	name = "Default"
    this.ConfigCurrentConfig.text = name;
	this.ManageConfigCurrentConfig.text = name;
	if (name == "Default")
		this.ManageConfigStoreButton.Locked = true;
	this.updateSelectedTests();
}

Initialize.prototype.initUnitMap = function()
{
	//units: % , ppm , db , dbm , W, mW , V , mV , uV, A ,mA
	this.unitMap = {};
	this.unitMap["MHz"] = "0,6,5:-1;0:0;0:0;0:0;0:0";
	this.unitMap["KHz"] = "0,3,5:-1;0:0;0:0;0:0;0:0";
	this.unitMap["Hz"] = "0,0,5:-1;0:0;0:0;0:0;0:0";
	this.unitMap["mHz"] = "0,-3,5:-1;0:0;0:0;0:0;0:0";
	this.unitMap["%"] = "0,0,8:1;0:0;0:0;0:0;0:0";
	this.unitMap["ppm"] = "0,0,9:1;0:0;0:0;0:0;0:0";
	this.unitMap["dB"] = "1,0,0:1;0:0;0:0;0:0;0:0";
	this.unitMap["dBm"] = "1,-3,12:1;0:0;0:0;0:0;0:0";
	this.unitMap["W"] = "0,0,12:1;0:0;0:0;0:0;0:0";
	this.unitMap["mW"] = "0,-3,12:1;0:0;0:0;0:0;0:0";
	this.unitMap["V"] = "0,0,13:1;0:0;0:0;0:0;0:0";
	this.unitMap["mV"] = "0,-3,13:1;0:0;0:0;0:0;0:0";
	this.unitMap["uV"] = "0,-6,13:1;0:0;0:0;0:0;0:0";
	this.unitMap["A"] = "0,0,15:1;0:0;0:0;0:0;0:0";
	this.unitMap["mA"] = "0,-3,15:1;0:0;0:0;0:0;0:0";
	this.unitMap[""] = "0,0,0:0;0:0;0:0;0:0;0:0";
}

Initialize.prototype.updateSelectedTests = function()
{
	var testString = DatabaseController.getSelectedTests();
	if (testString != "")
	{
		for (var i = 0; i < this.checkBox.length; i++)
		{
			this.checkBox[i].checked = false;	
		}
		var testList = testString.split(",");
		
		for (var i = 0; i < testList.length; i++)
		{
			var testIdx = testList[i];
			this.checkBox[testIdx].checked = true;
		}
	}
	this.updateCheckedList();
}

Initialize.prototype.updateDebugDisplay = function(debugString)
{
	//print(debugString);
	this.DebugLabel.text = this.DebugLabel.text + "\n" + debugString;
	this.DebugLabel.size = this.DebugLabel.sizeHint;
}

Initialize.prototype.showDebugDisplay = function(debugString)
{
	this.ui.stackedWidget.MainPage.ControlBar.DebugScrollArea.show();
}

Initialize.prototype.hideDebugDisplay = function(debugString)
{
	this.ui.stackedWidget.MainPage.ControlBar.DebugScrollArea.hide();
}

Initialize.prototype.updateModelBand = function()
{
	var metaIndex = this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.currentIndex();
	DatabaseController.setMetaRadio(metaIndex);
	
	var versionString = DatabaseController.getMetaRadioVersion();
    this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.LabelText = "Radio OEM - " + versionString;
	
	this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.setMetaData(DatabaseController.getRadioModelBandList());
	this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.setIndex(0);
	
	this.hideOptions();
	DatabaseController.getOptions();
}

Initialize.prototype.updateMenu = function()
{
	var modelBand = this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.Text;
	var oldIdx = this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.currentIndex();
	this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.setMetaData(DatabaseController.getRadioMenuList(modelBand));
	this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.setIndex(oldIdx);
}

Initialize.prototype.goToHomePage = function()
{
	this.ui.stackedWidget.setCurrentIndex(0);
}

Initialize.prototype.goToConfigurePage = function()
{
	this.ui.stackedWidget.setCurrentIndex(1);
}

Initialize.prototype.goToResultsPage = function()
{
	this.ui.stackedWidget.setCurrentIndex(2);
	//this.ResultsVBar.setValue(0);
}

Initialize.prototype.goToBrowseResultsPage = function()
{
	this.BrowseResultsTableEnum.setMetaData(DatabaseController.getResultsMetaData());
	this.ui.stackedWidget.setCurrentIndex(3);
}

Initialize.prototype.goToManageConfigPage = function()
{
	this.ManageConfigTableEnum.setMetaData(DatabaseController.getConfigMetaData());
	this.ui.stackedWidget.setCurrentIndex(4);
}

Initialize.prototype.viewAllResults = function()
{
	var results = DatabaseController.getAllResults();
	this.setResultsText(results);
	this.goToResultsPage();
}

Initialize.prototype.viewResults = function(idx)
{
	var results = DatabaseController.getResults(idx);
	this.setResultsText( results );
	this.goToResultsPage();
}

Initialize.prototype.selectResults = function()
{
	var idx = this.BrowseResultsTableEnum.currentIndex();
	var results = DatabaseController.getStoredResults(idx);
	this.setResultsText(results);
	this.goToResultsPage();
}

Initialize.prototype.runWait = function()
{
	this.RunButton.Locked = true;
	this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.hide();
	this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.hide();
	this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.hide();
	this.ui.stackedWidget.MainPage.ControlBar.ReadRadio.hide();
	this.ui.stackedWidget.MainPage.ControlBar.OverallStatus.show();
	this.ui.stackedWidget.MainPage.ControlBar.OverallStatus.text = "Initializing run sequence...";
	
	//this.updateCheckedList();
    this.SocketController.startAndRun();
}

Initialize.prototype.run = function()
{
	this.RunButton.hide();
	this.AbortButton.show();
	
	this.invalidateTests();
	
	this.ui.stackedWidget.MainPage.Tab.setCurrentIndex(0);
}

Initialize.prototype.abort = function()
{
	this.RunButton.Locked = false;
	this.ConfigCopyButton.Locked = false;
	this.RunButton.show();
	this.AbortButton.hide();

	this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.show();
	this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.show();
	this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.show();
	this.ui.stackedWidget.MainPage.ControlBar.ReadRadio.show();	
	this.ui.stackedWidget.MainPage.ControlBar.OverallStatus.hide();
	
	for (var i = 0; i < this.summaryStatus.length; i++)
	{
		if (this.summaryStatus[i].text == "R")
		{
			this.summaryStatus[i].text = "A"
			this.summaryStatus[i].styleSheet = "color: yellow;";
			this.statusFlag[i].TrippedLedColor = "yellow";
		}
		
		if (this.summaryStatusB[i].text == "R")
		{
			this.summaryStatusB[i].text = "A"
			this.summaryStatusB[i].styleSheet = "color: yellow;";
			this.statusFlagB[i].TrippedLedColor = "yellow";
		}
	}
}

Initialize.prototype.setResultsText = function(text)
{
	this.ResultsLabel.text = text;
	this.ResultsLabel.size = this.ResultsLabel.sizeHint;
}

Initialize.prototype.updateStatus = function(status)
{
	this.ui.stackedWidget.MainPage.ControlBar.OverallStatus.text = status;
}

Initialize.prototype.updateTestStatus = function(idx, val)
{
	var text = "";
	var color = "";
	switch (val)
	{
		case 0:	//RUNNING
			text = "R";
			this.summaryStatus[idx].text = text;
			color = "#06B7FC";
			break;
		case 1: //PASSED
			text = "P";
			color = "#0afa55";
			break;
		case 2: //FAILED
			text = "F";
			color = "red";
			break;
		case 3: //ABORTED
			text = "A";
			color = "yellow";
			break;
		case 4: //SKIPPED
			text = "S";
			color = "white";
			break;
	}
	this.summaryStatus[idx].text = text;
	this.summaryStatus[idx].styleSheet = "color: " + color + ";";
	this.statusFlag[idx].TrippedLedColor = color;
	this.statusFlag[idx].Value = true;
}

Initialize.prototype.updateTestStatusB = function(idx, val)
{
	var text = "";
	var color = "";
	switch (val)
	{
		case 0:	//RUNNING
			text = "R";
			color = "#06B7FC";
			break;
		case 1: //PASSED
			text = "P";
			color = "#0afa55";
			break;
		case 2: //FAILED
			text = "F";
			color = "red";
			break;
		case 3: //ABORTED
			text = "A";
			color = "yellow";
			break;
		case 4: //SKIPPED
			text = "S";
			color = "white";
			break;
	}
	this.summaryStatusB[idx].text = text;
	this.summaryStatusB[idx].styleSheet = "color: " + color + ";";
	this.statusFlagB[idx].TrippedLedColor = color;
	this.statusFlagB[idx].Value = true;
}

Initialize.prototype.updateRadio = function(modelBand)
{
	this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.show();
	this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.show();
	this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.show();
	this.ui.stackedWidget.MainPage.ControlBar.ReadRadio.show();
	this.ui.stackedWidget.MainPage.ControlBar.OverallStatus.hide();
	
	var menuIdx = this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.currentIndex();
	this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.setText(modelBand);
	this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.setIndex(menuIdx);
}

Initialize.prototype.updateRunningRadio = function(modelBand)
{
	var menuIdx = this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.currentIndex();
	this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.setText(modelBand);
	this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.setIndex(menuIdx);
}

Initialize.prototype.invalidateTests = function()
{
	for (var i = 0; i < this.summaryStatus.length; i++)
	{
		this.summaryStatus[i].text = "-";
		this.summaryStatus[i].styleSheet = "color: white;";
		this.summaryStatusB[i].text = "-";
		this.summaryStatusB[i].styleSheet = "color: white;";
		this.statusFlag[i].TrippedLedColor = "white";
		this.statusFlag[i].Value = true;
		this.statusFlagB[i].TrippedLedColor = "white";
		this.statusFlagB[i].Value = true;
	}
	
	DatabaseController.invalidateTestResults();
}

Initialize.prototype.updateTestName = function(idx, name)
{
	this.summaryLabel[idx].text = name;
	this.summaryLabel[idx].show();
	
	this.summaryStatus[idx].text = "-"
	this.summaryStatus[idx].styleSheet = "color: white;";
	this.summaryStatus[idx].show();
	
	if (this.dualBandEnabled)
	{
		this.summaryStatusB[idx].text = "-"
		this.summaryStatusB[idx].styleSheet = "color: white;";
		this.summaryStatusB[idx].show();
	}
	else
	{
		this.summaryStatusB[idx].hide();
	}
	
	this.testName[idx].text = name;
	this.row[idx].show();
	if (this.dualBandEnabled)
	{
		this.statusFlagB[idx].show();
	}
	else
	{
		this.statusFlagB[idx].hide();
	}
	
	this.checkBox[idx].checked = true;
	if (DatabaseController.hasConfig(idx))
	{
		this.configButton[idx].show();
		this.rowSpacer[idx].hide();
	}
	else
	{
		this.configButton[idx].hide();
		this.rowSpacer[idx].show();
	}
}

Initialize.prototype.getTestList = function()
{
	this.hideTests();
	var metaRadio = this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.Text;
	var modelBand = this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.Text;
	var menu = this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.Text;
	
	DatabaseController.writeRadioInfo(metaRadio, modelBand, menu);
	DatabaseController.getTestList();
	
	this.invalidateTests();
	this.getOptionStates();
}

Initialize.prototype.hideTests = function()
{
	for (var i = 0; i < this.summaryLabel.length; i++)
	{
		this.summaryLabel[i].hide();
		this.summaryStatus[i].hide();
		this.summaryStatusB[i].hide();
		this.row[i].hide();
		this.checkBox[i].checked = false;
	}
}

Initialize.prototype.configButtonClicked = function(idx)
{
	this.hideConfigs();
	this.ConfigResetButton.show();
	this.CableLossResetButton.hide();
	this.ConfigCurrentConfig.show();
	this.ExtAttenStateButton.hide();
	this.testIdx = idx;
	
	DatabaseController.getConfiguration(idx);
	this.goToConfigurePage();
}

Initialize.prototype.hideConfigs = function()
{
	this.ConfigCopyButton.hide();
	for (var i = 0; i < this.configName.length; i++)
	{
		this.configName[i].hide();
	}
	
	for (var i = 0; i < this.configLowerLimit.length; i++)
	{
		var ll = this.configLowerLimit[i];
		ll.hide();
	}
	
	for (var i = 0; i < this.configUpperLimit.length; i++)
	{
		var ul = this.configUpperLimit[i]; 
		ul.hide();
	}
	
	for (var i = 0; i < this.configTarget.length; i++)
	{
		var target = this.configTarget[i]; 
		target.hide();
	}
	
	for (var i = 0; i < this.configFreqList.length; i++)
	{
		this.configFreqList[i].hide();
	}
	
	for (var i = 0; i < this.configInfo.length; i++)
	{
		this.configInfo[i].hide();
		this.ConfigCopyButton.hide();
	}
	
	for (var i = 0; i < this.configType4Numeric.length; i++)
	{
		var numeric = this.configType4Numeric[i]; 
		numeric.hide();
	}
	
	for (var i = 0; i < this.configType5Numeric.length; i++)
	{
		var numeric = this.configType5Numeric[i]; 
		numeric.hide();
	}
	
	for (var i = 0; i < this.configToggle.length; i++)
	{
		var configToggle = this.configToggle[i]; 
		configToggle.hide();
	}
	
	for (var i = 0; i < this.cableLoss.length; i++)
	{
		var cableLoss = this.cableLoss[i];
		cableLoss.hide();
	}
	
	for (var i = 0; i < this.extAtten.length; i++)
	{
		var extAtten = this.extAtten[i];
		extAtten.hide();
	}
	
	for (var i = 0; i < this.lossTotal.length; i++)
	{
		var lossTotal = this.lossTotal[i];
		lossTotal.hide();
	}
}

Initialize.prototype.updateConfiguration = function(idx, name, type, lowerLimit, upperLimit, target, unit, info)
{ 
	this.configName[idx].text = name;
	this.configName[idx].LabelText = "Name";
	this.configName[idx].show();
	
	if (type == 1) //standard
	{
		this.configLowerLimit[idx].setValue(lowerLimit, this.unitMap[unit]);
		this.configLowerLimit[idx].show();
	
		this.configUpperLimit[idx].setValue(upperLimit, this.unitMap[unit]);
		this.configUpperLimit[idx].show();
	}
	else if (type == 2) //show target
	{
		this.configLowerLimit[idx].setValue(lowerLimit, this.unitMap[unit]);
		this.configLowerLimit[idx].show();
	
		this.configUpperLimit[idx].setValue(upperLimit, this.unitMap[unit]);
		this.configUpperLimit[idx].show();
		
		this.configTarget[idx].setValue(target, this.unitMap[unit]);
		this.configTarget[idx].show();
	}
	else if (type == 3) //hide all, show info line
	{
		this.configInfo[idx].text = info;
		this.configInfo[idx].show();
		this.ConfigCopyButton.show();
	}
	else if (type == 4)
	{
		this.configType4Numeric[idx].UpperLimit = DatabaseController.getDefaultUpperLimit(this.testIdx, idx);
		this.configType4Numeric[idx].LowerLimit = DatabaseController.getDefaultLowerLimit(this.testIdx, idx);
		this.configType4Numeric[idx].setValue(target, this.unitMap[unit]);		
		this.configType4Numeric[idx].show();
	}
	else if (type == 5)
	{
		this.configType5Numeric[idx].UpperLimit = DatabaseController.getDefaultUpperLimit(this.testIdx, idx);
		this.configType5Numeric[idx].LowerLimit = DatabaseController.getDefaultLowerLimit(this.testIdx, idx);
		this.configType5Numeric[idx].setValue(target);		
		this.configType5Numeric[idx].show();
	}
	else if (type == 6)
	{
		this.configToggle[idx].State = target;		
		this.configToggle[idx].show();
	}
}

Initialize.prototype.resultsButtonClicked = function(idx)
{
	var results = DatabaseController.getResults(idx);
	this.setResultsText( results );
	this.goToResultsPage();
}

Initialize.prototype.updateCheckedList = function()
{
	var listString = "";
	for (var i = 0; i < this.checkBox.length; i++)
    {
    	if (this.checkBox[i].checked)
    	{
    		this.summaryLabel[i].styleSheet = "color: white; border: 2px solid #06B7FC; padding: 4px; border-radius: 10px;"; //border style	
    		listString += i + ",";
    	}
    	else
    	{
			this.summaryLabel[i].styleSheet = "color: white; border: 2px solid black; padding: 4px; border-radius: 10px;"; //border style    	
    	}
    }
    DatabaseController.updateSelectedTests(listString);
}

Initialize.prototype.connectButtons = function()
{
    for (var i = 0; i < this.configButton.length; i++)
    {
    	this.AutoTestConfigButtonManager.addButton(this.configButton[i], i);
    }
    
    for (var i = 0; i < this.resultsButton.length; i++)
    {
    	this.AutoTestResultsButtonManager.addButton(this.resultsButton[i], i);
    }
    
    this.AutoTestConfigButtonManager.buttonClicked.connect(this, this.configButtonClicked);
    this.AutoTestResultsButtonManager.buttonClicked.connect(this, this.resultsButtonClicked);
    
    this.ConfigHomeButton.clicked.connect(this, this.goToHomePage);
    this.ConfigResetButton.clicked.connect(this, this.resetLimits);
    this.CableLossResetButton.clicked.connect(this, this.resetCableLoss);
    this.ConfigCopyButton.clicked.connect(this, this.copyInfo);
    this.ExtAttenStateButton.toggled.connect(this, this.setExtAttenState);
    this.ResultsHomeButton.clicked.connect(this, this.goToHomePage);
    this.AllResultsButton.clicked.connect(this, this.viewAllResults);
    this.BrowseResultsButton.clicked.connect(this, this.goToBrowseResultsPage);
    this.BrowseResultsHomeButton.clicked.connect(this, this.goToHomePage);
    this.BrowseResultsSelectButton.clicked.connect(this, this.selectResults);
    this.BrowseResultsDeleteAllButton.clicked.connect(this, this.deleteAllResults);
    this.BrowseResultsUsbCopyButton.clicked.connect(this, this.copyResultsToUsb);
    this.ManageConfigButton.clicked.connect(this, this.goToManageConfigPage);
    this.ManageConfigHomeButton.clicked.connect(this, this.goToHomePage);
    this.ManageConfigStoreButton.clicked.connect(this, this.storeConfig);
    this.ManageConfigRecallButton.clicked.connect(this, this.recallConfig);
    this.ManageConfigDeleteButton.clicked.connect(this, this.deleteConfig);
    this.ManageConfigResetAllButton.clicked.connect(this, this.resetAllLimits);
    this.CableLossButton.clicked.connect(this, this.cableLossClicked);
    this.SelectAllButton.clicked.connect(this, this.selectAllTests);
    this.DeselectAllButton.clicked.connect(this, this.deselectAllTests);
    
    this.RunButton.clicked.connect(this, this.runWait);
    this.SocketController.running.connect(this, this.run);
    this.SocketController.aborted.connect(this, this.abort);
    this.AbortButton.clicked.connect(this, this.abort);
    this.AbortButton.clicked.connect(this.SocketController, this.SocketController.sendAbort);
    this.AbortButton.hide();
    
    this.ui.stackedWidget.MainPage.ControlBar.ReadRadio.clicked.connect(this, this.readRadio);
    
    for (var i = 0; i < this.checkBox.length; i++)
    {
    	this.checkBox[i].clicked.connect(this, this.updateCheckedList);
    }
    
    for (var i = 0; i < this.configLowerLimit.length; i++)
	{
		this.llEmitter[i].broadcastIndex.connect(this, this.limitChanged);
	}
	
	for (var i = 0; i < this.configTarget.length; i++)
	{
		this.targetEmitter[i].broadcastIndex.connect(this, this.limitChanged);
	}
	
	for (var i = 0; i < this.configUpperLimit.length; i++)
	{
		this.ulEmitter[i].broadcastIndex.connect(this, this.limitChanged);
	}
	
	for (var i = 0; i < this.configInfo.length; i++)
	{
		this.infoEmitter[i].broadcastIndex.connect(this, this.infoChanged);
	}
	
	for (var i = 0; i < this.configType4Numeric.length; i++)
	{
		this.type4Emitter[i].broadcastIndex.connect(this, this.type4Changed);
	}
	
	for (var i = 0; i < this.configType5Numeric.length; i++)
	{
		this.type5Emitter[i].broadcastIndex.connect(this, this.type5Changed);
	}
	
	for (var i = 0; i < this.configToggle.length; i++)
	{
		this.toggleEmitter[i].broadcastIndex.connect(this, this.toggleChanged);
	}
	
	for (var i = 0; i < this.cableLoss.length; i++)
	{
		this.cableLossEmitter[i].broadcastIndex.connect(this, this.cableLossChanged);
	}
	
	for (var i = 0; i < this.extAtten.length; i++)
	{
		this.extAttenEmitter[i].broadcastIndex.connect(this, this.extAttenChanged);
	}
    
    this.ui.stackedWidget.MainPage.Tab.currentChanged.connect(this, this.tabChanged);
    this.tabChanged(0);
}

Initialize.prototype.setupObjectReferences = function()
{
	
    this.ConfigHomeButton = this.ui.stackedWidget.ConfigPage.ConfigHomeButton;
    this.ConfigResetButton = this.ui.stackedWidget.ConfigPage.ConfigResetButton;
    this.CableLossResetButton = this.ui.stackedWidget.ConfigPage.CableLossResetButton;
    this.ConfigCopyButton = this.ui.stackedWidget.ConfigPage.ConfigCopyButton;
    this.ConfigCurrentConfig = this.ui.stackedWidget.ConfigPage.ConfigCurrentConfig;
    this.ExtAttenStateButton = this.ui.stackedWidget.ConfigPage.ExtAttenState;
    this.ResultsHomeButton = this.ui.stackedWidget.ResultsPage.ResultsHomeButton;
    
    this.AllResultsButton = this.ui.stackedWidget.MainPage.AllResultsButton;
    this.BrowseResultsButton = this.ui.stackedWidget.MainPage.BrowseResultsButton;
    this.BrowseResultsHomeButton = this.ui.stackedWidget.BrowseResultsPage.BrowseResultsHomeButton;
    this.BrowseResultsSelectButton = this.ui.stackedWidget.BrowseResultsPage.BrowseResultsSelectButton;
    this.BrowseResultsDeleteAllButton = this.ui.stackedWidget.BrowseResultsPage.BrowseResultsDeleteAllButton;
    this.BrowseResultsUsbCopyButton = this.ui.stackedWidget.BrowseResultsPage.BrowseResultsUsbCopyButton;
    this.BrowseResultsTableEnum = this.ui.stackedWidget.BrowseResultsPage.BrowseResultsTableEnum;
    this.ManageConfigButton = this.ui.stackedWidget.MainPage.ManageConfigButton;
    this.ManageConfigHomeButton = this.ui.stackedWidget.ManageConfigPage.ManageConfigHomeButton;
    this.ManageConfigStoreButton = this.ui.stackedWidget.ManageConfigPage.ManageConfigStoreButton;
    this.ManageConfigRecallButton = this.ui.stackedWidget.ManageConfigPage.ManageConfigRecallButton;
    this.ManageConfigDeleteButton = this.ui.stackedWidget.ManageConfigPage.ManageConfigDeleteButton;
    this.ManageConfigResetAllButton = this.ui.stackedWidget.ManageConfigPage.ManageConfigResetAllButton;
    this.ManageConfigCurrentConfig = this.ui.stackedWidget.ManageConfigPage.ManageConfigCurrentConfig;
    this.ManageConfigTableEnum = this.ui.stackedWidget.ManageConfigPage.ManageConfigTableEnum;
    this.RunButton = this.ui.stackedWidget.MainPage.Run;
	this.AbortButton = this.ui.stackedWidget.MainPage.Abort;
	this.CableLossButton = this.ui.stackedWidget.MainPage.CableLossButton;
	this.SelectAllButton = this.ui.stackedWidget.MainPage.SelectAllButton;
	this.DeselectAllButton = this.ui.stackedWidget.MainPage.DeselectAllButton;
	this.MessageBeepButton = this.ui.stackedWidget.MainPage.Tab.widget(2).Toggle_MessageBeep;
	this.EOTBeepButton = this.ui.stackedWidget.MainPage.Tab.widget(2).Toggle_EOTBeep;
	this.ExtLogButton = this.ui.stackedWidget.MainPage.Tab.widget(2).Toggle_ExtLog;
	this.ResetSkipButton = this.ui.stackedWidget.MainPage.Tab.widget(2).Push_ResetSkip;
	    
    DatabaseController = this.system.getModule("DatabaseController");
    this.SocketController = this.system.getModule("PythonSocketController");
    
    this.AutoTestConfigButtonManager = this.system.getModule("AutoTestConfigButtonManager");
    this.AutoTestResultsButtonManager = this.system.getModule("AutoTestResultsButtonManager");
    
	this.RowContainer = this.ui.stackedWidget.MainPage.Tab.widget(1).RowContainer;
    
    this.summaryLabel = new Array();
    this.summaryLabel = [
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel1,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel2,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel3,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel4,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel5,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel6,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel7,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel8,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel9,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel10,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel11,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel12,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel13,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel14,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel15,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel16,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel17,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel18,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel19,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestLabel20	
    	];
    	
    this.summaryStatus = new Array();
    this.summaryStatus = [
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus1,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus2,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus3,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus4,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus5,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus6,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus7,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus8,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus9,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus10,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus11,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus12,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus13,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus14,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus15,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus16,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus17,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus18,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus19,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus20	
    	];
    this.summaryStatusB = new Array();
    this.summaryStatusB = [
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus1B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus2B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus3B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus4B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus5B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus6B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus7B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus8B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus9B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus10B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus11B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus12B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus13B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus14B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus15B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus16B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus17B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus18B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus19B,
    		this.ui.stackedWidget.MainPage.Tab.widget(0).TestStatus20B	
    	];
    	
    this.checkBox = new Array();
    this.checkBox = [
    		this.RowContainer.Row1.CheckBox1,
    		this.RowContainer.Row2.CheckBox2,
    		this.RowContainer.Row3.CheckBox3,
    		this.RowContainer.Row4.CheckBox4,
    		this.RowContainer.Row5.CheckBox5,
    		this.RowContainer.Row6.CheckBox6,
    		this.RowContainer.Row7.CheckBox7,
    		this.RowContainer.Row8.CheckBox8,
    		this.RowContainer.Row9.CheckBox9,
    		this.RowContainer.Row10.CheckBox10,
    		this.RowContainer.Row11.CheckBox11,
    		this.RowContainer.Row12.CheckBox12,
    		this.RowContainer.Row13.CheckBox13,
    		this.RowContainer.Row14.CheckBox14,
    		this.RowContainer.Row15.CheckBox15,
    		this.RowContainer.Row16.CheckBox16,
    		this.RowContainer.Row17.CheckBox17,
    		this.RowContainer.Row18.CheckBox18,
    		this.RowContainer.Row19.CheckBox19,
    		this.RowContainer.Row20.CheckBox20
    	];
    	
    this.testName = new Array();
    this.testName = [
    		this.RowContainer.Row1.TestName1,
    		this.RowContainer.Row2.TestName2,
    		this.RowContainer.Row3.TestName3,
    		this.RowContainer.Row4.TestName4,
    		this.RowContainer.Row5.TestName5,
    		this.RowContainer.Row6.TestName6,
    		this.RowContainer.Row7.TestName7,
    		this.RowContainer.Row8.TestName8,
    		this.RowContainer.Row9.TestName9,
    		this.RowContainer.Row10.TestName10,
    		this.RowContainer.Row11.TestName11,
    		this.RowContainer.Row12.TestName12,
    		this.RowContainer.Row13.TestName13,
    		this.RowContainer.Row14.TestName14,
    		this.RowContainer.Row15.TestName15,
    		this.RowContainer.Row16.TestName16,
    		this.RowContainer.Row17.TestName17,
    		this.RowContainer.Row18.TestName18,
    		this.RowContainer.Row19.TestName19,
    		this.RowContainer.Row20.TestName20
    	];
    	
    this.rowSpacer = new Array();
    this.rowSpacer = [
    		this.RowContainer.Row1.RowSpacer1,
    		this.RowContainer.Row2.RowSpacer2,
    		this.RowContainer.Row3.RowSpacer3,
    		this.RowContainer.Row4.RowSpacer4,
    		this.RowContainer.Row5.RowSpacer5,
    		this.RowContainer.Row6.RowSpacer6,
    		this.RowContainer.Row7.RowSpacer7,
    		this.RowContainer.Row8.RowSpacer8,
    		this.RowContainer.Row9.RowSpacer9,
    		this.RowContainer.Row10.RowSpacer10,
    		this.RowContainer.Row11.RowSpacer11,
    		this.RowContainer.Row12.RowSpacer12,
    		this.RowContainer.Row13.RowSpacer13,
    		this.RowContainer.Row14.RowSpacer14,
    		this.RowContainer.Row15.RowSpacer15,
    		this.RowContainer.Row16.RowSpacer16,
    		this.RowContainer.Row17.RowSpacer17,
    		this.RowContainer.Row18.RowSpacer18,
    		this.RowContainer.Row19.RowSpacer19,
    		this.RowContainer.Row20.RowSpacer20
    	];
    	
    this.configButton = new Array();
    this.configButton = [
    		this.RowContainer.Row1.Configure1,
    		this.RowContainer.Row2.Configure2,
    		this.RowContainer.Row3.Configure3,
    		this.RowContainer.Row4.Configure4,
    		this.RowContainer.Row5.Configure5,
    		this.RowContainer.Row6.Configure6,
    		this.RowContainer.Row7.Configure7,
    		this.RowContainer.Row8.Configure8,
    		this.RowContainer.Row9.Configure9,
    		this.RowContainer.Row10.Configure10,
    		this.RowContainer.Row11.Configure11,
    		this.RowContainer.Row12.Configure12,
    		this.RowContainer.Row13.Configure13,
    		this.RowContainer.Row14.Configure14,
    		this.RowContainer.Row15.Configure15,
    		this.RowContainer.Row16.Configure16,
    		this.RowContainer.Row17.Configure17,
    		this.RowContainer.Row18.Configure18,
    		this.RowContainer.Row19.Configure19,
    		this.RowContainer.Row20.Configure20
    	];
    	
    this.resultsButton = new Array();
    this.resultsButton = [
    		this.RowContainer.Row1.Results1,
    		this.RowContainer.Row2.Results2,
    		this.RowContainer.Row3.Results3,
    		this.RowContainer.Row4.Results4,
    		this.RowContainer.Row5.Results5,
    		this.RowContainer.Row6.Results6,
    		this.RowContainer.Row7.Results7,
    		this.RowContainer.Row8.Results8,
    		this.RowContainer.Row9.Results9,
    		this.RowContainer.Row10.Results10,
    		this.RowContainer.Row11.Results11,
    		this.RowContainer.Row12.Results12,
    		this.RowContainer.Row13.Results13,
    		this.RowContainer.Row14.Results14,
    		this.RowContainer.Row15.Results15,
    		this.RowContainer.Row16.Results16,
    		this.RowContainer.Row17.Results17,
    		this.RowContainer.Row18.Results18,
    		this.RowContainer.Row19.Results19,
    		this.RowContainer.Row20.Results20
    	];
    	
    this.statusFlag = new Array();
    this.statusFlag = [
    		this.RowContainer.Row1.Status1,
    		this.RowContainer.Row2.Status2,
    		this.RowContainer.Row3.Status3,
    		this.RowContainer.Row4.Status4,
    		this.RowContainer.Row5.Status5,
    		this.RowContainer.Row6.Status6,
    		this.RowContainer.Row7.Status7,
    		this.RowContainer.Row8.Status8,
    		this.RowContainer.Row9.Status9,
    		this.RowContainer.Row10.Status10,
    		this.RowContainer.Row11.Status11,
    		this.RowContainer.Row12.Status12,
    		this.RowContainer.Row13.Status13,
    		this.RowContainer.Row14.Status14,
    		this.RowContainer.Row15.Status15,
    		this.RowContainer.Row16.Status16,
    		this.RowContainer.Row17.Status17,
    		this.RowContainer.Row18.Status18,
    		this.RowContainer.Row19.Status19,
    		this.RowContainer.Row20.Status20
    	];
    	
    this.statusFlagB = new Array();
    this.statusFlagB = [
    		this.RowContainer.Row1.Status1B,
    		this.RowContainer.Row2.Status2B,
    		this.RowContainer.Row3.Status3B,
    		this.RowContainer.Row4.Status4B,
    		this.RowContainer.Row5.Status5B,
    		this.RowContainer.Row6.Status6B,
    		this.RowContainer.Row7.Status7B,
    		this.RowContainer.Row8.Status8B,
    		this.RowContainer.Row9.Status9B,
    		this.RowContainer.Row10.Status10B,
    		this.RowContainer.Row11.Status11B,
    		this.RowContainer.Row12.Status12B,
    		this.RowContainer.Row13.Status13B,
    		this.RowContainer.Row14.Status14B,
    		this.RowContainer.Row15.Status15B,
    		this.RowContainer.Row16.Status16B,
    		this.RowContainer.Row17.Status17B,
    		this.RowContainer.Row18.Status18B,
    		this.RowContainer.Row19.Status19B,
    		this.RowContainer.Row20.Status20B
    	];
    	
    this.row = new Array();
    this.row = [
    		this.RowContainer.Row1,
    		this.RowContainer.Row2,
    		this.RowContainer.Row3,
    		this.RowContainer.Row4,
    		this.RowContainer.Row5,
    		this.RowContainer.Row6,
    		this.RowContainer.Row7,
    		this.RowContainer.Row8,
    		this.RowContainer.Row9,
    		this.RowContainer.Row10,
    		this.RowContainer.Row11,
    		this.RowContainer.Row12,
    		this.RowContainer.Row13,
    		this.RowContainer.Row14,
    		this.RowContainer.Row15,
    		this.RowContainer.Row16,
    		this.RowContainer.Row17,
    		this.RowContainer.Row18,
    		this.RowContainer.Row19,
    		this.RowContainer.Row20
    	];
    	
    this.configName = new Array();
    this.configName = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigName1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigName2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigName3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigName4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigName5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigName6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigName7
    	];
    	
    this.configLowerLimit = new Array();
    this.configLowerLimit = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigLowerLimit1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigLowerLimit2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigLowerLimit3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigLowerLimit4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigLowerLimit5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigLowerLimit6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigLowerLimit7
    	];
    
    this.configTarget = new Array();
    this.configTarget = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigTarget1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigTarget2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigTarget3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigTarget4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigTarget5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigTarget6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigTarget7
    	];
    	
    this.configUpperLimit = new Array();
    this.configUpperLimit = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigUpperLimit1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigUpperLimit2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigUpperLimit3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigUpperLimit4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigUpperLimit5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigUpperLimit6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigUpperLimit7
    	];
    	
    this.configFreqList = new Array();
    this.configFreqList = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigFreqList1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigFreqList2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigFreqList3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigFreqList4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigFreqList5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigFreqList6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigFreqList7
    	];
    	
    this.configInfo = new Array();
    this.configInfo = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigInfo1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigInfo2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigInfo3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigInfo4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigInfo5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigInfo6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigInfo7
    	];
    	
    this.configType4Numeric = new Array();
    this.configType4Numeric = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType4Numeric1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType4Numeric2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType4Numeric3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType4Numeric4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType4Numeric5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType4Numeric6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType4Numeric7
    	];
    	
	this.configType5Numeric = new Array();
    this.configType5Numeric = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType5Numeric1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType5Numeric2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType5Numeric3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType5Numeric4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType5Numeric5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType5Numeric6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigType5Numeric7
    	];
    	
    this.configToggle = new Array();
    this.configToggle = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigToggle1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigToggle2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigToggle3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigToggle4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigToggle5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigToggle6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ConfigToggle7
    	];
    	
    this.cableLoss = new Array();
    this.cableLoss = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.CableLoss1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.CableLoss2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.CableLoss3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.CableLoss4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.CableLoss5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.CableLoss6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.CableLoss7
    	];
    	
	this.extAtten = new Array();
	this.extAtten = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ExtAtten1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ExtAtten2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ExtAtten3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ExtAtten4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ExtAtten5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ExtAtten6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.ExtAtten7
		];
		
	this.lossTotal = new Array();
	this.lossTotal = [
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.LossTotal1,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.LossTotal2,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.LossTotal3,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.LossTotal4,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.LossTotal5,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.LossTotal6,
    		this.ui.stackedWidget.ConfigPage.ConfigGroupBox.LossTotal7
		];
    	
    this.llEmitter = new Array();
    this.llEmitter = [
    		this.ui.LLIndexEmitter1,
    		this.ui.LLIndexEmitter2,
    		this.ui.LLIndexEmitter3,
    		this.ui.LLIndexEmitter4,
    		this.ui.LLIndexEmitter5,
    		this.ui.LLIndexEmitter6,
    		this.ui.LLIndexEmitter7
    	];
    	
	this.targetEmitter = new Array();
    this.targetEmitter = [
    		this.ui.TargetIndexEmitter1,
    		this.ui.TargetIndexEmitter2,
    		this.ui.TargetIndexEmitter3,
    		this.ui.TargetIndexEmitter4,
    		this.ui.TargetIndexEmitter5,
    		this.ui.TargetIndexEmitter6,
    		this.ui.TargetIndexEmitter7
    	];
    	
	this.ulEmitter = new Array();
    this.ulEmitter = [
    		this.ui.ULIndexEmitter1,
    		this.ui.ULIndexEmitter2,
    		this.ui.ULIndexEmitter3,
    		this.ui.ULIndexEmitter4,
    		this.ui.ULIndexEmitter5,
    		this.ui.ULIndexEmitter6,
    		this.ui.ULIndexEmitter7
    	];
    	
    this.infoEmitter = new Array();
    this.infoEmitter = [
    		this.ui.InfoIndexEmitter1,
    		this.ui.InfoIndexEmitter2,
    		this.ui.InfoIndexEmitter3,
    		this.ui.InfoIndexEmitter4,
    		this.ui.InfoIndexEmitter5,
    		this.ui.InfoIndexEmitter6,
    		this.ui.InfoIndexEmitter7
    	];
    	
    this.type4Emitter = new Array();
    this.type4Emitter = [
    		this.ui.Type4IndexEmitter1,
    		this.ui.Type4IndexEmitter2,
    		this.ui.Type4IndexEmitter3,
    		this.ui.Type4IndexEmitter4,
    		this.ui.Type4IndexEmitter5,
    		this.ui.Type4IndexEmitter6,
    		this.ui.Type4IndexEmitter7
    	];
    	
    this.type5Emitter = new Array();
    this.type5Emitter = [
    		this.ui.Type5IndexEmitter1,
    		this.ui.Type5IndexEmitter2,
    		this.ui.Type5IndexEmitter3,
    		this.ui.Type5IndexEmitter4,
    		this.ui.Type5IndexEmitter5,
    		this.ui.Type5IndexEmitter6,
    		this.ui.Type5IndexEmitter7
    	];
    	
    this.toggleEmitter = new Array();
    this.toggleEmitter = [
    		this.ui.ToggleIndexEmitter1,
    		this.ui.ToggleIndexEmitter2,
    		this.ui.ToggleIndexEmitter3,
    		this.ui.ToggleIndexEmitter4,
    		this.ui.ToggleIndexEmitter5,
    		this.ui.ToggleIndexEmitter6,
    		this.ui.ToggleIndexEmitter7
    	];
    	
    this.cableLossEmitter = new Array();
    this.cableLossEmitter = [
    		this.ui.CableLossIndexEmitter1,
    		this.ui.CableLossIndexEmitter2,
    		this.ui.CableLossIndexEmitter3,
    		this.ui.CableLossIndexEmitter4,
    		this.ui.CableLossIndexEmitter5,
    		this.ui.CableLossIndexEmitter6,
    		this.ui.CableLossIndexEmitter7
    	];
    	
	this.extAttenEmitter = new Array();
    this.extAttenEmitter = [
    		this.ui.ExtAttenIndexEmitter1,
    		this.ui.ExtAttenIndexEmitter2,
    		this.ui.ExtAttenIndexEmitter3,
    		this.ui.ExtAttenIndexEmitter4,
    		this.ui.ExtAttenIndexEmitter5,
    		this.ui.ExtAttenIndexEmitter6,
    		this.ui.ExtAttenIndexEmitter7
    	];
    	
    this.optionsToggle = new Array();
    this.optionsToggle = [
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsToggle1,
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsToggle2,
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsToggle3,
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsToggle4,
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsToggle5
    	];
    	
    this.optionsText = new Array();
    this.optionsText = [
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsText1,
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsText2,
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsText3,
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsText4,
    		this.ui.stackedWidget.MainPage.Tab.widget(2).OptionsGroupBox.OptionsText5
    	];
}

Initialize.prototype.limitChanged = function(idx)
{
	var lowerLimit = this.configLowerLimit[idx].value();
	var upperLimit = this.configUpperLimit[idx].value();
	var target = this.configTarget[idx].value();
	DatabaseController.updateLimits(this.testIdx, idx, lowerLimit, upperLimit, target);
	this.updateConfigName();
}

Initialize.prototype.infoChanged = function(idx)
{
	var info = this.configInfo[idx].text;
	DatabaseController.updateInfo(this.testIdx, idx, info);
	this.updateConfigName();
}

Initialize.prototype.type4Changed = function(idx)
{
	var value = this.configType4Numeric[idx].value();
	DatabaseController.updateType4(this.testIdx, idx, value);
	this.updateConfigName();
}

Initialize.prototype.type5Changed = function(idx)
{
	var value = this.configType5Numeric[idx].value();
	DatabaseController.updateType5(this.testIdx, idx, value);
	this.updateConfigName();
}

Initialize.prototype.toggleChanged = function(idx)
{
	var value = this.configToggle[idx].State;
	DatabaseController.updateToggle(this.testIdx, idx, value);
	this.updateConfigName();
}

Initialize.prototype.updateConfigName = function()
{
	var configName = this.ManageConfigCurrentConfig.text;
	if (configName == "Default" || configName == "Custom")
	{
		configName = "Custom";
		this.ManageConfigStoreButton.Locked = false;
		this.ConfigCurrentConfig.text = configName;
		this.ManageConfigCurrentConfig.text = configName;
	}
	else
	{
		if (this.ConfigCurrentConfig.text.charAt(0) != '*')
		{
			this.ConfigCurrentConfig.text = "*"+configName;
			this.ManageConfigCurrentConfig.text = "*"+configName;
		}
	}
	DatabaseController.setStoredConfigName(configName);
}

Initialize.prototype.cableLossChanged = function(idx)
{
	var value = this.cableLoss[idx].value();
	DatabaseController.setCableLoss(idx, value);
	
	var extAtten = this.extAtten[idx].value();
	if (value > 0)
		value = value * -1;
	if (extAtten > 0)
		extAtten = extAtten * -1;
	
	this.lossTotal[idx].setValue(value + extAtten);	
}

Initialize.prototype.extAttenChanged = function(idx)
{
	var value = this.extAtten[idx].value();
	DatabaseController.setExtAtten(idx, value);
	
	var cableLoss = this.cableLoss[idx].value();
	if (value > 0)
		value = value * -1;
	if (cableLoss > 0)
		cableLoss = cableLoss * -1;
	
	this.lossTotal[idx].setValue(value + cableLoss);	
}

Initialize.prototype.resetLimits = function()
{
	DatabaseController.resetLimits(this.testIdx);
	DatabaseController.getConfiguration(this.testIdx);
	
	for (var i = 0; i < this.configInfo.length; i++)
	{
		this.configInfo[i].text = "";
	}
}

Initialize.prototype.resetAllLimits = function()
{
	DatabaseController.resetAllLimits();
	this.ConfigCurrentConfig.text = "Default";
	this.ManageConfigCurrentConfig.text = "Default";
	DatabaseController.setStoredConfigName("Default");
	this.ManageConfigStoreButton.Locked = true;
	this.goToHomePage();
}

Initialize.prototype.readRadio = function()
{
	this.ui.stackedWidget.MainPage.ControlBar.MetaRadio.hide();
	this.ui.stackedWidget.MainPage.ControlBar.RadioSelection.hide();
	this.ui.stackedWidget.MainPage.ControlBar.RadioMenu.hide();
	this.ui.stackedWidget.MainPage.ControlBar.ReadRadio.hide();
	this.ui.stackedWidget.MainPage.ControlBar.OverallStatus.show();
	this.ui.stackedWidget.MainPage.ControlBar.OverallStatus.text = "Initializing radio read...";
	this.RunButton.Locked = true;
	this.SocketController.sendReadRadio();
}

Initialize.prototype.selectAllTests = function()
{
	for (var i = 0; i < this.checkBox.length; i++)
	{
		if (!this.checkBox[i].checked)
			this.checkBox[i].checked = true;
	}
	this.updateCheckedList();
}

Initialize.prototype.deselectAllTests = function()
{
	for (var i = 0; i < this.checkBox.length; i++)
	{
		if (this.checkBox[i].checked)
			this.checkBox[i].checked = false;	
	}
	this.updateCheckedList();
}

Initialize.prototype.tabChanged = function(idx)
{
	switch(idx)
	{
		case 0: //Summary
			//this.SelectAllButton.hide();
			//this.DeselectAllButton.hide();
			break;
		case 1: //Test
			//this.SelectAllButton.show();
			//this.DeselectAllButton.show();
			break;
	}
}

Initialize.prototype.copyInfo = function()
{
	this.ConfigCopyButton.Locked = true;
	this.SocketController.copyInfo(this.testIdx);
}

Initialize.prototype.recallConfig = function()
{
	var idx = this.ManageConfigTableEnum.currentIndex();
	DatabaseController.recallConfig(idx);
	var name = DatabaseController.getStoredConfigName();
	this.ConfigCurrentConfig.text = name;
	this.ManageConfigCurrentConfig.text = name;
	this.ManageConfigStoreButton.Locked = false;
	this.goToHomePage();
}

Initialize.prototype.storeConfig = function()
{
	if (this.SocketController.promptConfigStore(this.ManageConfigTableEnum.currentIndex()))
	{
		this.ManageConfigTableEnum.setMetaData(DatabaseController.getConfigMetaData());
		var name = DatabaseController.getStoredConfigName();
		this.ConfigCurrentConfig.text = name;
		this.ManageConfigCurrentConfig.text = name;
	}
}

Initialize.prototype.deleteConfig = function()
{
	var idx = this.ManageConfigTableEnum.currentIndex();
	var changeName = false;
	if (this.ConfigCurrentConfig.text == DatabaseController.getConfigName(idx))
		changeName = true;
	if (this.SocketController.promptConfigDelete(idx))
	{
		if (changeName)
		{
			this.ConfigCurrentConfig.text = "Custom";
			this.ManageConfigCurrentConfig.text = "Custom";
			DatabaseController.setStoredConfigName("Custom");
		}
	}
	this.ManageConfigTableEnum.setMetaData(DatabaseController.getConfigMetaData());
}

Initialize.prototype.deleteAllResults = function()
{
	this.SocketController.promptResultsDelete();
	this.BrowseResultsTableEnum.setMetaData(DatabaseController.getResultsMetaData());
}

Initialize.prototype.copyResultsToUsb = function()
{
	this.SocketController.copyResultsToUsb();
}

Initialize.prototype.cableLossClicked = function()
{
	this.ConfigResetButton.hide();
	this.CableLossResetButton.show();
	this.ExtAttenStateButton.show();
	this.hideConfigs();
	this.ConfigCurrentConfig.hide();
	DatabaseController.getCableLoss();
	DatabaseController.getExtAtten();
	this.goToConfigurePage();
}

Initialize.prototype.updateCableLoss = function(idx, band, value, unit)
{ 
	this.configName[idx].text = band;
	this.configName[idx].LabelText = "Freq-Band";
	this.configName[idx].show();
	
	this.cableLoss[idx].UpperLimit = 0;
	this.cableLoss[idx].LowerLimit = -100;
	this.cableLoss[idx].setValue(value, this.unitMap[unit]);
	this.cableLoss[idx].show();
	
	this.calculateTotalLoss();
}

Initialize.prototype.resetCableLoss = function()
{
	for (var i = 0; i < this.cableLoss.length; i++)
	{
		this.cableLoss[i].setValue(0, this.unitMap["dB"]);
		this.cableLossEmitter[i].sendSignal();
	}
	
	for (var i = 0; i < this.extAtten.length; i++)
	{
		this.extAtten[i].setValue(0, this.unitMap["dB"]);
		this.extAttenEmitter[i].sendSignal();
	}
}

Initialize.prototype.updateExtAtten = function(idx, value, unit)
{ 
	this.extAtten[idx].UpperLimit = 0;
	this.extAtten[idx].LowerLimit = -100;
	this.extAtten[idx].setValue(value, this.unitMap[unit]);
	this.extAtten[idx].show();
	this.lossTotal[idx].show();
	
	this.calculateTotalLoss();
}

Initialize.prototype.setExtAttenState = function(state)
{
	this.extAttenState = state;
	DatabaseController.setExtAttenState(state);
	for (var i = 0; i < this.extAtten.length; i++)
	{
		this.extAtten[i].ReadOnly = !state;
	}
	this.calculateTotalLoss();
}

Initialize.prototype.calculateTotalLoss = function()
{
	for (var i = 0; i < this.lossTotal.length; i++)
	{
		var cableLoss = this.cableLoss[i].value();
		if (cableLoss > 0)
			cableLoss = cableLoss * -1;
			
		if(!this.extAttenState)
		{
			this.lossTotal[i].setValue(cableLoss);
		}
		else
		{
			var extAtten = this.extAtten[i].value();
			if (extAtten > 0)
				extAtten = extAtten * -1;
			this.lossTotal[i].setValue(cableLoss + extAtten);
		}		
	}
}

Initialize.prototype.enableDualBand = function(enable)
{
	this.dualBandEnabled = enable;
	/*
	if (enable)
	{
		this.ui.stackedWidget.MainPage.Tab.showTab(2);
	}
	else
	{
		this.ui.stackedWidget.MainPage.Tab.hideTab(2);
	}
	*/				
}

Initialize.prototype.messageBeepToggled = function(enable)
{
	DatabaseController.setMessageBeepEnabled(enable);
}

Initialize.prototype.eotBeepToggled = function(state)
{
	DatabaseController.setEOTBeepEnabled(state);
}

Initialize.prototype.extLogToggled = function(state)
{
	DatabaseController.setExtLogEnabled(state);
}

Initialize.prototype.resetSkipClicked = function()
{
	this.SocketController.resetSkip();
}

Initialize.prototype.getOptionStates = function()
{
	this.MessageBeepButton.State = DatabaseController.getMessageBeepEnabled();
	this.EOTBeepButton.State = DatabaseController.getEOTBeepEnabled();
	this.ExtLogButton.State = DatabaseController.getExtLogEnabled();
}

Initialize.prototype.option0Toggled = function()
{
	DatabaseController.writeOptionState(0, this.optionsToggle[0].State);
}

Initialize.prototype.option1Toggled = function()
{
	DatabaseController.writeOptionState(1, this.optionsToggle[1].State);
}

Initialize.prototype.option2Toggled = function()
{
	DatabaseController.writeOptionState(2, this.optionsToggle[2].State);
}

Initialize.prototype.option3Toggled = function()
{
	DatabaseController.writeOptionState(3, this.optionsToggle[3].State);
}

Initialize.prototype.option4Toggled = function()
{
	DatabaseController.writeOptionState(4, this.optionsToggle[4].State);
}

Initialize.prototype.optionIp0Changed = function()
{
	DatabaseController.writeOptionText(0, this.optionsText[0].text);
}

Initialize.prototype.optionIp1Changed = function()
{
	DatabaseController.writeOptionText(1, this.optionsText[1].text);
}

Initialize.prototype.optionIp2Changed = function()
{
	DatabaseController.writeOptionText(2, this.optionsText[2].text);
}

Initialize.prototype.optionIp3Changed = function()
{
	DatabaseController.writeOptionText(3, this.optionsText[3].text);
}

Initialize.prototype.optionIp4Changed = function()
{
	DatabaseController.writeOptionText(4, this.optionsText[4].text);
}

Initialize.prototype.hideOptions = function()
{
	for (var i = 0; i < this.optionsToggle.length; i++)
	{
		this.optionsToggle[i].hide();
	}
	
	for (var i = 0; i < this.optionsText.length; i++)
	{
		this.optionsText[i].hide();
	}
}

Initialize.prototype.updateOptionToggle = function(idx, label, value)
{
	this.optionsToggle[idx].LabelText = label;
	this.optionsToggle[idx].State = value;
	this.optionsToggle[idx].show();
}

Initialize.prototype.updateOptionText = function(idx, value)
{
	this.optionsText[idx].text = value;
	this.optionsText[idx].show();
}