function Initialize(tile, engine, system)
{
    tile.enableState("Thumb");
    tile.configureState("Min", "240|400");
    tile.setDefaultState("Thumb");
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    this.ui.stackedWidget.hide();
    this.ui.stackedWidget.page_2.Tab.widget(0).Combo_Source.currentIndexChanged.connect(this, this.sourceChanged);
    var idx = this.ui.stackedWidget.page_2.Tab.widget(0).Combo_Source.currentIndex();
    this.sourceChanged(idx);
    tile.showSendToBackButton(false);
    
    this.ui.widget.Combo_Min.currentIndexChanged.connect(this, this.unitChanged);
    this.unitChanged();
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
        this.ui.stackedWidget.show();
        this.ui.widget.Combo_Min.hide();
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
        this.ui.stackedWidget.hide();
        this.ui.widget.Combo_Min.show();
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(0);	
        this.ui.stackedWidget.hide();
        this.ui.widget.Combo_Min.show();
    }   	
}

Initialize.prototype.sourceChanged = function(idx)
{	
	switch(Number(idx)) {
        case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Combo_Div.hide();
    		this.ui.stackedWidget.page_2.Tab.widget(0).Combo_DvmLoad.hide();
    		
    		this.ui.stackedWidget.page_2.Tab.widget(0).Combo_InputRange.show();
    		this.ui.stackedWidget.page_2.Tab.widget(0).Combo_InputLoad.show();
            break;
        case 1:
        	this.ui.stackedWidget.page_2.Tab.widget(0).Combo_Div.show();
        	this.ui.stackedWidget.page_2.Tab.widget(0).Combo_DvmLoad.show();
        	
        	this.ui.stackedWidget.page_2.Tab.widget(0).Combo_InputRange.hide();
        	this.ui.stackedWidget.page_2.Tab.widget(0).Combo_InputLoad.hide();
            break;
        default:
        	break
    }
}

Initialize.prototype.unitChanged = function()
{
	var idx = this.ui.widget.Combo_Min.currentIndex();
	switch (idx)
	{
		case 0: //V
			this.ui.widget.QCPNumericMeterReading.Precision = 3;
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj.Units = "";
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_2.Units = "";
			break;
		case 1: //mV
			this.ui.widget.QCPNumericMeterReading.Precision = 2;
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj.Units = "";
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_2.Units = "";
			break;
		case 2: //dBuV
			this.ui.widget.QCPNumericMeterReading.Precision = 1;
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj.Units = "";
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_2.Units = "";
			break;
		case 3: //dBm
			this.ui.widget.QCPNumericMeterReading.Precision = 2;
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj.Units = "";
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_2.Units = "";
			break;
		case 4: //W
			this.ui.widget.QCPNumericMeterReading.Precision = 2;
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj.Units = "0,0,12:1;;;;|0,-3,12:1;;;;|0,-6,12:1;;;;|0,-9,12:1;;;;";
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_2.Units = "0,0,12:1;;;;|0,-3,12:1;;;;|0,-6,12:1;;;;|0,-9,12:1;;;;";
			break;
		case 5: //dBr
			this.ui.widget.QCPNumericMeterReading.Precision = 2;
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj.Units = "";
			this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_2.Units = "";
			break;
	}
}
