function Initialize(tile, engine, system)
{
	tile.disableState("Max");
    this.ui = tile.getContainerFrame();
    this.ui.MeasureType.currentIndexChanged.connect(this, this.typeChanged);
    var idx = this.ui.MeasureType.currentIndex();
    this.typeChanged(idx);
    this.ui.RnSSensor.toggled.connect(this, this.toggleAll);
    var state = this.ui.RnSSensor.activeState();
    this.toggleAll(state);
    
    this.ui.State.hide();
    this.ui.StateButton.hide();
    this.ui.RnSSensor.hide();
    this.ui.Test.hide();
    this.ui.BurstWidth.hide();
    this.ui.BurstPeriod.hide();
    
    this.ui.ForwardUnits.currentIndexChanged.connect(this, this.forwardUnitsChanged);
    this.ui.ReflectedUnits.currentIndexChanged.connect(this, this.reflectedUnitsChanged);
    
    this.forwardUnitsChanged();
    this.reflectedUnitsChanged();
    
    this.ui.ForwardAbsorbed.currentIndexChanged.connect(this, this.forwardAbsorbedChanged);
    //this.forwardAbsorbedChanged();
    
    tile.WindowOpened.connect(this, this.showEvent);
	tile.WindowClosed.connect(this, this.hideEvent);
}

Initialize.prototype.toggleAll = function()
{
	var birdState = this.ui.RnSSensor.State;
	
	if (birdState)
	{
		this.ui.MeasureType.show();
		this.ui.Filter.show();
		this.ui.Offset.show();
		this.ui.Zero.show();
		this.ui.Forward.show();
		this.ui.ForwardUnits.show();
		this.ui.Freq.show();
		
		this.ui.Port.show();
		this.ui.RelativeUnits.show();
		this.ui.Relative.show();
		this.ui.ForwardAbsorbed.show();
		
		var idx = this.ui.MeasureType.currentIndex();
		this.typeChanged(idx);
		
		this.ui.EmptyLabel.hide();
	}
	else
	{
		this.ui.EmptyLabel.text = "Connect External NRT-Z Power Sensor";
		
		this.ui.EmptyLabel.show();
		this.ui.MeasureType.hide();
		this.ui.Filter.hide();
		this.ui.Offset.hide();
		this.ui.Zero.hide();
		this.ui.Forward.hide();
		this.ui.ForwardUnits.hide();
		this.ui.Reflected.hide();
		this.ui.ReflectedUnits.hide();
		this.ui.Freq.hide();
		this.ui.CCDF.hide();
		
		this.ui.Port.hide();
		this.ui.RelativeUnits.hide();
		this.ui.Relative.hide();
		this.ui.ForwardAbsorbed.hide();
	}
}

Initialize.prototype.typeChanged = function(idx)
{
	var state = this.ui.RnSSensor.activeState();
	if (state)
	{
	    this.ui.Reflected.hide();
	    this.ui.ReflectedUnits.hide();
	    this.ui.CCDF.hide();
	    this.ui.Offset.show();
	
		switch (Number(idx))
	    {
	        case 0:
	            this.ui.Reflected.show();
	            this.ui.ReflectedUnits.show();
	            this.ui.ForwardAbsorbed.show(); 
	            this.ui.Port.show(); 
	            this.ui.Relative.show();
	            this.ui.RelativeUnits.show();
	            this.ui.BurstWidth.hide();
	            this.ui.BurstPeriod.hide();
	            this.forwardAbsorbedChanged(); 
	            break;
	        case 1:
	        	this.ui.Reflected.show();
	            this.ui.ReflectedUnits.show();
	            this.ui.ForwardAbsorbed.show(); 
	            this.ui.Port.show(); 
	            this.ui.Relative.show();
	            this.ui.RelativeUnits.show();
	            this.ui.BurstWidth.show();
	            this.ui.BurstPeriod.show();
	            this.forwardAbsorbedChanged();
	        	break;
	        case 2:
	        	this.ui.Reflected.show();
	            this.ui.ReflectedUnits.show();
	            this.ui.ForwardAbsorbed.show(); 
	            this.ui.Port.show(); 
	            this.ui.Relative.show();
	            this.ui.RelativeUnits.show();
	            this.ui.BurstWidth.hide();
	            this.ui.BurstPeriod.hide();
	            this.forwardAbsorbedChanged();
	            break;
	        case 3:
	        	this.ui.Reflected.hide();
	            this.ui.ReflectedUnits.hide();	
	            this.ui.ForwardAbsorbed.hide(); 
	            this.ui.Port.show();       	
	            this.ui.Relative.show();
	            this.ui.RelativeUnits.show(); 
	            this.ui.BurstWidth.hide();
	            this.ui.BurstPeriod.hide();
	        	break;
	        case 4:
	        
	        	this.ui.Reflected.hide();
	            this.ui.ReflectedUnits.hide();
	            this.ui.ForwardAbsorbed.hide(); 
	            this.ui.Port.hide(); 
	            this.ui.Relative.hide();
	            this.ui.RelativeUnits.hide();
	            this.ui.BurstWidth.hide();
	            this.ui.BurstPeriod.hide(); 
	            this.ui.CCDF.show();	            
	            break;
	        case 5:
	        	this.ui.Reflected.hide();
	            this.ui.ReflectedUnits.hide();	
	            this.ui.ForwardAbsorbed.hide(); 
	            this.ui.Port.hide(); 
	            this.ui.Relative.hide();
	            this.ui.RelativeUnits.hide();
	            this.ui.BurstWidth.hide();
	            this.ui.BurstPeriod.hide();            
	            break;
	    }
    }
}

Initialize.prototype.forwardUnitsChanged = function()
{
	var idx = this.ui.ForwardUnits.currentIndex();
	
	if (idx == 6)
	{
		this.ui.Forward.Precision = 1;
	}
	else
	{
		this.ui.Forward.Precision = 2;
	}
}

Initialize.prototype.reflectedUnitsChanged = function()
{
	var idx = this.ui.ReflectedUnits.currentIndex();
	
	if (idx == 6)
	{
		this.ui.Reflected.Precision = 1;
	}
	else
	{
		this.ui.Reflected.Precision = 2;
	}
}

Initialize.prototype.forwardAbsorbedChanged = function()
{
	var idx = this.ui.ForwardAbsorbed.currentIndex();
	
	var state = this.ui.RnSSensor.activeState();
	if (state)
	{	
		if(idx == 0)
		{
	        this.ui.Relative.show();
			this.ui.RelativeUnits.show();  
		}
		else
		{
			this.ui.Relative.hide();
			this.ui.RelativeUnits.hide();  
		}
	}
}

Initialize.prototype.showEvent = function() 
{
	var filter = this.ui.StateButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(true);
	}
}

Initialize.prototype.hideEvent = function()
{
	var filter = this.ui.StateButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(false);
	}
}
