function Initialize(tile, engine, system)
{
    this.ui = tile.getContainerFrame();
    //tile.changeSize.connect(this, this.resize);
    this.system = system;
      
    this.fileBrowser = this.system.getSystemScreen("FileBrowser3550");
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_StoreTrace.clicked.connect(this, this.showStoreBrowser);
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_RecallTrace.clicked.connect(this, this.showRecallBrowser);
    
    this.ui.stackedWidget.page_2.Tab.widget(3).QCPTextEntry.hide();
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_Save.hide();
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_Load.hide();
    
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_VertScale.currentIndexChanged.connect(this, this.vertScaleChanged);
	this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_TOS.currentIndexChanged.connect(this, this.tosIdxChanged);
	
	var idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_VertScale.currentIndex();
	this.vertScaleChanged(idx);
	
	idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_TOS.currentIndex();
	this.tosIdxChanged(idx);
	
	this.ui.Combo_SizeState.hide();
	
	tile.WindowOpened.connect(this, this.showEvent);
	tile.WindowClosed.connect(this, this.hideEvent);
	
	try 
    { 
        this.ui.stackedWidget.page_2.Tab.widget(2).PlotMarker.attachPlot(this.ui.PlotManager);
    } 
    catch(e) 
    { 
        print("Failed to attach: "+e); 
    }
    
    this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_4.currentIndexChanged.connect(this, this.pbwChanged);
    this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_Offset['valueChanged(double, QString)'].connect(this, this.offsetChanged);
    
    this.ui.PlotManager.updateXAxis.connect(this, this.updatePbwMarkers);
    this.ui.PlotManager.updateYAxis.connect(this, this.updatePbwMarkers);
    
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj['unitChanged(int)'].connect(this, this.freqUnitChanged);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.unitIndex();
    this.freqUnitChanged(idx);
    
    this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_Offset['unitChanged(int)'].connect(this, this.offsetUnitChanged);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_Offset.unitIndex();
    this.offsetUnitChanged(idx);
    var offset = this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_Offset.value();
    this.showEvent();
    this.offsetChanged(offset);
    this.pbwChanged(0);
    
    
    this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_PowerLeft.hide();
    this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_PowerRight.hide();
    this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_PowerTop.hide();
    this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_PowerLeft['valueChanged(double, QString)'].connect(this, this.updatePowerBox);
    this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_PowerRight['valueChanged(double, QString)'].connect(this, this.updatePowerBox);
    this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_PowerTop['valueChanged(double, QString)'].connect(this, this.updatePowerBox);

    this.updatePowerBox(0);
    
    this.ui.stackedWidget.page_2.Tab.widget(4).Toggle_PowerEnabled.toggled.connect(this, this.setPowerBoxEnabled);
    
    var enabled = this.ui.stackedWidget.page_2.Tab.widget(4).Toggle_PowerEnabled.State;
    this.setPowerBoxEnabled(enabled);

    this.ui.Combo_OBW_Active.hide();
    this.ui.Combo_OBW_Active.currentIndexChanged.connect(this, this.obwStateChanged);
    idx = this.ui.Combo_OBW_Active.currentIndex();
    this.obwStateChanged(idx);
    this.ui.WideMode.hide();
    this.ui.stackedWidget.setCurrentIndex(1);
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
        var filter = this.ui.Combo_SizeState.getEventFilter();
        if (filter != null) {
			filter.submitWidgetValue(0);
		}
    } else if (size == "Min") {
        this.ui.stackedWidget.setCurrentIndex(0);
        var filter = this.ui.Combo_SizeState.getEventFilter();
        if (filter != null) {
			filter.submitWidgetValue(1);
		}
    }
}

Initialize.prototype.tosIdxChanged = function(idx)
{
	var ul = 0.0;
	var ll = 0.0;
	var vscaleEnum = 0.0;
	var vscale = 0.0;

	vscaleEnum = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_VertScale.currentIndex();
	
	ul = Number(idx);
	
	switch (Number(vscaleEnum)) {
		case 0:
			vscale = 2.0;
			break;
		case 1:
			vscale = 5.0;
			break;
		case 2:
			vscale = 10.0;
			break;
		case 3:
			vscale = 15.0;
			break;
		case 4:
			vscale = 20.0;
			break;
	}
	
	ll = -(vscale * 8.0) + ul;
	
	print("tosIdxChanged - vscale:" + vscale);
	print("tosIdxChanged - ul:" + ul);
	print("tosIdxChanged - ll:" + ll);
	
	this.ui.PlotManager.YLeftUpperLimit = ul;
	this.ui.PlotManager.YLeftLowerLimit = ll;
	
	this.ui.PlotManager.YRightUpperlimit = ul;
	this.ui.PlotManager.YRightLowerLimit = ll;
}

Initialize.prototype.vertScaleChanged = function(idx)
{
	var ul = 0.0;
	var ll = 0.0;
	var vscale = 0.0;
	
	switch (Number(idx)) {
		case 0:
			vscale = 2.0;
			break;
		case 1:
			vscale = 5.0;
			break;
		case 2:
			vscale = 10.0;
			break;
		case 3:
			vscale = 15.0;
			break;
		case 4:
			vscale = 20.0;
			break;
	}

	ul = this.ui.PlotManager.YLeftUpperLimit;
	var ll = -(vscale * 8.0) + ul;
	
	this.ui.PlotManager.YLeftLowerLimit = ll;
	this.ui.PlotManager.YRightLowerLimit = ll;
}

Initialize.prototype.pbwChanged = function(idx)
{
	var pbw = this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_4.text();
	this.ui.PlotManager.setMarkerSpan(pbw, "0MHz");
}

Initialize.prototype.offsetChanged = function(val, unitstring)
{
	//unitstring is unused
	var unit = this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_Offset.currentUnitName();
	this.ui.PlotManager.setMarkerOffset(val, unit);
}

Initialize.prototype.updatePbwMarkers = function(val1, val2)
{
	//both params are unused.  we just need to update
	//the pbw markers when center freq changes
    this.pbwChanged(0);
}

Initialize.prototype.showEvent = function() 
{
	var engName = "VSWR";
	var instNum = "1";

    var vswrEnable = this.system.getModule("AdapterList").scriptResolve(engName+":"+instNum, "State1");
    vswrEnable.set(false);
    
    engName = "Tracking Generator";
    
    var trackGenEnable = this.system.getModule("AdapterList").scriptResolve(engName+":"+instNum, "State1");
    trackGenEnable.set(false);

	var screen = this.system.getSystemScreen("3550_Analyzer");
	if (screen != null)
	{
		screen.hide();
	}

	screen = this.system.getSystemScreen("3550_VSWR");
	if (screen != null)
	{
		screen.hide();
	}
	
	screen = this.system.getSystemScreen("3550_Tracking_Gen");
	if (screen != null)
	{
		screen.hide();
	}
	
	this.updatePbwMarkers(0,0);
	
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).QCPToggleButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(true);
	}
	
	filter = this.ui.WideMode.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(true);
	}
}

Initialize.prototype.hideEvent = function()
{
	//turn off
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).QCPToggleButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(false);
	}
}

Initialize.prototype.freqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.Precision = 3;
			break;
	}
}

Initialize.prototype.offsetUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_Offset.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_Offset.Precision = 3;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_Offset.Precision = 0;
			break;
	}
}

Initialize.prototype.showStoreBrowser = function()
{
	this.fileBrowser.WindowClosed.connect(this, this.hideStoreBrowserEvent);
	this.fileBrowser.fileSelected.connect(this, this.storeTrace);
	this.fileBrowser.setRootPath("/USER/traces_analyzer");
	this.fileBrowser.setButtonText("Store");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.showRecallBrowser = function()
{
	this.fileBrowser.WindowClosed.connect(this, this.hideRecallBrowserEvent);
	this.fileBrowser.fileSelected.connect(this, this.recallTrace);
	this.fileBrowser.setRootPath("/USER/traces_analyzer");
	this.fileBrowser.setButtonText("Recall");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.hideStoreBrowserEvent = function()
{
	this.fileBrowser.fileSelected.disconnect(this, this.storeTrace);
	this.fileBrowser.WindowClosed.disconnect(this, this.hideStoreBrowserEvent);
}

Initialize.prototype.hideRecallBrowserEvent = function()
{
	this.fileBrowser.fileSelected.disconnect(this, this.recallTrace);
	this.fileBrowser.WindowClosed.disconnect(this, this.hideRecallBrowserEvent);
}

Initialize.prototype.storeTrace = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(3).QCPTextEntry.getEventFilter();
	filter.submitWidgetValue(fileName);
	
	filter = this.ui.stackedWidget.page_2.Tab.widget(3).Button_Save.getEventFilter();
	filter.submitWidgetVoid();
}

Initialize.prototype.recallTrace = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(3).QCPTextEntry.getEventFilter();
	filter.submitWidgetValue(fileName);
	
	filter = this.ui.stackedWidget.page_2.Tab.widget(3).Button_Load.getEventFilter();
	filter.submitWidgetVoid();
}

Initialize.prototype.obwStateChanged = function(idx)
{
	if (idx == 0)
	{
		//hide all OBW fields
		this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_Percent.hide();
		this.ui.stackedWidget.page_2.Tab.widget(4).QCPNumericMeterReading.hide();
		this.ui.stackedWidget.page_2.Tab.widget(4).QCPNumericMeterReading_2.hide();
		this.ui.stackedWidget.page_2.Tab.widget(4).Toggle_PowerEnabled.hide();
		this.ui.stackedWidget.page_2.Tab.widget(4).QCPComboBox_2.hide();
	}
	else if (idx == 1)
	{
		//show all OBW fields
		this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_Percent.show();
		this.ui.stackedWidget.page_2.Tab.widget(4).QCPNumericMeterReading.show();
		this.ui.stackedWidget.page_2.Tab.widget(4).QCPNumericMeterReading_2.show();
		this.ui.stackedWidget.page_2.Tab.widget(4).Toggle_PowerEnabled.show();
		this.ui.stackedWidget.page_2.Tab.widget(4).QCPComboBox_2.show();
	}
}


Initialize.prototype.updatePowerBox = function(value, unit)
{
	//value and unit are unused. grab the values from the widgets and send them to the plot manager
	var left = this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_PowerLeft.value();
	var right = this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_PowerRight.value();
	var top = this.ui.stackedWidget.page_2.Tab.widget(4).Numeric_PowerTop.value();
	
	this.ui.PlotManager.setPowerBoxBounds(left, right, top);
}

Initialize.prototype.setPowerBoxEnabled = function(enabled)
{
	this.ui.PlotManager.setPowerBoxEnabled(enabled);
}