function Initialize(tile, engine, system)
{
    this.ui = tile.getContainerFrame();
    this.system = system;
    this.fileBrowser = this.system.getSystemScreen("FileBrowser3550");
    this.setupObjectReferences();
    this.ui.BrowseButton.clicked.connect(this, this.showFileBrowser);
    
    this.ui.Range['valueChanged(int)'].connect(this, this.updateRange);
    this.updateRange();
    
    this.ui.FilePath.hide();
    this.ui.QCPPushButton_3.hide();
    
	this.ui.ListType.currentIndexChanged.connect(this, this.listTypeChanged);
	this.listTypeChanged();
	
	this.ui.GenUnits.currentIndexChanged.connect(this, this.updateLevelPrecision);
	this.updateLevelPrecision();
	
	this.ui.FilePathDirectory.textChanged.connect(this, this.updateLastPath);
	
	this.ui.CloseButton.hide();
	
	tile.WindowClosed.connect(this, this.tileClosed);
}

Initialize.prototype.showFileBrowser = function()
{
	this.fileBrowser.fileSelected.connect(this, this.fileSelected);
	this.fileBrowser.setRootPath("/USER/freqlist");
	this.fileBrowser.setButtonText("Select");
	this.updateLastPath();
	this.fileBrowser.show();
}

Initialize.prototype.fileSelected = function(fileName)
{
	var filter = this.ui.FilePath.getEventFilter();
	filter.submitWidgetValue(fileName);
	this.fileBrowser.fileSelected.disconnect(this, this.fileSelected);
}

Initialize.prototype.updateLastPath = function()
{
	var path = this.ui.FilePathDirectory.text; 
	if (path != "")
    {
    	this.fileBrowser.setCurrentPath(path);
    }
}

Initialize.prototype.fileNameChanged = function(fileName)
{
	var filter = this.ui.FilePath.getEventFilter();
	filter.submitWidgetValue(this.ui.FilePathDirectory.text + fileName);
}

Initialize.prototype.updateRange = function()
{
	var range = this.ui.Range.value();
	for (var i = 0; i < this.rowLabel.length; i++)
	{
		var val = range + i;
		this.rowLabel[i].text = val.toString(); 
		this.rowLabelB[i].text = val.toString();
	}
	if (range == 499)
	{
		this.ui.Item2.hide();
		this.ui.Item3.hide();
		this.ui.Item4.hide();
	}
	else
	{
		this.ui.Item2.show();
		this.ui.Item3.show();
		this.ui.Item4.show();
	}
}

Initialize.prototype.listTypeChanged = function()
{
	var idx = this.ui.ListType.currentIndex();
	
	switch (idx)
	{
		case 0:		//Analog
			this.showModFreqOnes(false);
			this.showModFreqTwos(false);
			this.showModLevels(false);
			this.showEnumOnes(false);
			this.showEnumTwos(false);
			this.showLongOnes(false);
			this.showLongTwos(false);
			this.showLongThrees(false);
			this.showStringOnes(false);
			this.showStringTwos(false);
			this.showEnumFours(false);
			break;
			
		case 1:		//PL | DCS
			this.showModFreqOnes(true);
			this.showModLevels(true);
			this.showEnumOnes(true);
			this.setEnumOnesText("Mod 1");
			this.showEnumTwos(true);
			this.showLongOnes(false);
			this.showLongTwos(false);
			this.showStringOnes(false);
			this.showStringTwos(false);
			this.showEnumFours(true);
			this.checkType();
			break;
		case 2:		//P25
			this.showModFreqOnes(false);
			this.showModFreqTwos(false);
			this.showModLevels(false);
			this.showEnumOnes(false);
			this.showEnumTwos(false);
			this.showLongOnes(true);
			this.setLongOnesText("NAC");
			this.setLongOnesBase(16);
			this.showLongTwos(false);
			this.showLongThrees(false);
			this.showStringOnes(false);
			this.showStringTwos(false);
			this.showEnumFours(false);
			break;
			
		case 3:		//DMR
			this.showModFreqOnes(false);
			this.showModFreqTwos(false);
			this.showModLevels(false);
			this.showEnumOnes(false);
			this.showEnumTwos(false);
			this.showLongOnes(true);
			this.setLongOnesText("Color");
			this.setLongOnesBase(10);
			this.showLongTwos(true);
			this.setLongTwosText("Call ID");
			this.showLongThrees(false);
			this.showStringOnes(false);
			this.showStringTwos(false);
			this.showEnumFours(false);
			break;
			
		case 4:		//NXDN
			this.showModFreqOnes(false);
			this.showModFreqTwos(false);
			this.showModLevels(false);
			this.showEnumOnes(true);
			this.setEnumOnesText("Rate");
			this.showEnumTwos(false);
			this.showLongOnes(true);
			this.setLongOnesText("RAN");
			this.setLongOnesBase(10);
			this.showLongTwos(false);
			this.showLongThrees(false);
			this.showStringOnes(false);
			this.showStringTwos(false);
			this.showEnumFours(false);
			break;
		
		case 5:		//dPMR
			this.showModFreqOnes(false);
			this.showModFreqTwos(false);
			this.showModLevels(false);
			this.showEnumOnes(false);
			this.showEnumTwos(false);
			this.showLongOnes(true);
			this.setLongOnesText("CC");
			this.setLongOnesBase(10);
			this.showLongTwos(true);
			this.setLongTwosText("Comms Format");
			this.showLongThrees(false);
			this.showStringOnes(true);
			this.setStringOnesText("Call ID");
			this.showStringTwos(true);
			this.setStringTwosText("Unit ID");
			this.showEnumFours(false);
			break;
			
		case 6:		//Tetra BS
			this.showModFreqOnes(false);
			this.showModFreqTwos(false);
			this.showModLevels(false);
			this.showEnumOnes(false);
			this.showEnumTwos(false);
			this.showLongOnes(false);
			this.showLongTwos(false);
			this.showLongThrees(false);
			this.showStringOnes(false);
			this.showStringTwos(false);
			this.showEnumFours(false);
			break;
	}
}

Initialize.prototype.checkType = function()
{
	this.checkType1();
	this.checkType2();
	this.checkType3();
	this.checkType4();
}

Initialize.prototype.checkType1 = function()
{
	if (this.ui.ListType.currentIndex() == 1)
	{
		var idx = this.enumFour[0].currentIndex();
		if (idx == 0) //PL?
		{
			this.modFreqTwo[0].show();
			this.modLevelTwo[0].LabelText = "Mod 2 Level";
			this.enumTwo[0].LabelText = "Mod 2";
			this.longThree[0].hide();
		}
		else	//DCS
		{
			this.modFreqTwo[0].hide();
			this.modLevelTwo[0].LabelText = "DCS Level";
			this.enumTwo[0].LabelText = "DCS";
			this.longThree[0].show();
		}
	}
}

Initialize.prototype.checkType2 = function()
{
	if (this.ui.ListType.currentIndex() == 1)
	{
		var idx = this.enumFour[1].currentIndex();
		if (idx == 0) //PL?
		{
			this.modFreqTwo[1].show();
			this.modLevelTwo[1].LabelText = "Mod 2 Level";
			this.enumTwo[1].LabelText = "Mod 2";
			this.longThree[1].hide();
		}
		else	//DCS
		{
			this.modFreqTwo[1].hide();
			this.modLevelTwo[1].LabelText = "DCS Level";
			this.enumTwo[1].LabelText = "DCS";
			this.longThree[1].show();
		}
	}
}

Initialize.prototype.checkType3 = function()
{
	if (this.ui.ListType.currentIndex() == 1)
	{
		var idx = this.enumFour[2].currentIndex();
		if (idx == 0) //PL?
		{
			this.modFreqTwo[2].show();
			this.modLevelTwo[2].LabelText = "Mod 2 Level";
			this.enumTwo[2].LabelText = "Mod 2";
			this.longThree[2].hide();
		}
		else	//DCS
		{
			this.modFreqTwo[2].hide();
			this.modLevelTwo[2].LabelText = "DCS Level";
			this.enumTwo[2].LabelText = "DCS";
			this.longThree[2].show();
		}
	}
}

Initialize.prototype.checkType4 = function()
{
	if (this.ui.ListType.currentIndex() == 1)
	{
		var idx = this.enumFour[3].currentIndex();
		if (idx == 0) //PL?
		{
			this.modFreqTwo[3].show();
			this.modLevelTwo[3].LabelText = "Mod 2 Level";
			this.enumTwo[3].LabelText = "Mod 2";
			this.longThree[3].hide();
		}
		else	//DCS
		{
			this.modFreqTwo[3].hide();
			this.modLevelTwo[3].LabelText = "DCS Level";
			this.enumTwo[3].LabelText = "DCS";
			this.longThree[3].show();
		}
	}
}

Initialize.prototype.setupObjectReferences = function()
{
    this.rowLabel = new Array();
    this.rowLabel = [
    		this.ui.Item1.RowLabel1,
    		this.ui.Item2.RowLabel2,
    		this.ui.Item3.RowLabel3,
    		this.ui.Item4.RowLabel4
    	];
    	
    this.rowLabelB = new Array();
    this.rowLabelB = [
    		this.ui.Item1.RowLabel1b,
    		this.ui.Item2.RowLabel2b,
    		this.ui.Item3.RowLabel3b,
    		this.ui.Item4.RowLabel4b
    	];
    	
    this.longOne = new Array();
    this.longOne = [
    		this.ui.Item1.Long11,
    		this.ui.Item2.Long12,
    		this.ui.Item3.Long13,
    		this.ui.Item4.Long14
    	];
    
    this.longTwo = new Array();
    this.longTwo = [
    		this.ui.Item1.Long21,
    		this.ui.Item2.Long22,
    		this.ui.Item3.Long23,
    		this.ui.Item4.Long24
    	];
    	
    this.longThree = new Array();
    this.longThree = [
    		this.ui.Item1.Long31,
    		this.ui.Item2.Long32,
    		this.ui.Item3.Long33,
    		this.ui.Item4.Long34
    	];
    	
    this.stringOne = new Array();
    this.stringOne = [
    		this.ui.Item1.String11,
    		this.ui.Item2.String12,
    		this.ui.Item3.String13,
    		this.ui.Item4.String14
    	];
    	
    this.stringTwo = new Array();
    this.stringTwo = [
    		this.ui.Item1.String21,
    		this.ui.Item2.String22,
    		this.ui.Item3.String23,
    		this.ui.Item4.String24
    	];
    	
    this.modFreqOne = new Array();
    this.modFreqOne = [
    		this.ui.Item1.ModFreq11,
    		this.ui.Item2.ModFreq12,
    		this.ui.Item3.ModFreq13,
    		this.ui.Item4.ModFreq14
    	];
    	
	this.modFreqTwo = new Array();
    this.modFreqTwo = [
    		this.ui.Item1.ModFreq21,
    		this.ui.Item2.ModFreq22,
    		this.ui.Item3.ModFreq23,
    		this.ui.Item4.ModFreq24
    	];
    	
    this.modLevelOne = new Array();
    this.modLevelOne = [
    		this.ui.Item1.ModLevel11,
    		this.ui.Item2.ModLevel12,
    		this.ui.Item3.ModLevel13,
    		this.ui.Item4.ModLevel14
    	];
    	
    this.modLevelTwo = new Array();
    this.modLevelTwo = [
    		this.ui.Item1.ModLevel21,
    		this.ui.Item2.ModLevel22,
    		this.ui.Item3.ModLevel23,
    		this.ui.Item4.ModLevel24
    	];
    	
    this.enumOne = new Array();
    this.enumOne = [
    		this.ui.Item1.Enum11,
    		this.ui.Item2.Enum12,
    		this.ui.Item3.Enum13,
    		this.ui.Item4.Enum14
    	];
    	
    this.enumTwo = new Array();
    this.enumTwo = [
    		this.ui.Item1.Enum21,
    		this.ui.Item2.Enum22,
    		this.ui.Item3.Enum23,
    		this.ui.Item4.Enum24
    	];
    	
    this.enumFour = new Array();
    this.enumFour = [
		this.ui.Item1.Enum41,
		this.ui.Item2.Enum42,
		this.ui.Item3.Enum43,
		this.ui.Item4.Enum44
	];
	
	this.enumFour[0].currentIndexChanged.connect(this, this.checkType1);
	this.enumFour[1].currentIndexChanged.connect(this, this.checkType2);
	this.enumFour[2].currentIndexChanged.connect(this, this.checkType3);
	this.enumFour[3].currentIndexChanged.connect(this, this.checkType4);
    	
    this.level = new Array();
    this.level = [
    		this.ui.Item1.Level1,
    		this.ui.Item2.Level2,
    		this.ui.Item3.Level3,
    		this.ui.Item4.Level4
    	];
}

Initialize.prototype.showModFreqOnes = function(show)
{
	for (var i = 0; i < this.modFreqOne.length; i++)
	{
		if (show)
		{
			this.modFreqOne[i].show();
		}
		else
		{	
			this.modFreqOne[i].hide();
		}
	}
}

Initialize.prototype.showModFreqTwos = function(show)
{
	for (var i = 0; i < this.modFreqTwo.length; i++)
	{
		if (show)
		{
			this.modFreqTwo[i].show();
		}
		else
		{	
			this.modFreqTwo[i].hide();
		}
	}
}

Initialize.prototype.showModLevels = function(show)
{
	for (var i = 0; i < this.modLevelOne.length; i++)
	{
		if (show)
		{
			this.modLevelOne[i].show();
			this.modLevelTwo[i].show();
		}
		else
		{	
			this.modLevelOne[i].hide();
			this.modLevelTwo[i].hide();
		}
	}
}

Initialize.prototype.showLongOnes = function(show)
{
	for (var i = 0; i < this.longOne.length; i++)
	{
		if (show)
		{
			this.longOne[i].show();
		}
		else
		{	
			this.longOne[i].hide();
		}
	}
}

Initialize.prototype.showLongTwos = function(show)
{
	for (var i = 0; i < this.longTwo.length; i++)
	{
		if (show)
		{
			this.longTwo[i].show();
		}
		else
		{	
			this.longTwo[i].hide();
		}
	}
}

Initialize.prototype.showLongThrees = function(show)
{
	for (var i = 0; i < this.longThree.length; i++)
	{
		if (show)
		{
			this.longThree[i].show();
		}
		else
		{	
			this.longThree[i].hide();
		}
	}
}

Initialize.prototype.showEnumOnes = function(show)
{
	for (var i = 0; i < this.enumOne.length; i++)
	{
		if (show)
		{
			this.enumOne[i].show();
		}
		else
		{	
			this.enumOne[i].hide();
		}
	}
}

Initialize.prototype.showEnumTwos = function(show)
{
	for (var i = 0; i < this.enumTwo.length; i++)
	{
		if (show)
		{
			this.enumTwo[i].show();
		}
		else
		{	
			this.enumTwo[i].hide();
		}
	}
}

Initialize.prototype.showEnumFours = function(show)
{
	for (var i = 0; i < this.enumFour.length; i++)
	{
		if (show)
		{
			this.enumFour[i].show();
		}
		else
		{	
			this.enumFour[i].hide();
		}
	}
}

Initialize.prototype.showStringOnes = function(show)
{
	for (var i = 0; i < this.stringOne.length; i++)
	{
		if (show)
		{
			this.stringOne[i].show();
		}
		else
		{	
			this.stringOne[i].hide();
		}
	}
}

Initialize.prototype.showStringTwos = function(show)
{
	for (var i = 0; i < this.stringTwo.length; i++)
	{
		if (show)
		{
			this.stringTwo[i].show();
		}
		else
		{	
			this.stringTwo[i].hide();
		}
	}
}

Initialize.prototype.setModFreqTwosText = function(text)
{
	for (var i = 0; i < this.modFreqTwo.length; i++)
	{
		this.modFreqTwo[i].LabelText = text;
	}
}

Initialize.prototype.setModLevelTwosText = function(text)
{
	for (var i = 0; i < this.modLevelTwo.length; i++)
	{
		this.modLevelTwo[i].LabelText = text;
	}
}

Initialize.prototype.setLongOnesText = function(text)
{
	for (var i = 0; i < this.longOne.length; i++)
	{
		this.longOne[i].LabelText = text;
	}
}

Initialize.prototype.setLongOnesBase = function(base)
{
	for (var i = 0; i < this.longOne.length; i++)
	{
		this.longOne[i].Base = base;
	}
}

Initialize.prototype.setLongTwosText = function(text)
{
	for (var i = 0; i < this.longTwo.length; i++)
	{
		this.longTwo[i].LabelText = text;
	}
}

Initialize.prototype.setEnumOnesText = function(text)
{
	for (var i = 0; i < this.enumOne.length; i++)
	{
		this.enumOne[i].LabelText = text;
	}
}

Initialize.prototype.setEnumTwosText = function(text)
{
	for (var i = 0; i < this.enumTwo.length; i++)
	{
		this.enumTwo[i].LabelText = text;
	}
}

Initialize.prototype.setStringOnesText = function(text)
{
	for (var i = 0; i < this.stringOne.length; i++)
	{
		this.stringOne[i].LabelText = text;
	}
}

Initialize.prototype.setStringTwosText = function(text)
{
	for (var i = 0; i < this.stringTwo.length; i++)
	{
		this.stringTwo[i].LabelText = text;
	}
}

Initialize.prototype.updateLevelPrecision = function()
{
	var idx = this.ui.GenUnits.currentIndex();
	if (idx == 1) //uV
	{
		for (var i = 0; i < this.level.length; i++)
		{
			this.level[i].Precision = 3;
		}
	}
	else
	{
		for (var i = 0; i < this.level.length; i++)
		{
			this.level[i].Precision = 0;
		}
	}
}

Initialize.prototype.tileClosed = function()
{
	var filter = this.ui.CloseButton.getEventFilter();
	filter.submitWidgetVoid();
}
