function Initialize(tile, engine, system)
{
	tile.disableState("Max");
    this.ui = tile.getContainerFrame();
    //this.ui.Toggle_BerState.toggled.connect(this, this.berStateToggled);
    this.ui.Combo_BurstType.hide();

    this.ui.Combo_Pattern.currentIndexChanged.connect(this, this.changePattern);
    
    this.ui.DmrRepeater.hide();
	this.ui.DmrRepeater.toggled.connect(this, this.dmrRepeaterToggled);
    
    this.ui.QCPComboBox_7.currentIndexChanged.connect(this, this.changeModulation);
    var idx = this.ui.QCPComboBox_7.currentIndex();
    this.changeModulation(idx);
    
    this.ui.Combo_SymClockErrUnit.currentIndexChanged.connect(this, this.symClockUnitsChanged);
    this.symClockUnitsChanged();

	this.ui.Combo_MeasType.hide();
	this.ui.Combo_MeasType.currentIndexChanged.connect(this, this.updateRfPowLabel);
	this.updateRfPowLabel();
	
	this.ui.Combo_RfPowerUnits.currentIndexChanged.connect(this, this.rfPowUnitChanged);
	this.rfPowUnitChanged();
}

Initialize.prototype.changePattern = function(pattern_idx)
{
	if (this.ui.QCPComboBox_7.text() == "dPMR") {
		if(pattern_idx == 0)
		{
			this.ui.Numeric_CalledId.hide();
			this.ui.Numeric_CallingId.hide();
			this.ui.Numeric_ChannelCode.hide();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
		} else {
			this.ui.Numeric_CalledId.show();
			this.ui.Numeric_CallingId.show();
			this.ui.Numeric_ChannelCode.show();
			this.ui.Numeric_CommsFormat.show();
			this.ui.Numeric_EmergencyPriority.show();
		}
	} else if (this.ui.QCPComboBox_7.text() == "ARC") {
		this.ui.Numeric_CalledId.hide();
		this.ui.Numeric_CallingId.hide();
		
		if(pattern_idx == 0)
		{
			this.ui.Numeric_CalledIdARC.hide();
			this.ui.Numeric_CallingIdARC.hide();
			this.ui.Numeric_ChannelCode.hide();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
		} else {
			this.ui.Numeric_CalledIdARC.show();
			this.ui.Numeric_CallingIdARC.show();
			this.ui.Numeric_ChannelCode.show();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
		}
	} else {
		this.ui.Numeric_CalledId.hide();
		this.ui.Numeric_CallingId.hide();
		this.ui.Numeric_ChannelCode.hide();
		this.ui.Numeric_CommsFormat.hide();
		this.ui.Numeric_EmergencyPriority.hide();
	}
}

Initialize.prototype.changeModulation = function(idx)
{
    // TETRA only fields
    this.ui.Numeric_PeakEVM.hide();
    this.ui.Numeric_RMSEVM.hide();
    this.ui.Numeric_ResidualCarrier.hide();
    this.ui.Combo_Sequence.hide(); // Only visible in TETRA BS, show() exec in that block

    // Default precision for all systems EXCEPT TETRA
    this.ui.Numeric_FreqErr.Precision = 2;

	if (this.ui.QCPComboBox_7.text() == "None")
	{
		this.ui.Combo_DmrSlot.hide();
		this.ui.Button_ResetAcq.hide();
		this.ui.QCPPushButton_RfZero.hide();
		this.ui.Numeric_FreqErr.hide();
		this.ui.Combo_FreqErrUnit.hide();
		this.ui.Numeric_SigPwr.hide();
		this.ui.Numeric_BER.hide();
		this.ui.Numeric_Carrier.hide();
		this.ui.Numeric_SymDev.hide();
		this.ui.Combo_Pattern.hide();
	
		this.ui.Numeric_FSKErr.hide();
		this.ui.Combo_Rate.hide();
		this.ui.Numeric_RAN.hide();
		this.ui.Numeric_HighPwr.hide();
		this.ui.Numeric_LowPwr.hide();
		this.ui.Numeric_CallID.hide();
		this.ui.Numeric_RadioID.hide();
		this.ui.Numeric_Color.hide();
		this.ui.Numeric_MagErr.hide();
		this.ui.Numeric_NAC.hide();
		this.ui.Numeric_ModFidly.hide();
		this.ui.Numeric_ModFidly.LabelText = "EVM";

		this.ui.Numeric_RfPower.hide();
		this.ui.Combo_RfPowerUnits.hide();
		
		this.ui.Numeric_CalledId.hide();
		this.ui.Numeric_CallingId.hide();
		this.ui.Numeric_ChannelCode.hide();
		this.ui.Numeric_CommsFormat.hide();
		this.ui.Numeric_EmergencyPriority.hide();
		this.ui.Numeric_SymbolClockErr.hide();
		this.ui.Combo_SymClockErrUnit.hide();
		
		this.ui.Toggle_BerState.hide();
		this.ui.Numeric_CalledIdARC.hide();
		this.ui.Numeric_CallingIdARC.hide();
    }
	else if (this.ui.QCPComboBox_7.text() == "PTC")
	{
		this.ui.Combo_DmrSlot.hide();
		this.ui.Button_ResetAcq.show();
		this.ui.QCPPushButton_RfZero.show();
		this.ui.Numeric_FreqErr.show();
		this.ui.Combo_FreqErrUnit.hide();
		this.ui.Numeric_SigPwr.show();
		this.ui.Numeric_BER.show();
		this.ui.Numeric_Carrier.show();
		this.ui.Numeric_SymDev.hide();
		this.ui.Combo_Pattern.hide();
	
		this.ui.Numeric_FSKErr.hide();
		this.ui.Combo_Rate.show();
		this.ui.Numeric_RAN.hide();
		this.ui.Numeric_HighPwr.hide();
		this.ui.Numeric_LowPwr.hide();
		this.ui.Numeric_CallID.hide();
		this.ui.Numeric_RadioID.hide();
		this.ui.Numeric_Color.hide();
		this.ui.Numeric_MagErr.hide();
		this.ui.Numeric_NAC.hide();
		this.ui.Numeric_ModFidly.show();
		this.ui.Numeric_ModFidly.LabelText = "EVM";
		
		this.ui.Numeric_RfPower.hide();
		this.ui.Combo_RfPowerUnits.hide();
		
		this.ui.Numeric_CalledId.hide();
		this.ui.Numeric_CallingId.hide();
		this.ui.Numeric_ChannelCode.hide();
		this.ui.Numeric_CommsFormat.hide();
		this.ui.Numeric_EmergencyPriority.hide();
		this.ui.Numeric_SymbolClockErr.hide();
		this.ui.Combo_SymClockErrUnit.hide();
		
		this.ui.Toggle_BerState.show();
		this.ui.Numeric_CalledIdARC.hide();
		this.ui.Numeric_CallingIdARC.hide();
    }
    else if (this.ui.QCPComboBox_7.text() === "TETRA BS")
    {
        this.ui.Numeric_FreqErr.Precision = 1;
        
        // Visible items
        this.ui.Combo_Pattern.show();
        this.ui.Numeric_BER.show();
        //this.ui.Combo_Sequence.show(); // Hidden for now per screenshots from marketing
        this.ui.Numeric_FreqErr.show();
        this.ui.Numeric_SigPwr.show();
        this.ui.Numeric_PeakEVM.show();
        this.ui.Numeric_RMSEVM.show();
        this.ui.Numeric_ResidualCarrier.show();
        this.ui.Button_ResetAcq.show();
        this.ui.QCPPushButton_2.show();

        // Hidden items
        this.ui.QCPPushButton_RfZero.hide();
        this.ui.Numeric_Carrier.hide();
        this.ui.Numeric_SymDev.hide();
        this.ui.Numeric_FSKErr.hide();
        this.ui.Combo_Rate.hide();
        this.ui.Numeric_RAN.hide();
        this.ui.Numeric_HighPwr.hide();
        this.ui.Numeric_LowPwr.hide();
        this.ui.Numeric_CallID.hide();
        this.ui.Numeric_RadioID.hide();
        this.ui.Numeric_Color.hide();
        this.ui.Numeric_MagErr.hide();
        this.ui.Numeric_NAC.hide();
        this.ui.Numeric_ModFidly.hide();
        this.ui.Numeric_RfPower.hide();
        this.ui.Combo_RfPowerUnits.hide();
        this.ui.Numeric_CalledId.hide();
        this.ui.Numeric_CallingId.hide();
        this.ui.Numeric_ChannelCode.hide();
        this.ui.Numeric_CommsFormat.hide();
        this.ui.Numeric_EmergencyPriority.hide();
        this.ui.Numeric_SymbolClockErr.hide();
        this.ui.Combo_SymClockErrUnit.hide();
        this.ui.Toggle_BerState.hide();
        this.ui.Combo_FreqErrUnit.hide();
        this.ui.Numeric_CallingIdARC.hide();
        this.ui.Numeric_CalledIdARC.hide();
        this.ui.Combo_DmrSlot.hide();
        this.ui.QCPComboBox_7.hide();
    }
    else
	{
		// 0=AM, 1=FM, 2=P25, 3=DMR, 4=NXDN, 5=dPMR, 6=ARIBT98
		if (idx == 0 || idx == 1) { //AM or FM
			this.ui.Combo_DmrSlot.hide();
			this.ui.Button_ResetAcq.hide();
			this.ui.QCPPushButton_RfZero.hide();
			this.ui.Numeric_FreqErr.hide();
			this.ui.Combo_FreqErrUnit.hide();
			this.ui.Numeric_SigPwr.hide();
			this.ui.Numeric_BER.hide();
			this.ui.Numeric_SymDev.hide();
			this.ui.Numeric_Carrier.hide();
			this.ui.Combo_Pattern.hide();
		
			this.ui.Numeric_FSKErr.hide();
			this.ui.Combo_Rate.hide();
			this.ui.Numeric_RAN.hide();
			this.ui.Numeric_HighPwr.hide();
			this.ui.Numeric_LowPwr.hide();
			this.ui.Numeric_CallID.hide();
			this.ui.Numeric_RadioID.hide();
			this.ui.Numeric_Color.hide();
			this.ui.Numeric_MagErr.hide();
			this.ui.Numeric_NAC.hide();
			this.ui.Numeric_ModFidly.hide();
			
			this.ui.Numeric_RfPower.hide();
			this.ui.Combo_RfPowerUnits.hide();
			
			this.ui.Numeric_CalledId.hide();
			this.ui.Numeric_CallingId.hide();
			this.ui.Numeric_ChannelCode.hide();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
			this.ui.Numeric_SymbolClockErr.hide();
			this.ui.Combo_SymClockErrUnit.hide();
			
			this.ui.Toggle_BerState.hide();
			this.ui.Numeric_CalledIdARC.hide();
			this.ui.Numeric_CallingIdARC.hide();
		    var pattern_idx = this.ui.Combo_Pattern.currentIndex();
    		this.changePattern(pattern_idx);

		} else if (idx == 2 || idx == 8 || idx == 9) { //P25
			this.ui.Combo_DmrSlot.hide();
			this.ui.Button_ResetAcq.show();
			this.ui.QCPPushButton_RfZero.show();
			this.ui.Numeric_FreqErr.show();
			this.ui.Combo_FreqErrUnit.hide();
			this.ui.Numeric_SigPwr.show();
			this.ui.Numeric_BER.show();
			this.ui.Numeric_SymDev.LabelText = "Sym Dev";
			this.ui.Numeric_SymDev.show();
			this.ui.Combo_Pattern.show();
		
			this.ui.Numeric_FSKErr.hide();
			this.ui.Combo_Rate.hide();
			this.ui.Numeric_RAN.hide();
			this.ui.Numeric_Carrier.hide();
			
			this.ui.Numeric_HighPwr.hide();
			this.ui.Numeric_LowPwr.hide();
			this.ui.Numeric_CallID.hide();
			this.ui.Numeric_RadioID.hide();
			this.ui.Numeric_Color.hide();
			this.ui.Numeric_MagErr.hide();
			
			if(idx == 2)	// C4FM
			{
				this.ui.Numeric_NAC.show();
			}
			else	// HCPM or HDQPSK
			{
				this.ui.Numeric_NAC.hide();
			}
			
			
			this.ui.Numeric_ModFidly.show();
			this.ui.Numeric_ModFidly.LabelText = "Mod Fidelity";
			
			this.ui.Numeric_RfPower.show();
			this.ui.Combo_RfPowerUnits.show();
			
			this.ui.Numeric_CalledId.hide();
			this.ui.Numeric_CallingId.hide();
			this.ui.Numeric_ChannelCode.hide();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
			this.ui.Numeric_SymbolClockErr.show();
			this.ui.Combo_SymClockErrUnit.show();
			
			this.ui.Toggle_BerState.hide();
			this.ui.Numeric_CalledIdARC.hide();
			this.ui.Numeric_CallingIdARC.hide();

    		var pattern_idx = this.ui.Combo_Pattern.currentIndex();
    		this.changePattern(pattern_idx);

		} else if(idx == 3) { //DMR
			this.dmrRepeaterToggled();
			this.ui.Button_ResetAcq.show();
			this.ui.QCPPushButton_RfZero.show();
			this.ui.Numeric_FreqErr.show();
			this.ui.Combo_FreqErrUnit.hide();
			this.ui.Numeric_SigPwr.show();
			this.ui.Numeric_BER.show();
			this.ui.Numeric_SymDev.LabelText = "Sym Dev";
			this.ui.Numeric_SymDev.show();
			this.ui.Combo_Pattern.show();
			
			this.ui.Numeric_NAC.hide();
			this.ui.Combo_Rate.hide();
			this.ui.Numeric_RAN.hide();
			this.ui.Numeric_ModFidly.hide();
			this.ui.Numeric_Carrier.hide();
			
			this.ui.Numeric_FSKErr.show();
			this.ui.Numeric_HighPwr.show();
			this.ui.Numeric_LowPwr.show();
			this.ui.Numeric_CallID.hide();
			this.ui.Numeric_RadioID.hide();
			this.ui.Numeric_Color.show();
			this.ui.Numeric_MagErr.show();
			
			this.ui.Numeric_RfPower.show();
			this.ui.Combo_RfPowerUnits.show();
			
			this.ui.Numeric_CalledId.hide();
			this.ui.Numeric_CallingId.hide();
			this.ui.Numeric_ChannelCode.hide();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
			this.ui.Numeric_SymbolClockErr.show();
			this.ui.Combo_SymClockErrUnit.show();
			
			this.ui.Toggle_BerState.hide();
			this.ui.Numeric_CalledIdARC.hide();
			this.ui.Numeric_CallingIdARC.hide();

    		var pattern_idx = this.ui.Combo_Pattern.currentIndex();
    		this.changePattern(pattern_idx);

		} else if (idx == 4) { //NXDN
			this.ui.Combo_DmrSlot.hide();
			this.ui.Button_ResetAcq.show();
			this.ui.QCPPushButton_RfZero.show();
			this.ui.Numeric_FreqErr.show();
			this.ui.Combo_FreqErrUnit.hide();
			this.ui.Numeric_SigPwr.show();
			this.ui.Numeric_BER.show();
			this.ui.Numeric_SymDev.LabelText = "Sym Dev";
			this.ui.Numeric_SymDev.show();
			this.ui.Combo_Pattern.show();
			
			this.ui.Numeric_HighPwr.hide();
			this.ui.Numeric_LowPwr.hide();
			this.ui.Numeric_CallID.hide();
			this.ui.Numeric_RadioID.hide();
			this.ui.Numeric_Color.hide();
			this.ui.Numeric_MagErr.hide();
			this.ui.Numeric_NAC.hide();
			this.ui.Numeric_ModFidly.hide();
			this.ui.Numeric_Carrier.hide();
			
			this.ui.Numeric_FSKErr.show();
			this.ui.Combo_Rate.show();
			this.ui.Numeric_RAN.show();
			
			this.ui.Numeric_RfPower.show();
			this.ui.Combo_RfPowerUnits.show();
			
			this.ui.Numeric_CalledId.hide();
			this.ui.Numeric_CallingId.hide();
			this.ui.Numeric_ChannelCode.hide();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
			this.ui.Numeric_SymbolClockErr.show();
			this.ui.Combo_SymClockErrUnit.show();
			
			this.ui.Toggle_BerState.hide();
			this.ui.Numeric_CalledIdARC.hide();
			this.ui.Numeric_CallingIdARC.hide();

    		var pattern_idx = this.ui.Combo_Pattern.currentIndex();
    		this.changePattern(pattern_idx);

		} else if (idx == 5) { //dPMR
			this.ui.Combo_DmrSlot.hide();
			this.ui.Button_ResetAcq.show();
			this.ui.QCPPushButton_RfZero.show();
			this.ui.Numeric_FreqErr.show();
			this.ui.Combo_FreqErrUnit.hide();
			this.ui.Numeric_SigPwr.show();
			this.ui.Numeric_BER.show();
			this.ui.Numeric_SymDev.LabelText = "Sym Dev";
			this.ui.Numeric_SymDev.show();
			this.ui.Combo_Pattern.show();
			
			this.ui.Numeric_HighPwr.hide();
			this.ui.Numeric_LowPwr.hide();
			this.ui.Numeric_CallID.hide();
			this.ui.Numeric_RadioID.hide();
			this.ui.Numeric_Color.hide();
			this.ui.Numeric_MagErr.hide();
			this.ui.Numeric_NAC.hide();
			this.ui.Numeric_ModFidly.hide();
			this.ui.Combo_Rate.hide();
			this.ui.Numeric_RAN.hide();
			this.ui.Numeric_Carrier.hide();
			
			this.ui.Numeric_FSKErr.show();	 
			
			this.ui.Numeric_RfPower.show();
			this.ui.Combo_RfPowerUnits.show();
			
			this.ui.Numeric_CalledId.show();
			this.ui.Numeric_CallingId.show();
			this.ui.Numeric_ChannelCode.show();
			this.ui.Numeric_CommsFormat.show();
			this.ui.Numeric_EmergencyPriority.show();
			this.ui.Numeric_SymbolClockErr.show();
			this.ui.Combo_SymClockErrUnit.show();
			
			this.ui.Toggle_BerState.hide();
			this.ui.Numeric_CalledIdARC.hide();
			this.ui.Numeric_CallingIdARC.hide();

    		var pattern_idx = this.ui.Combo_Pattern.currentIndex();
    		this.changePattern(pattern_idx);

		} else if (idx == 6) { //"ARIB98"
			this.ui.Combo_DmrSlot.hide();
			this.ui.Button_ResetAcq.show();
			this.ui.QCPPushButton_RfZero.show();
			this.ui.Numeric_FreqErr.show();
			this.ui.Combo_FreqErrUnit.hide();
			this.ui.Numeric_SigPwr.show();
			this.ui.Numeric_BER.show();
			this.ui.Numeric_SymDev.LabelText = "Sym Dev";
			this.ui.Numeric_SymDev.show();
			this.ui.Combo_Pattern.show();
			
			this.ui.Numeric_HighPwr.hide();
			this.ui.Numeric_LowPwr.hide();
			this.ui.Numeric_CallID.hide();
			this.ui.Numeric_RadioID.hide();
			this.ui.Numeric_Color.hide();
			this.ui.Numeric_MagErr.hide();
			this.ui.Numeric_NAC.hide();
			this.ui.Numeric_ModFidly.hide();
			this.ui.Combo_Rate.hide();
			this.ui.Numeric_RAN.hide();
			this.ui.Numeric_Carrier.hide();
			
			this.ui.Numeric_FSKErr.show();
			
			this.ui.Numeric_RfPower.show();
			this.ui.Combo_RfPowerUnits.show();
			
			this.ui.Numeric_CalledId.hide();
			this.ui.Numeric_CallingId.hide();
			this.ui.Numeric_ChannelCode.hide();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
			this.ui.Numeric_SymbolClockErr.show();
			this.ui.Combo_SymClockErrUnit.show();
			
			this.ui.Toggle_BerState.hide();
			this.ui.Numeric_CalledIdARC.hide();
			this.ui.Numeric_CallingIdARC.hide();

    		var pattern_idx = this.ui.Combo_Pattern.currentIndex();
    		this.changePattern(pattern_idx);

		} else if (idx == 11) { //ARC
			this.ui.Combo_DmrSlot.hide();
			this.ui.Button_ResetAcq.show();
			this.ui.QCPPushButton_RfZero.show();
			this.ui.Numeric_FreqErr.show();
			this.ui.Combo_FreqErrUnit.hide();
			this.ui.Numeric_SigPwr.show();
			this.ui.Numeric_BER.show();
			this.ui.Numeric_SymDev.LabelText = "Sym Dev";
			this.ui.Numeric_SymDev.show();
			this.ui.Combo_Pattern.show();
			
			this.ui.Numeric_HighPwr.hide();
			this.ui.Numeric_LowPwr.hide();
			this.ui.Numeric_CallID.hide();
			this.ui.Numeric_RadioID.hide();
			this.ui.Numeric_Color.hide();
			this.ui.Numeric_MagErr.hide();
			this.ui.Numeric_NAC.hide();
			this.ui.Numeric_ModFidly.hide();
			this.ui.Combo_Rate.hide();
			this.ui.Numeric_RAN.hide();
			this.ui.Numeric_Carrier.hide();
			
			this.ui.Numeric_FSKErr.show();	 
			
			this.ui.Numeric_RfPower.show();
			this.ui.Combo_RfPowerUnits.show();
			
			this.ui.Numeric_ChannelCode.show();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
			this.ui.Numeric_SymbolClockErr.show();
			this.ui.Combo_SymClockErrUnit.show();
			
			this.ui.Toggle_BerState.hide();

    		var pattern_idx = this.ui.Combo_Pattern.currentIndex();
    		this.changePattern(pattern_idx);

		} else if (idx == 10) { //"FM P25 Phase 2"
			this.ui.Combo_DmrSlot.hide();
			this.ui.Button_ResetAcq.hide();
			this.ui.QCPPushButton_RfZero.hide();
			this.ui.Numeric_FreqErr.show();
			this.ui.Combo_FreqErrUnit.show();
			this.ui.Numeric_SigPwr.hide();
			this.ui.Numeric_BER.hide();
			this.ui.Numeric_SymDev.LabelText = "Deviation";
			this.ui.Numeric_SymDev.show();
			this.ui.Combo_Pattern.hide();
			
			this.ui.Numeric_HighPwr.hide();
			this.ui.Numeric_LowPwr.hide();
			this.ui.Numeric_CallID.hide();
			this.ui.Numeric_RadioID.hide();
			this.ui.Numeric_Color.hide();
			this.ui.Numeric_MagErr.hide();
			this.ui.Numeric_NAC.hide();
			this.ui.Numeric_ModFidly.hide();
			this.ui.Combo_Rate.hide();
			this.ui.Numeric_RAN.hide();
			this.ui.Numeric_Carrier.hide();
			
			this.ui.Numeric_FSKErr.hide();
			
			this.ui.Numeric_RfPower.show();
			this.ui.Combo_RfPowerUnits.show();
			
			this.ui.Numeric_CalledId.hide();
			this.ui.Numeric_CallingId.hide();
			this.ui.Numeric_ChannelCode.hide();
			this.ui.Numeric_CommsFormat.hide();
			this.ui.Numeric_EmergencyPriority.hide();
			this.ui.Numeric_SymbolClockErr.hide();
			this.ui.Combo_SymClockErrUnit.hide();
			
			this.ui.Toggle_BerState.hide();
			this.ui.Numeric_CalledIdARC.hide();
			this.ui.Numeric_CallingIdARC.hide();
		}
	}
}

Initialize.prototype.symClockUnitsChanged = function()
{
	var idx = this.ui.Combo_SymClockErrUnit.currentIndex();
	if (idx == 0) //ppm
	{
		this.ui.Numeric_SymbolClockErr.Precision = 2;
	}
	else //Hz
	{
		this.ui.Numeric_SymbolClockErr.Precision = 4;
	}
}

Initialize.prototype.berStateToggled = function()
{
	var state = this.ui.Toggle_BerState.State;
	if (!state && this.ui.QCPComboBox_7.text() == "PTC")
	{
		this.ui.Combo_BurstType.show();
	}
	else
	{
		this.ui.Combo_BurstType.hide();
	}
}

Initialize.prototype.updateRfPowLabel = function()
{
	var idx = this.ui.Combo_MeasType.currentIndex();
	switch(Number(idx))
	{
		case 0: //avg
			this.ui.Numeric_RfPower.LabelText = "RF Power Avg";
			break;
		case 1: //min
			this.ui.Numeric_RfPower.LabelText = "RF Power Min";
			break;
		case 2: //max
			this.ui.Numeric_RfPower.LabelText = "RF Power Max";
			break;
	}
}

Initialize.prototype.rfPowUnitChanged = function()
{
	var idx = this.ui.Combo_RfPowerUnits.currentIndex();
	if (idx == 0)
	{
		this.ui.Numeric_RfPower.Precision = 1;
	}
	else
	{
		this.ui.Numeric_RfPower.Precision = 2;
	}
}

Initialize.prototype.dmrRepeaterToggled = function()
{
	if (this.ui.QCPComboBox_7.currentIndex() == 3)
	{
		var state = this.ui.DmrRepeater.State;
		if (state)
		{
			this.ui.Combo_DmrSlot.show();
		}
		else
		{
			this.ui.Combo_DmrSlot.hide();	
		}
	}
}
