function Initialize(tile, engine, system)
{
	tile.disableState("Max");
    this.ui = tile.getContainerFrame();
    this.ui.Div.currentIndexChanged.connect(this, this.updateYScale);
    this.ui.TopOfScale['valueChanged(double, QString)'].connect(this, this.updateYScale);
    this.updateYScale();
    
    this.ui.Average['valueChanged(double, QString)'].connect(this, this.updateAverage);
    this.updateAverage();
    this.ui.Average.hide();
    
    this.passVal = this.ui.Pass.Value;
    this.ui.Pass.valueChanged.connect(this, this.updatePass);
    
    this.ui.QCPComboBox_DemodType.hide();
    this.ui.QCPComboBox_DemodType.currentIndexChanged.connect(this, this.changeModulation);
    var idx = this.ui.QCPComboBox_DemodType.currentIndex();
    this.changeModulation(idx);
}

Initialize.prototype.updateYScale = function()
{
	var top = this.ui.TopOfScale.value();
	var div = this.ui.Div.currentIndex();
	
	this.ui.QCPPowerProfile.YLeftUpperLimit = top;
	this.ui.QCPPowerProfile.YLeftLowerLimit = top - (div * 8);
}

Initialize.prototype.updateAverage = function()
{
	this.ui.QCPPowerProfile.setAverage(this.ui.Average.value());
}

Initialize.prototype.updatePass = function()
{
	if (this.passVal != this.ui.Pass.Value)
	{
		this.passVal = this.ui.Pass.Value;
		this.ui.QCPPowerProfile.setTracePass(this.ui.Pass.Value);
	}
}

Initialize.prototype.changeModulation = function(idx)
{
	if (idx == 3 || idx == 8) // 3 = DMR, 8 = HCPM
	{
		// set to last pass fail value so limits are drawn again
		this.ui.QCPPowerProfile.setTracePass(this.passVal);
	}
	else
	{
		this.ui.QCPPowerProfile.deactivatePassFail();
	}
}
