function Initialize(tile, engine, system)
{
	tile.disableState("Max");
    this.ui = tile.getContainerFrame();
    this.ui.NumSymbols.currentIndexChanged.connect(this, this.changeNumSymbols);
    var idx = this.ui.NumSymbols.currentIndex();
    this.changeNumSymbols(idx);
    this.ui.TypeCombo.currentIndexChanged.connect(this, this.changeType);
    idx = this.ui.TypeCombo.currentIndex();
    this.changeType(idx);
    this.ui.TypeCombo.hide();
}

Initialize.prototype.changeNumSymbols = function(idx)
{
	this.ui.QCPPlotManager.XBottomUpperLimit = idx;
	this.ui.QCPPlotManager.XLines = idx;
}

Initialize.prototype.changeType = function(idx)
{
	switch(Number(idx))
	{
		case 3:
			this.ui.QCPPlotManager.YLeftLowerLimit = -3240;
			this.ui.QCPPlotManager.YLeftUpperLimit = 3240;
			break;
		case 5:
			this.ui.QCPPlotManager.YLeftLowerLimit = -1750;
			this.ui.QCPPlotManager.YLeftUpperLimit = 1750;
			break;
		default:
			break;
	}
}