function Initialize(tile, engine, system)
{
    tile.enableState("Thumb");
    tile.configureState("Thumb", "200|200");
    tile.configureState("Min", "200|400");
    tile.setDefaultState("Thumb");
    tile.showSendToBackButton(false);
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    this.ui.stackedWidget.hide();
    
    this.ui.widget.QCPNumericMeterReading['unitChanged(int)'].connect(this, this.ReadingUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3['unitChanged(int)'].connect(this, this.UpperUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4['unitChanged(int)'].connect(this, this.LowerUnitChanged);
    
    var idx = this.ui.widget.QCPNumericMeterReading.unitIndex();
    this.ReadingUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.unitIndex();
    this.UpperUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.unitIndex();
    this.LowerUnitChanged(idx);
    
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_2.currentIndexChanged.connect(this, this.measTypeChanged);
    this.measTypeChanged();
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
        this.ui.stackedWidget.show();
        this.ui.widget.QCPComboBox_4.hide();
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
        this.ui.stackedWidget.hide();
        this.ui.widget.QCPComboBox_4.show();
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(0);	
        this.ui.stackedWidget.hide();
        this.ui.widget.QCPComboBox_4.show();
    }   	
}

Initialize.prototype.UpperUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0: //dB
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.Precision = 2;
			break;
		case 1: //kHz
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.Precision = 3;
			break;
		case 2: //Hz
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.Precision = 0;
			break;
		case 3: //%
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.Precision = 1;
			break;
	}
}

Initialize.prototype.LowerUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0: //dB
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.Precision = 2;
			break;
		case 1: //kHz
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.Precision = 3;
			break;
		case 2: //Hz
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.Precision = 0;
			break;
		case 3: //%
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.Precision = 1;
			break;
	}
}

Initialize.prototype.ReadingUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0: //dB
    		this.ui.widget.QCPNumericMeterReading.Precision = 2;
			break;
		case 1: //kHz
    		this.ui.widget.QCPNumericMeterReading.Precision = 3;
			break;
		case 2: //Hz
    		this.ui.widget.QCPNumericMeterReading.Precision = 0;
			break;
		case 3: //%
    		this.ui.widget.QCPNumericMeterReading.Precision = 1;
			break;
	}
}

Initialize.prototype.measTypeChanged = function()
{
	print("Initialize.prototype.measTypeChanged"); 
	
	var idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_2.currentIndex();
	
	switch(idx)
	{
		case 0:	//peak plus	
			this.ui.widget.QCPNumericMeterReading.LabelText = "Peak(+) Reading";
			break;
		case 1:	//peak minus	
			this.ui.widget.QCPNumericMeterReading.LabelText = "Peak(-) Reading";
			break;
		case 2:	//pk-pk/2	
			this.ui.widget.QCPNumericMeterReading.LabelText = "Pk-Pk/2 Reading";
			break;
		case 3: //rms
			this.ui.widget.QCPNumericMeterReading.LabelText = "RMS Reading";
			break;
	}
}