function Initialize(tile, engine, system)
{
    tile.enableState("Thumb");
    tile.configureState("Min", "240|400");
    tile.setDefaultState("Thumb");
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    this.ui.stackedWidget.hide();
    
    this.ui.widget.QCPNumericMeterReading['unitChanged(int)'].connect(this, this.ReadingUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3['unitChanged(int)'].connect(this, this.UpperUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4['unitChanged(int)'].connect(this, this.LowerUnitChanged);
    
    var idx = this.ui.widget.QCPNumericMeterReading.unitIndex();
    this.ReadingUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.unitIndex();
    this.UpperUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.unitIndex();
    this.LowerUnitChanged(idx);
    
    tile.showSendToBackButton(false);
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
        this.ui.stackedWidget.show();
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
        this.ui.stackedWidget.hide();
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(0);	
        this.ui.stackedWidget.hide();
    }   	
}

Initialize.prototype.UpperUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.Precision = 3;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.Precision = 1;
			break;
	}
}

Initialize.prototype.LowerUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.Precision = 3;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.Precision = 1;
			break;
	}
}

Initialize.prototype.ReadingUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.widget.QCPNumericMeterReading.Precision = 3;
			break;
		case 1:
    		this.ui.widget.QCPNumericMeterReading.Precision = 1;
			break;
	}
}
