#!/usr/bin/env python
#----------------------------------------------------------------------------
# Copyright 2014 Aeroflex Incorporated. All rights reserved.
#----------------------------------------------------------------------------
from subprocess import Popen, PIPE
from glob       import glob
from time       import sleep
from os         import getcwd, path, mkdir, chdir, symlink, remove, stat
from shutil     import rmtree, move
import logging
#----------------------------------------------------------------------------
storagepath = '/mnt/mmcblk0p1/AutoTestResults/'
storagepathmt = '/mnt/mmcblk0p1/MissionTestResults/'
#----------------------------------------------------------------------------
# This directory is now created when autotest core is installed, however I'm leaving this here as a fail safe.
try   : mkdir(storagepath)
except: pass

#----------------------------------------------------------------------------
class filecheck(object):
    def __init__(self) :
        logging.basicConfig(level=logging.DEBUG, format='%(asctime)s %(levelname)s %(message)s', filename='%sdatabase.log' % storagepath, filemode='w')

        logging.debug("filecheck 2.0.1")

        checkpath = storagepath + 'resultsbackup'
        if path.lexists(checkpath):
            logging.debug("Removing auto test resultsbackup")
            rmtree(checkpath)
        #----------------------------------------------------------------------------
        try   : mkdir(storagepathmt)
        except: pass
        checkpath = storagepathmt + 'resultsbackup'
        if path.lexists(checkpath):
            logging.debug("Removing mission test resultsbackup")
            rmtree(checkpath)
        #----------------------------------------------------------------------------
        if path.lexists('/USER/AutoTestResults') == False:
            tmp = getcwd()
            try:
                logging.debug('Creating Symlink')
                chdir('/USER/')
                symlink(storagepath, 'AutoTestResults')
                chdir(tmp)
            except Exception, err:
                logging.debug(err)
        #----------------------------------------------------------------------------
        if path.lexists('/USER/MissionTestResults') == False:
            tmp = getcwd()
            try:
                logging.debug('Creating Symlink')
                chdir('/USER/')
                symlink(storagepathmt, 'MissionTestResults')
                chdir(tmp)
            except Exception, err:
                logging.debug(err)
        logging.debug('File Check Start')
        self.createautodb()
        self.chkcablelosstbl()
        self.createmissiondb()
        # self.clearoutusedresults()
        for radiopath in glob(getcwd() + '/Radios/*'):
            # Only create the radio.db file in directories that have a .db file with the same name as the directory. Support directories like basemotorola, will be skipped
            if glob(radiopath + '/%s.db' % path.split(radiopath)[1]) != [] :
                logging.debug("Checking: %s" % radiopath)
                self.createradiodb(radiopath)
                self.checkresultsdb(path.split(radiopath)[1], "AT")
                # self.checkresultsdb(path.split(radiopath)[1], "MT")
        oldfile = getcwd() + '/Radios/Shenzhen/Shenzhen.db'
        if path.isfile(oldfile) : remove(oldfile)
        logging.debug('File Check DONE')
    #----------------------------------------------------------------------------
    def createradiodb(self, radiopath):
        # logging.debug("radiopath = %s" % radiopath)
        mpath = '%s/radio.db' % radiopath
        if path.isfile(mpath) == False:
            logging.debug("creating radio.db %s" % mpath)
            self.sendit(["sqlite3", mpath , 'CREATE TABLE classlist ( NAME TEXT );'])
            self.sendit(["sqlite3", mpath , 'CREATE TABLE menuselection ( ID TEXT, SELECTIONS TEXT );'])
            self.sendit(["sqlite3", mpath , 'CREATE TABLE stored_configuration ( NAME TEXT, ROW NUMERIC, TESTIDX NUMERIC, MENUID NUMERIC, LOWLIMIT NUMERIC, HIGHLIMIT NUMERIC, TARGET NUMERIC, INFO TEXT );'])
            self.sendit(["sqlite3", mpath , 'CREATE TABLE testresults ( IDX TEXT, DATA TEXT );'])
            self.sendit(["sqlite3", mpath , 'CREATE TABLE user_configuration ( ROW NUMERIC, TESTIDX NUMERIC, MENUID TEXT, LOWLIMIT NUMERIC, HIGHLIMIT NUMERIC, TARGET NUMERIC, INFO TEXT, LASTCONFIG VARCHAR(200));'])
        else:
            b = path.getsize(mpath)
            if b > 1000:
                logging.debug("File looks valid - size: %s - %s" % (b, mpath))
            else:
                logging.debug("INVALID DATABASE FILE")
                remove(mpath)
                self.createradiodb(radiopath)
    #----------------------------------------------------------------------------
    def checkresultsdb(self, radioID, which="AT"):
        if which == "AT":
            npath = storagepath + radioID + '/'
        else:
            npath = storagepathmt + radioID + '/'

        exportfullname = npath + radioID + '.db'
        
        if path.isdir(npath) == False :
            mkdir(npath)
            self.sendit(['sync'])
            self.createresultsdb(exportfullname)
        elif path.isfile(exportfullname) == False:
            self.createresultsdb(exportfullname)
        else:
            b = path.getsize(exportfullname)
            if b > 1024:
                logging.debug("File looks valid - size: %s - %s" % (b, exportfullname))
            else:
                logging.debug("INVALID DATABASE FILE")
                remove(mpath)
                self.sendit(['sync'])
                self.createresultsdb(exportfullname)
    #----------------------------------------------------------------------------
    def createresultsdb(self, exportfullname):
        # Create results database
        logging.debug('creating results: %s' % exportfullname)
        self.sendit(["sqlite3", exportfullname , 'CREATE TABLE lastresults ( results TEXT );'])
        self.sendit(["sqlite3", exportfullname , 'CREATE TABLE finalresults ( IDX INTEGER PRIMARY KEY, Model TEXT, Serialnumber TEXT, Datetime TEXT, results TEXT );'])
    #----------------------------------------------------------------------------
    def createautodb(self):
        mpath = getcwd() + '/' + 'autotest.db'
        if path.isfile(mpath) == False :
            logging.debug('Creating Autotest.db')
            logging.debug("Creating beep")
            self.sendit(["sqlite3", mpath , 'CREATE TABLE beep ( MSG BOOLEAN, EOT BOOLEAN, EXTENDEDLOG BOOLEAN );'])
            logging.debug("Creating cableloss")
            self.sendit(["sqlite3", mpath , 'CREATE TABLE cableloss ( IDX INTEGER PRIMARY KEY, BAND TEXT, LOSS1 NUMERIC, LOSS2 NUMERIC, LOSS3 NUMERIC, EXTATTN NUMERIC, ENABLEEXTATTN BOOLEAN);'])
            logging.debug("Creating message")
            self.sendit(["sqlite3", mpath , 'CREATE TABLE message   ( ID INTEGER PRIMARY KEY, TYPE TEXT, MSGTXT TEXT, PNG TEXT, B1ENABLE TEXT, B1TEXT TEXT, B2ENABLE TEXT, B2TEXT TEXT, B3ENABLE TEXT, B3TEXT TEXT, B4ENABLE TEXT, B4TEXT TEXT, B5ENABLE TEXT, B5TEXT TEXT );'])
            logging.debug("Creating radioinfo")
            self.sendit(["sqlite3", mpath , 'CREATE TABLE radioinfo ( METARADIO VARCHAR(20), MODELBAND VARCHAR(20), MENU VARCHAR(20), MENUID VARCHAR(20), DIRECTORY VARCHAR(20));'])
            logging.debug("Creating waitflag")
            self.sendit(["sqlite3", mpath , 'CREATE TABLE waitflag  ( FLAG NUMERIC );'])
            logging.debug("Filling Table waitflag")
            self.sendit(["sqlite3", mpath , "INSERT INTO  waitflag  (FLAG) VALUES (0);"])
            logging.debug("Filling Table beep")
            self.sendit(["sqlite3", mpath , 'INSERT INTO  beep  VALUES (0,0,0);'])
            logging.debug("Filling Table cableloss")
            self.sendit(["sqlite3", mpath , "INSERT INTO  cableloss  VALUES (0,'130-180',0,0,0,0,0);"])
            logging.debug("Filling Table cableloss")
            self.sendit(["sqlite3", mpath , "INSERT INTO  cableloss  VALUES (1,'320-560',0,0,0,0,0);"])
            logging.debug("Filling Table cableloss")
            self.sendit(["sqlite3", mpath , "INSERT INTO  cableloss  VALUES (2,'750-870',0,0,0,0,0);"])

    #----------------------------------------------------------------------------
    def createmissiondb(self):
        mpath = getcwd() + '/' + 'mtconfig.db'
        if path.isfile(mpath) == False :
            logging.debug('Creating missiontest.db')
            logging.debug("building runmessages table")
            self.sendit(["sqlite3", mpath , 'CREATE TABLE runmessages ( STARTMESSAGE TEXT, STOPMESSAGE TEXT );'])
            logging.debug("Filling Table runmessages")
            self.sendit(["sqlite3", mpath , 'INSERT INTO  runmessages  VALUES ("","");'])
            logging.debug("building radio_oem table")
            self.sendit(["sqlite3", mpath , 'CREATE TABLE radio_oem ( OEMNAME VARCHAR(100), STATUS VARCHAR(100) );'])
            logging.debug("Filling Table radio_oem")
            self.sendit(["sqlite3", mpath , 'INSERT INTO  radio_oem  VALUES ("Motorola",1);'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  radio_oem  VALUES ("KNG",0);'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  radio_oem  VALUES ("Kenwood NX",0);'])
            logging.debug("building rxconfig")
            self.sendit(["sqlite3", mpath , 'CREATE TABLE rxconfig ( MENUMODEL VARCHAR(100), REALMODEL VARCHAR(20), PROTOCOL VARCHAR(20), ROW VARCHAR(20), TYPE VARCHAR(20), TITLE VARCHAR(100), LOWLIMIT VARCHAR(20), HIGHLIMIT VARCHAR(20), TARGET VARCHAR(20), UNITS VARCHAR(20) );'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  rxconfig  VALUES ("","XTS","",1,4,"BER Level",-125,-50,-90,"dBm");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  rxconfig  VALUES ("","TRBO","",1,4,"BER Level",-125,-50,-90,"dBm");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  rxconfig  VALUES ("","APX","",1,4,"BER Level",-125,-50,-90,"dBm");'])

            self.sendit(["sqlite3", mpath , 'INSERT INTO  rxconfig  VALUES ("","XTS","",0,5,"BER Frames",1,50,4,"");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  rxconfig  VALUES ("","TRBO","",0,5,"BER Frames",1,50,4,"");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  rxconfig  VALUES ("","APX","",0,5,"BER Frames",1,50,4,"");'])

            logging.debug("building txconfig")
            self.sendit(["sqlite3", mpath , 'CREATE TABLE txconfig ( MENUMODEL VARCHAR(100), REALMODEL VARCHAR(20), PROTOCOL VARCHAR(20), ROW VARCHAR(20), TYPE VARCHAR(20), TITLE VARCHAR(100), LOWLIMIT VARCHAR(20), HIGHLIMIT VARCHAR(20), TARGET VARCHAR(20), UNITS VARCHAR(20) );'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  txconfig  VALUES ("","XTS","",0,1,"Modulation Fidelity",.01,5,0,"%");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  txconfig  VALUES ("","XTS","",2,1,"Tx Frequecy Error",-1.5,1.5,0,"ppm");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  txconfig  VALUES ("","XTS","",1,1,"Symbol Deviation",1620,1980,0,"Hz");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  txconfig  VALUES ("","APX","",0,1,"Modulation Fidelity",.01,5,0,"%");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  txconfig  VALUES ("","APX","",1,1,"Symbol Deviation",1620,1980,0,"Hz");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  txconfig  VALUES ("","APX","",2,1,"Tx Frequecy Error",-1.5,1.5,0,"ppm");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  txconfig  VALUES ("","TRBO","",0,1,"FSK Error",.01,5,0,"%");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  txconfig  VALUES ("","TRBO","",1,1,"Symbol Deviation",1749,2139,0,"Hz");'])
            self.sendit(["sqlite3", mpath , 'INSERT INTO  txconfig  VALUES ("","TRBO","",2,1,"Tx Frequecy Error",-1.5,1.5,0,"ppm");'])
    #----------------------------------------------------------------------------
    # send the python constructed method to sqlite for processing
    #----------------------------------------------------------------------------
    def chkcablelosstbl(self):
        mpath = getcwd() + '/' + 'autotest.db'
        tmp = self.sendit(["sqlite3", mpath, "select * from cableloss where IDX = \'0\';" ]).split('|')
        if len(tmp) < 6:
            logging.debug('Rebuilding autotest.db')
            remove(mpath)
            self.createautodb()
    #----------------------------------------------------------------------------
    def sendit(self, cmd):
        myid = Popen(cmd , stdout=PIPE)
        out, err = myid.communicate()
        return out.strip()
    #----------------------------------------------------------------------------

filecheck()
