function Initialize(tile, engine, system)
{
    this.tile = tile;
    this.ui = tile.getContainerFrame();
    this.system = system;

    this.ui.PushButton_Cancel.clicked.connect(this, this.closeSelf);
    this.ui.PushButton_Ok.clicked.connect(this, this.handleLogin);

    var widgetConnector = system.getModule("WidgetConnector");
    
    var filter = widgetConnector.connectWidget(this.ui.TextEntry_Pw);
    filter.submit.connect(this, this.handleLogin);

    this.ui.PushButton_Hidden.hide();

    tile.disableState("Max");
    tile.showSendToBackButton(false);
}

Initialize.prototype.closeSelf = function()
{  
    this.tile.close();
}

Initialize.prototype.handleLogin = function()
{
    if(this.ui.TextEntry_Pw.text == "9992") {
    	var filter = this.ui.PushButton_Hidden.getEventFilter();
    	filter.submit();
        this.closeSelf();
    }
}
