function Initialize(tile, engine, system)
{
    tile.enableState("Thumb");
    tile.configureState("Thumb", "200|200");
    tile.configureState("Min", "200|400");
    tile.setDefaultState("Thumb");
    tile.showSendToBackButton(false);
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    this.ui.stackedWidget.page_2.Tab.widget(0).Combo_Units.currentIndexChanged.connect(this, this.unitsChanged);
    this.ui.stackedWidget.hide();
    
    var idx = this.ui.stackedWidget.page_2.Tab.widget(0).Combo_Units.currentIndex();
    this.unitsChanged(idx);
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
        this.ui.stackedWidget.show();
        this.ui.widget.Combo_Min.hide();
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
        this.ui.stackedWidget.hide();
        this.ui.widget.Combo_Min.show();
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(0);	
        this.ui.stackedWidget.hide();
        this.ui.widget.Combo_Min.show();
    }   	
}

Initialize.prototype.unitsChanged = function(idx)
{
	

	if (Number(idx) == 3)  {
		this.ui.widget.QCPNumericMeterReading.Units = "0,0,13:1;;;;|0,-3,13:1;;;;|0,-6,13:1;;;;";
    	
    	this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_UpperLimit.Units = "0,0,13:1;;;;|0,-3,13:1;;;;|0,-6,13:1;;;;";
		this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_LowerLimit.Units = "0,0,13:1;;;;|0,-3,13:1;;;;|0,-6,13:1;;;;";
	}
	else
	{
		this.ui.widget.QCPNumericMeterReading.Units = "";
		this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_UpperLimit.setUnitIndex(idx);
		this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_LowerLimit.setUnitIndex(idx);
		
		this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_UpperLimit.Units = "";
		this.ui.stackedWidget.page_2.Tab.widget(1).Numeric_LowerLimit.Units = "";
	}
	
	if (idx == 0)
	{
		this.ui.widget.QCPNumericMeterReading.Precision = 1;
	}
	else
	{
		this.ui.widget.QCPNumericMeterReading.Precision = 2;
	}
}
