function Initialize(tile, engine, system)
{
    tile.enableState("Thumb");
    tile.disableState("Max");
    tile.configureState("Min", "200|400");
    tile.configureState("Thumb", "200|200");
    tile.setDefaultState("Thumb");
    tile.showSendToBackButton(false);
    this.ui = tile.getContainerFrame();
    this.system = system;
    tile.changeSize.connect(this, this.resize);
    this.ui.stackedWidget.page_2.QCPNumericValueObj_4['unitChanged(int)'].connect(this, this.freqThumbUnitChanged);
    this.ui.stackedWidget.page.QCPNumericValueObj_3['unitChanged(int)'].connect(this, this.freqMinUnitChanged);
    
    var idx = this.ui.stackedWidget.page_2.QCPNumericValueObj_4.unitIndex();
    this.freqThumbUnitChanged(idx);
    idx = this.ui.stackedWidget.page.QCPNumericValueObj_3.unitIndex();
    this.freqMinUnitChanged(idx);
    
    this.ui.stackedWidget.page.Toggle_Attenuation.toggled.connect(this, this.toggleAttenuation);
    this.ui.stackedWidget.page_2.QCPComboBox_4.currentIndexChanged.connect(this, this.levelUnitChanged);
    this.levelUnitChanged(0);
    
    this.ui.stackedWidget.page.QCPNumericValueObj['valueChanged(double, QString)'].connect(this, this.offsetValueChanged);
    var val = this.ui.stackedWidget.page.QCPNumericValueObj.value();
    this.offsetValueChanged(val, "");
    
	var slider = this.system.getSystemScreen("Slider");
	this.ui.stackedWidget.page.QCPNumeric.lowerLimitChanged.connect(slider, slider.setMinimum);
	this.ui.stackedWidget.page.QCPNumeric.upperLimitChanged.connect(slider, slider.setMaximum);
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(0);;
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(1);
    }   	
}

Initialize.prototype.freqThumbUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_2.QCPNumericValueObj_4.Precision = 6;
			break;
		case 1:
			this.ui.stackedWidget.page_2.QCPNumericValueObj_4.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.QCPNumericValueObj_4.Precision = 3;
			break;
		case 3:
			this.ui.stackedWidget.page_2.QCPNumericValueObj_4.Precision = 0;
			break;
	}
}

Initialize.prototype.freqMinUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page.QCPNumericValueObj_3.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page.QCPNumericValueObj_3.Precision = 6;
			break;
		case 2:
    		this.ui.stackedWidget.page.QCPNumericValueObj_3.Precision = 3;
			break;
		case 3:
    		this.ui.stackedWidget.page.QCPNumericValueObj_3.Precision = 0;
			break;
	}
}

Initialize.prototype.levelUnitChanged = function(idx)
{
	var state = this.ui.stackedWidget.page.Toggle_Attenuation.activeState();
	this.toggleAttenuation(state);
}

Initialize.prototype.toggleAttenuation = function(state)
{
	var levelIdx = this.ui.stackedWidget.page_2.QCPComboBox_4.currentIndex();
	if (levelIdx == 1) // uV
	{
		this.ui.stackedWidget.page.QCPNumeric.Precision = 3;
		this.ui.stackedWidget.page_2.QCPNumeric_2.Precision = 3;
	}
	else if (state) //dBm, Hold Attenuation == true
	{
		this.ui.stackedWidget.page.QCPNumeric.Precision = 1;
		this.ui.stackedWidget.page_2.QCPNumeric_2.Precision = 1;
		var slider = this.system.getSystemScreen("Slider");
		if (slider)
		{
			slider.changePrecision(1);
			slider.Power = -1;
		}
	}
	else //dBm, Hold Attenuation == false
	{
		this.ui.stackedWidget.page.QCPNumeric.Precision = 0;
		this.ui.stackedWidget.page_2.QCPNumeric_2.Precision = 0;
		var slider = this.system.getSystemScreen("Slider");
		if (slider)
		{
			slider.changePrecision(0);
			slider.Power = 0;
		}
	}
}

Initialize.prototype.offsetValueChanged = function(value, unit)
{
	if (value < 0)
		this.ui.stackedWidget.page.QCPNumericValueObj.LabelText = "Loss";
	else if (value == 0)
		this.ui.stackedWidget.page.QCPNumericValueObj.LabelText = "Offset";
	else
		this.ui.stackedWidget.page.QCPNumericValueObj.LabelText = "Gain"; 
}
