function Initialize(tile, engine, system)
{
	tile.enableState("Thumb");
    tile.configureState("Thumb", "200|200");
    tile.configureState("Min", "200|400");
    tile.setDefaultState("Thumb");
    tile.showSendToBackButton(false);
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    this.ui.widget.Combo_Min.currentIndexChanged.connect(this, this.unitsChanged);
    
    var idx = this.ui.widget.Combo_Min.currentIndex();
    this.unitsChanged(idx);
    
    this.ui.stackedWidget.hide();
    
    this.ui.stackedWidget.page_2.Tab.widget(0).Combo_MeasType.currentIndexChanged.connect(this, this.measTypeChanged);
    this.measTypeChanged();
    
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj['valueChanged(double, QString)'].connect(this, this.offsetValueChanged);
    var val = this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.value();
    this.offsetValueChanged(val, "");
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
        this.ui.stackedWidget.show();
        this.ui.widget.Combo_Min.hide();
        this.ui.widget.PushButton_FrontClear.hide();
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
        this.ui.stackedWidget.hide();
        this.ui.widget.Combo_Min.show();
        
        var idx = this.ui.stackedWidget.page_2.Tab.widget(0).Combo_MeasType.currentIndex();
        if (idx == 1 || idx == 2)
        	this.ui.widget.PushButton_FrontClear.show();
    } else if (size == "Peak") {
        this.ui.stackedWidget.setCurrentIndex(1);
        this.ui.stackedWidget.show();
        this.ui.widget.Combo_Min.hide();
        this.ui.widget.PushButton_FrontClear.hide();
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(0);	
        this.ui.stackedWidget.hide();
        this.ui.widget.Combo_Min.show();
        this.ui.widget.PushButton_FrontClear.hide();
    }   	
}

Initialize.prototype.unitsChanged = function(idx)
{
	if (idx == 0)
	{
		this.ui.widget.QCPNumericMeterReading.Precision = 1;
	}
	else
	{
		this.ui.widget.QCPNumericMeterReading.Precision = 2;
	}
}


Initialize.prototype.measTypeChanged = function()
{
	var idx = this.ui.stackedWidget.page_2.Tab.widget(0).Combo_MeasType.currentIndex();
	
	switch(idx)
	{
		case 0:	//avg
			this.ui.stackedWidget.page_2.Tab.widget(0).PushButton_Clear.hide();
			this.ui.widget.QCPNumericMeterReading.LabelText = "Avg Reading";
			break;
		case 1:	//min
			this.ui.stackedWidget.page_2.Tab.widget(0).PushButton_Clear.show();
			this.ui.widget.QCPNumericMeterReading.LabelText = "Min Reading";
			break;
		case 2:	//max
			this.ui.stackedWidget.page_2.Tab.widget(0).PushButton_Clear.show();
			this.ui.widget.QCPNumericMeterReading.LabelText = "Max Reading";
			break;
		case 3:	// peak
			this.ui.stackedWidget.page_2.Tab.widget(0).PushButton_Clear.show();
			this.ui.widget.QCPNumericMeterReading.LabelText = "Peak Reading";
			break;
	}
}

Initialize.prototype.offsetValueChanged = function(value, unit)
{
	if (value < 0)
		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.LabelText = "Loss";
	else if (value == 0)
		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.LabelText = "Offset";
	else
		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.LabelText = "Gain"; 
}