function Initialize(tile, engine, system)
{
    this.ui = tile.getContainerFrame();
    this.system = system;
    this.ui.stackedWidget.setCurrentIndex(1);
    
	this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_VertScale.currentIndexChanged.connect(this, this.vertScaleChanged);
	this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_RefLevel.currentIndexChanged.connect(this, this.tosIdxChanged);
	
	var idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_VertScale.currentIndex();
	this.vertScaleChanged(idx);
	
	idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_RefLevel.currentIndex();
	this.tosIdxChanged(idx);
	
	tile.WindowOpened.connect(this, this.showEvent);
	tile.WindowClosed.connect(this, this.hideEvent);
	
	try 
    { 
        this.ui.stackedWidget.page_2.Tab.widget(3).PlotMarker.attachPlot(this.ui.PlotManager);
    } 
    catch(e) 
    { 
        print("UserInterface - Failed to attach: "+e); 
    }
    
    this.showEvent();
    
    this.ui.stackedWidget.page_2.Tab.widget(0).Freq['unitChanged(int)'].connect(this, this.centerFreqUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(0).StartFreq['unitChanged(int)'].connect(this, this.startFreqUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(0).StopFreq['unitChanged(int)'].connect(this, this.stopFreqUnitChanged);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).Freq.unitIndex();
    this.centerFreqUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).StartFreq.unitIndex();
    this.startFreqUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).StopFreq.unitIndex();
    this.stopFreqUnitChanged(idx);    
    
    this.ui.stackedWidget.page_2.Tab.widget(0).Mode.currentIndexChanged.connect(this, this.modeChanged);
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).Mode.currentIndex();
    this.modeChanged(idx);

	this.ui.stackedWidget.page_2.Tab.widget(0).YUnit.currentIndexChanged.connect(this, this.yUnitChanged);
	//this.ui.stackedWidget.page_2.Tab.widget(1).Type.currentIndexChanged.connect(this, this.typeChanged);
	
	this.ui.stackedWidget.page_2.Tab.widget(4).Button_Save.hide();
	this.ui.stackedWidget.page_2.Tab.widget(4).Button_Load.hide();
	this.ui.stackedWidget.page_2.Tab.widget(4).Text_File.hide();
	
	this.fileBrowser = this.system.getSystemScreen("FileBrowser3550");
    this.ui.stackedWidget.page_2.Tab.widget(4).Button_StoreTrace.clicked.connect(this, this.showStoreBrowser);
    this.ui.stackedWidget.page_2.Tab.widget(4).Button_RecallTrace.clicked.connect(this, this.showRecallBrowser);
    
    this.ui.stackedWidget.page_2.Tab.widget(2).Button_StoreCable.clicked.connect(this, this.showStoreCableBrowser);
    this.ui.stackedWidget.page_2.Tab.widget(2).Button_RecallCable.clicked.connect(this, this.showRecallCableBrowser);
    
    
    //this.ui.stackedWidget.page_2.Tab.widget(0).Distance.currentIndexChanged.connect(this, this.updateXBounds);
    //this.ui.stackedWidget.page_2.Tab.widget(0).XUnit.currentIndexChanged.connect(this, this.updateXBounds);
    
    this.ui.stackedWidget.page_2.Tab.widget(2).Text_Cable.hide();
    this.ui.stackedWidget.page_2.Tab.widget(2).Text_Cable.textChanged.connect(this, this.updateCableLabel);
    this.updateCableLabel();
}

Initialize.prototype.updateXBounds = function()
{
	//get x unit and distance, set x upper bound for both traces
	var xUnitIdx = this.ui.stackedWidget.page_2.Tab.widget(0).XUnit.currentIndex();
	var distanceIdx = this.ui.stackedWidget.page_2.Tab.widget(0).Distance.currentIndex();
	if (xUnitIdx == 0) //feet
	{
		switch(distanceIdx)
		{
			case 0: // 32 ft
				this.ui.PlotManager.XBottomUpperLimit = 32.0;
				break;
			case 1: // 65 ft
				this.ui.PlotManager.XBottomUpperLimit = 65.0;
				break;
			case 2: // 164 ft
				this.ui.PlotManager.XBottomUpperLimit = 164.0;
				break;
			case 3: // 327 ft
				this.ui.PlotManager.XBottomUpperLimit = 327.0;
				break;
		}
	}
	else //meters
	{
		switch(distanceIdx)
		{
			case 0: // 10 m
				this.ui.PlotManager.XBottomUpperLimit = 10.0;
				break;
			case 1: // 20 m
				this.ui.PlotManager.XBottomUpperLimit = 20.0;
				break;
			case 2: // 50 m
				this.ui.PlotManager.XBottomUpperLimit = 50.0;
				break;
			case 3: // 100 m
				this.ui.PlotManager.XBottomUpperLimit = 100.0;
				break;
		}
	}
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
        var idx = this.ui.stackedWidget.page_2.Tab.widget(0).Mode.currentIndex();
    	this.modeChanged(idx);
    } else if (size == "Min") {
        this.ui.stackedWidget.setCurrentIndex(0);
    }
}

Initialize.prototype.tosIdxChanged = function(idx)
{
	var ul = 0.0;
	var ll = 0.0;
	var vscaleEnum = 0.0;
	var vscale = 0.0;
	var vscaleArray = null;

	vscaleEnum = this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_VertScale.currentIndex();
	
	var yUnitIdx = this.ui.stackedWidget.page_2.Tab.widget(0).YUnit.currentIndex();
	if (yUnitIdx == 0 || yUnitIdx == 1) { // dB
		vscaleArray = new Array(2.0, 5.0, 10.0, 15.0, 20.0);
	} else if (yUnitIdx == 2) { // VSWR
		vscaleArray = new Array(0.5, 1.0, 2.0, 5.0);
	}

	vscale = vscaleArray[vscaleEnum];
	
	if (yUnitIdx == 0 || yUnitIdx == 1) { // dB
		ul = Number(idx);
		ll = -(vscale * 8.0) + ul;
	} else if (yUnitIdx == 2) { // VSWR
		ll = 1.0;
		ul = (vscale * 8.0) + ll;
	}
	
	this.ui.PlotManager.YLeftUpperLimit = ul;
	this.ui.PlotManager.YLeftLowerLimit = ll;
	this.ui.PlotManager.YRightUpperlimit = ul;
	this.ui.PlotManager.YRightLowerLimit = ll;
	
}

Initialize.prototype.vertScaleChanged = function(idx)
{
	var ul = 0.0;
	var ll = 0.0;
	var vscale = 0.0;
	var vscaleArray = null;
	
	var yUnitIdx = this.ui.stackedWidget.page_2.Tab.widget(0).YUnit.currentIndex();
	if (yUnitIdx == 0 || yUnitIdx == 1) { // dBm/dB
		vscaleArray = new Array(2.0, 5.0, 10.0, 15.0, 20.0);
	} else if (yUnitIdx == 2) { // VSWR
		vscaleArray = new Array(0.5, 1.0, 2.0, 5.0);
	}

	vscale = vscaleArray[Number(idx)];

	if (yUnitIdx == 0 || yUnitIdx == 1) { // dB
		ul = Number(this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_RefLevel.currentIndex());
		ll = -(vscale * 8.0) + ul;
	} else if (yUnitIdx == 2) { // VSWR
		ll = 1.0;
		ul = (vscale * 8.0) + ll;
		this.ui.PlotManager.YLeftUpperLimit = ul;
		this.ui.PlotManager.YRightUpperlimit = ul;
	}
	
	this.ui.PlotManager.YLeftLowerLimit = ll;
	this.ui.PlotManager.YRightLowerLimit = ll;
}

Initialize.prototype.showEvent = function() 
{

	var engName = "VSWR";
	var instNum = "1";

    //var vswrEnable = this.system.getModule("AdapterList").scriptResolve(engName+":"+instNum, "State1");
    //vswrEnable.set(false);
    
    engName = "Analyzer";
    
    var analyzerEnable = this.system.getModule("AdapterList").scriptResolve(engName+":"+instNum, "State1");
    analyzerEnable.set(false);

	var screen = this.system.getSystemScreen("3550_VSWR");
	if (screen != null)
	{
		screen.hide();
	}
	
	screen = this.system.getSystemScreen("3550_Analyzer");
	if (screen != null)
	{
		screen.hide();
	}
	
	screen = this.system.getSystemScreen("3550_WideAnalyzer");
	if (screen != null)
	{
		screen.hide();
	}
	
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).QCPToggleButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(true);
	}
}

Initialize.prototype.hideEvent = function()
{
	//turn off
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).QCPToggleButton.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(false);
	}
}

Initialize.prototype.centerFreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Freq.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).Freq.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).Freq.Precision = 4;
			break;
	}
}

Initialize.prototype.startFreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).StartFreq.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).StartFreq.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).StartFreq.Precision = 3;
			break;
	}
}


Initialize.prototype.stopFreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).StopFreq.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).StopFreq.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).StopFreq.Precision = 3;
			break;
	}
}

Initialize.prototype.modeChanged = function(idx)
{
	if (Number(idx) == 1) // DTF
	{
			this.ui.stackedWidget.page_2.Tab.widget(0).Freq.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).Span.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Span.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).SetRef.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).RefStatus.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).StartFreq.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).StopFreq.hide();
			this.ui.stackedWidget.page_2.Tab.widget(1).DisplayPoints.hide();
			
			this.ui.stackedWidget.page_2.Tab.widget(0).Calibration.show();
			this.ui.stackedWidget.page_2.Tab.widget(0).CalibratedStatus.show();
			this.ui.stackedWidget.page_2.Tab.widget(0).XUnit.show();
			this.ui.stackedWidget.page_2.Tab.widget(0).Distance.show();
			
			//this.ui.stackedWidget.page_2.Tab.widget(2).Cable_2.show();
			//this.ui.stackedWidget.page_2.Tab.widget(2).Loss.show();
			//this.ui.stackedWidget.page_2.Tab.widget(2).Velocity.show();
			
//			this.updateXBounds();
			
			this.ui.stackedWidget.page_2.Tab.showTab(2);
	}
	else // 0 - TrackGen
	{
			this.ui.stackedWidget.page_2.Tab.widget(0).Calibration.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).CalibratedStatus.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).XUnit.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).Distance.hide();
			
			//this.ui.stackedWidget.page_2.Tab.widget(2).Cable_2.hide();
			//this.ui.stackedWidget.page_2.Tab.widget(2).Loss.hide();
			//this.ui.stackedWidget.page_2.Tab.widget(2).Velocity.hide();
			
			this.ui.stackedWidget.page_2.Tab.widget(0).Freq.show();
			//this.ui.stackedWidget.page_2.Tab.widget(0).Span.show();
			this.ui.stackedWidget.page_2.Tab.widget(0).Span.hide();
			this.ui.stackedWidget.page_2.Tab.widget(0).Numeric_Span.show();
			this.ui.stackedWidget.page_2.Tab.widget(0).SetRef.show();
			this.ui.stackedWidget.page_2.Tab.widget(0).RefStatus.show();
			this.ui.stackedWidget.page_2.Tab.widget(0).StartFreq.show();
			this.ui.stackedWidget.page_2.Tab.widget(0).StopFreq.show();
			this.ui.stackedWidget.page_2.Tab.widget(1).DisplayPoints.show();
			
			this.ui.stackedWidget.page_2.Tab.hideTab(2);
	}
}

Initialize.prototype.typeChanged = function(idx)
{
	if (Number(idx) == 0) 		
	{
		this.ui.stackedWidget.page_2.Tab.widget(0).YUnit.hide();
	}
	else
	{
		this.ui.stackedWidget.page_2.Tab.widget(0).YUnit.show();
	}
}

Initialize.prototype.yUnitChanged = function(idx)
{
	if (Number(idx) == 2)
	{
		this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_RefLevel.hide();
	}
	else // 1 - VSWR
	{
		this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_RefLevel.show();
	}
}

Initialize.prototype.showStoreBrowser = function()
{
	this.fileBrowser.WindowClosed.connect(this, this.hideStoreBrowserEvent);
	this.fileBrowser.fileSelected.connect(this, this.storeTrace);
	this.fileBrowser.setRootPath("/USER/traces_track_gen");
	this.fileBrowser.setButtonText("Store");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.showRecallBrowser = function()
{
	this.fileBrowser.WindowClosed.connect(this, this.hideRecallBrowserEvent);
	this.fileBrowser.fileSelected.connect(this, this.recallTrace);
	this.fileBrowser.setRootPath("/USER/traces_track_gen");
	this.fileBrowser.setButtonText("Recall");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.hideStoreBrowserEvent = function()
{
	this.fileBrowser.fileSelected.disconnect(this, this.storeTrace);
	this.fileBrowser.WindowClosed.disconnect(this, this.hideStoreBrowserEvent);
}

Initialize.prototype.hideRecallBrowserEvent = function()
{
	this.fileBrowser.fileSelected.disconnect(this, this.recallTrace);
	this.fileBrowser.WindowClosed.disconnect(this, this.hideRecallBrowserEvent);
}

Initialize.prototype.storeTrace = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(4).Text_File.getEventFilter();
	filter.submitWidgetValue(fileName);
	
	var filter = this.ui.stackedWidget.page_2.Tab.widget(4).Button_Save.getEventFilter();
	filter.submitWidgetVoid();
	this.fileBrowser.fileSelected.disconnect(this, this.storeTrace);
}

Initialize.prototype.recallTrace = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(4).Text_File.getEventFilter();
	filter.submitWidgetValue(fileName);
	
	var filter = this.ui.stackedWidget.page_2.Tab.widget(4).Button_Load.getEventFilter();
	filter.submitWidgetVoid();
	this.fileBrowser.fileSelected.disconnect(this, this.recallTrace);
}

Initialize.prototype.showStoreCableBrowser = function()
{
	this.fileBrowser.fileSelected.connect(this, this.cableSelected);
	this.fileBrowser.setRootPath("/USER/cable");
	this.fileBrowser.setButtonText("Store");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.showRecallCableBrowser = function()
{
	this.fileBrowser.fileSelected.connect(this, this.cableSelected);
	this.fileBrowser.setRootPath("/USER/cable");
	this.fileBrowser.setButtonText("Recall");
	this.fileBrowser.setWindowTitle("File Browser");
	this.fileBrowser.show();
}

Initialize.prototype.cableSelected = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(2).Text_Cable.getEventFilter();
	filter.submitWidgetValue(fileName);
	this.fileBrowser.fileSelected.disconnect(this, this.cableSelected);
}

Initialize.prototype.updateCableLabel = function()
{
	var strArr = this.ui.stackedWidget.page_2.Tab.widget(2).Text_Cable.text.split("/");
	var labelText = strArr[strArr.length-1];
	strArr = labelText.split(".");
	labelText = strArr[0];
	this.ui.stackedWidget.page_2.Tab.widget(2).CableLabel.text = labelText;
}