function Initialize(tile, engine, system)
{	
	tile.enableState("Thumb");
	tile.disableState("Max");
	tile.configureState("Thumb", "400|200");
    tile.configureState("Min", "400|400");
    tile.setDefaultState("Thumb");
 
	this.ui = tile.getContainerFrame();
    
    tile.changeSize.connect(this, this.resize);
   	this.resize("Thumb");
    
    this.ui.stackedWidget.page_Thumb.QCPComboBox_Group.currentIndexChanged.connect(this, this.changeGroup);
    this.ui.stackedWidget.page_Thumb.QCPComboBox_Mod.currentIndexChanged.connect(this, this.changeModulation);
 
 	//Gen1 and Gen2 dynamic precision
 	   
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_35['unitChanged(int)'].connect(this, this.Gen1FreqUnitChanged); 	    	   
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj['unitChanged(int)'].connect(this, this.Gen1FreqUnitChanged);    
    var idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj.unitIndex();
    this.Gen1FreqUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_Gen.GroupBox_4.QCPNumericValueObj_4['unitChanged(int)'].connect(this, this.Gen2FreqUnitChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_Gen.GroupBox_4.QCPNumericValueObj_4.unitIndex();
    this.Gen2FreqUnitChanged(idx);
    
    this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_36['unitChanged(int)'].connect(this, this.Gen1LevelUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj_2['unitChanged(int)'].connect(this, this.Gen1LevelUnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj_2.unitIndex();
    this.Gen1LevelUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_Gen.GroupBox_4.QCPNumericValueObj_3['unitChanged(int)'].connect(this, this.Gen2LevelUnitChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_Gen.GroupBox_4.QCPNumericValueObj_3.unitIndex();
    this.Gen2LevelUnitChanged(idx);
    
    //Mic Level dynamic precision
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(1).GroupBox_2.QCPNumericValueObj_11['unitChanged(int)'].connect(this, this.MicLevelUnitChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(1).GroupBox_2.QCPNumericValueObj_11.unitIndex();
    this.MicLevelUnitChanged(idx);
    
    //DTMF dynamic precision
    this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_30['unitChanged(int)'].connect(this, this.DtmfHiToneUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_8['unitChanged(int)'].connect(this, this.DtmfHiToneUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_8.unitIndex();
    this.DtmfHiToneUnitChanged(idx);

	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_31['unitChanged(int)'].connect(this, this.DtmfLoToneUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_7['unitChanged(int)'].connect(this, this.DtmfLoToneUnitChanged);    
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_7.unitIndex();
    this.DtmfLoToneUnitChanged(idx);
    
    //DCS dynamic precision
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DCS_Thumb.GroupBox_10.QCPNumericValueObj_34['unitChanged(int)'].connect(this, this.DcsLevelUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DCS.GroupBox_6.QCPNumericValueObj_9['unitChanged(int)'].connect(this, this.DcsLevelUnitChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DCS.GroupBox_6.QCPNumericValueObj_9.unitIndex();
    this.DcsLevelUnitChanged(idx);
    
    //2 Tone Dynamic Precision
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).Numeric_LevelFM['unitChanged(int)'].connect(this, this.TwoToneLevelUnitChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).Numeric_LevelFM.unitIndex();
    this.TwoToneLevelUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_10['unitChanged(int)'].connect(this, this.TwoToneFreqAUnitChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_10.unitIndex();
    this.TwoToneFreqAUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_13['unitChanged(int)'].connect(this, this.TwoToneFreqBUnitChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_13.unitIndex();
    this.TwoToneFreqBUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_12['unitChanged(int)'].connect(this, this.TwoToneDurationAUnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_12.unitIndex();
    this.TwoToneDurationAUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_14['unitChanged(int)'].connect(this, this.TwoToneDurationBUnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_14.unitIndex();
    this.TwoToneDurationBUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_22['unitChanged(int)'].connect(this, this.TwoToneSpaceUnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_22.unitIndex();
    this.TwoToneSpaceUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_15['unitChanged(int)'].connect(this, this.ToneRemoteFreq1UnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_15.unitIndex();
    this.ToneRemoteFreq1UnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_17['unitChanged(int)'].connect(this, this.ToneRemoteFreq2UnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_17.unitIndex();
    this.ToneRemoteFreq2UnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_19['unitChanged(int)'].connect(this, this.ToneRemoteFreq3UnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_19.unitIndex();
    this.ToneRemoteFreq3UnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_16['unitChanged(int)'].connect(this, this.ToneRemoteDuration1UnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_16.unitIndex();
    this.ToneRemoteDuration1UnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_18['unitChanged(int)'].connect(this, this.ToneRemoteDuration2UnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_18.unitIndex();
    this.ToneRemoteDuration2UnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_20['unitChanged(int)'].connect(this, this.ToneRemoteDuration3UnitChanged);
	idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_20.unitIndex();
    this.ToneRemoteDuration3UnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_Thumb.QCPComboBox_Group.currentIndex();
    this.changeGroup(idx);
    
    this.DtmfKeypad = system.getSystemScreen("DtmfKeypad");
    this.DtmfKeypad.holding.connect(this, this.DtmfHoldingStateChanged);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(0).QCPComboBox_2.currentIndexChanged.connect(this, this.DtmfStateChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(0).QCPComboBox_2.currentIndex();
    this.DtmfStateChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPFlagStatus.valueChanged.connect(this, this.TwoToneRunningStatusChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPFlagStatus_2.valueChanged.connect(this, this.ToneRemoteRunningStatusChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_ToneSeq.Tab_4.widget(0).QCPFlagStatus_3.valueChanged.connect(this, this.ToneSeqRunningStatusChanged);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPComboBox_7.currentIndexChanged.connect(this, this.dtmfModeChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPComboBox_7.currentIndex();
    this.dtmfModeChanged(idx);
    
    this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(0).DtmfLivePush.hide();
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPComboBox.currentIndexChanged.connect(this, this.patternChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPComboBox.currentIndex();
    this.patternChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPComboBox_11.currentIndexChanged.connect(this, this.patternChangeddPMR);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPComboBox_11.currentIndex();
    this.patternChangeddPMR(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPComboBox_11arc.currentIndexChanged.connect(this, this.patternChangedARC);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPComboBox_11arc.currentIndex();
    this.patternChangedARC(idx);
    
    this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_NXDN_Thumb.GroupBox_19.QCPComboBox_14.currentIndexChanged.connect(this, this.patternChangedNxdn2);
    idx = this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_NXDN_Thumb.GroupBox_19.QCPComboBox_14.currentIndex();
    this.patternChangedNxdn2(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPComboBox_13.currentIndexChanged.connect(this, this.patternChangedNxdn);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPComboBox_13.currentIndex();
    this.patternChangedNxdn(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(2).GroupBox_FGen.QCPNumericValueObj_FgenFreq['unitChanged(int)'].connect(this, this.FGenFreqUnitChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(2).GroupBox_FGen.QCPNumericValueObj_FgenFreq.unitIndex();
    this.FGenFreqUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(2).GroupBox_FGen.QCPComboBox_FGenUnit.currentIndexChanged.connect(this, this.FGenLevelUnitChanged);
    idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(2).GroupBox_FGen.QCPComboBox_FGenUnit.currentIndex();
    this.FGenLevelUnitChanged(idx);
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_16.currentIndexChanged.connect(this, this.dmrPatternChanged);
    this.dmrPatternChanged();
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mmode.currentIndexChanged.connect(this, this.dmrModeChanged);
    this.dmrModeChanged();
    
    this.ui.QCPNumeric_Configuration.hide();
    this.ui.QCPNumeric_Configuration['valueChanged(int)'].connect(this, this.ConfigurationChanged);
    idx = this.ui.QCPNumeric_Configuration.value();
    this.ConfigurationChanged(idx);
    
    this.ui.DmrRepeater.hide();
    this.ui.DmrRepeater.toggled.connect(this, this.dmrRepeaterToggled);
    this.dmrRepeaterToggled();
    
    //Hide the toggle button as it is only used to receive attribute changes.
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.QCPNumeric_TetraBSSync.hide();
    
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.QCPNumeric_TetraBSSync['valueChanged(int)'].connect(this, this.TetraBSSyncStateSet);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.QCPComboBox_SyncMode.currentIndexChanged.connect(this, this.TetraBSSyncModeSet);
    var syncmode = this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.QCPComboBox_SyncMode.currentIndex();
    this.TetraBSSyncModeSet(syncmode);
}

Initialize.prototype.resize = function(size)
{
    if (size == "Thumb") {
        this.ui.stackedWidget.setCurrentIndex(0);
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(1);
	}
}

Initialize.prototype.dtmfModeChanged = function(idx)
{
	switch (Number(idx))
	{
		case 0: //normal
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_30.show();
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_31.show();
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_32.hide();
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_33.hide();
		
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_7.show();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_8.show();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_23.hide();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_24.hide();
			break;
		case 1: //twist
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_32.show();
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_33.show();
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_30.hide();
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_31.hide();
		
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_23.show();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_24.show();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_7.hide();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_8.hide();
			break;
	}
}

Initialize.prototype.TwoToneRunningStatusChanged = function(running)
{
	if (running)
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_TwoTone_Thumb.ToneSeqGroupBox_3.QCPPushButton_7.LabelText = "Stop";
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPPushButton.LabelText = "Stop";
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_TwoTone_Thumb.ToneSeqGroupBox_3.QCPPushButton_7.LabelText = "Run";
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPPushButton.LabelText = "Run";
	}
}

Initialize.prototype.ToneRemoteRunningStatusChanged = function(running)
{
	if (running)
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ToneRemote_Thumb.ToneRemoteGroupBox_3.QCPPushButton_8.LabelText = "Stop";
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.Tab_2Tone.widget(0).QCPPushButton_2.LabelText = "Stop";
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ToneRemote_Thumb.ToneRemoteGroupBox_3.QCPPushButton_8.LabelText = "Run";
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.Tab_2Tone.widget(0).QCPPushButton_2.LabelText = "Run";
	}
}

Initialize.prototype.ToneSeqRunningStatusChanged = function(running)
{
	if (running)
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ToneSeq_Thumb.GroupBox_23.QCPPushButton_9.LabelText = "Stop";
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ToneSeq.Tab_4.widget(0).QCPPushButton_3.LabelText = "Stop";
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ToneSeq_Thumb.GroupBox_23.QCPPushButton_9.LabelText = "Run";
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ToneSeq.Tab_4.widget(0).QCPPushButton_3.LabelText = "Run";
	}
}

Initialize.prototype.changeGroup = function(idx)
{
	if (Number(idx) != 1) {
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.setCurrentIndex(0);
		this.ui.stackedWidget.page_Min.stackedWidget_3.setCurrentIndex(0);
	}
	
    switch (Number(idx)) {
    	case 0:
    		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.setCurrentIndex(0);
    		this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.setCurrentIndex(0);
    		this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.showTab(2);
            break;
        case 2:
        	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.setCurrentIndex(1);
            this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.setCurrentIndex(1);
            this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.hideTab(2);
            break;
        case 3:
        	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.setCurrentIndex(2);
            this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.setCurrentIndex(2);
            this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.showTab(2);
            break;
        case 4:
        	this.ui.stackedWidget.page_Thumb.stackedWidget_2.setCurrentIndex(9);
        	this.ui.stackedWidget.page_Min.stackedWidget_3.setCurrentIndex(9); // 2 Tone Seq
        	break;
    	case 5:
    		this.ui.stackedWidget.page_Thumb.stackedWidget_2.setCurrentIndex(10);
        	this.ui.stackedWidget.page_Min.stackedWidget_3.setCurrentIndex(10); // Tone Remote
        	break;
        case 6:
        	this.ui.stackedWidget.page_Thumb.stackedWidget_2.setCurrentIndex(11);
        	this.ui.stackedWidget.page_Min.stackedWidget_3.setCurrentIndex(11); // Tone Sequential
        	break;
    }
    
    var modIdx = this.ui.stackedWidget.page_Thumb.QCPComboBox_Mod.currentIndex();
    this.changeModulation(modIdx);
}

Initialize.prototype.changeModulation = function(idx)
{
	if (this.ui.stackedWidget.page_Thumb.QCPComboBox_Group.currentIndex() == 1) 
	{
		if (idx == 8) // ARC
		{
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.setCurrentIndex(12);
			this.ui.stackedWidget.page_Min.stackedWidget_3.setCurrentIndex(12);
		}
		else
		{
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.setCurrentIndex(idx+1);
			this.ui.stackedWidget.page_Min.stackedWidget_3.setCurrentIndex(idx+1);
		}
	}
	if (idx == 0 || idx == 1) //FM
	{	
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).Numeric_LevelFM.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).Numeric_LevelAM.hide();
		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.Numeric_LevelFM_2.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.Numeric_LevelAM_2.hide();
		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ToneSeq.Tab_4.widget(0).Numeric_LevelFM_3.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ToneSeq.Tab_4.widget(0).Numeric_LevelAM_3.hide();
	}
	else if (idx == 2) //AM
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).Numeric_LevelAM.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).Numeric_LevelFM.hide();
		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.Numeric_LevelAM_2.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.Numeric_LevelFM_2.hide();
		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ToneSeq.Tab_4.widget(0).Numeric_LevelAM_3.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ToneSeq.Tab_4.widget(0).Numeric_LevelFM_3.hide();
	}
	else if (idx == 9) //TETRA
	{
	    this.ui.stackedWidget.page_Thumb.QCPComboBox_Group.hide();
	    this.ui.stackedWidget.page_Min.QCPComboBox_Group_2.hide();
	    this.ui.stackedWidget.page_Thumb.stackedWidget_2.setCurrentIndex(13);
	    this.ui.stackedWidget.page_Min.stackedWidget_3.setCurrentIndex(13);
	}
}

Initialize.prototype.TwoToneLevelUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).Numeric_LevelFM.Precision = 2;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).Numeric_LevelFM.Precision = 0;
			break;
	}
}

Initialize.prototype.TwoToneFreqAUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_10.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_10.Precision = 1;
			break;
	}
}

Initialize.prototype.TwoToneFreqBUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_13.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_13.Precision = 1;
			break;
	}
}

Initialize.prototype.TwoToneDurationAUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_12.Precision = 3;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_12.Precision = 0;
			break;
	}
}

Initialize.prototype.TwoToneDurationBUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_14.Precision = 3;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_14.Precision = 0;
			break;
	}
}

Initialize.prototype.TwoToneSpaceUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_22.Precision = 3;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_two_tone.Tab_2Tone.widget(0).QCPNumericValueObj_22.Precision = 0;
			break;
	}
}

Initialize.prototype.Gen1FreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_35.Precision = 4;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_35.Precision = 1;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj.Precision = 1;
			break;
	}
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_35['unitChanged(int)'].disconnect(this, this.Gen1FreqUnitChanged); 	    	   
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj['unitChanged(int)'].disconnect(this, this.Gen1FreqUnitChanged);
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_35.setUnitIndex(idx);
	this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj.setUnitIndex(idx);
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_35['unitChanged(int)'].connect(this, this.Gen1FreqUnitChanged); 	    	   
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj['unitChanged(int)'].connect(this, this.Gen1FreqUnitChanged);
}

Initialize.prototype.Gen2FreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_Gen.GroupBox_4.QCPNumericValueObj_4.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_Gen.GroupBox_4.QCPNumericValueObj_4.Precision = 1;
			break;
	}
}

Initialize.prototype.Gen1LevelUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_36.Precision = 2;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj_2.Precision = 2;
			break;
		case 1:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_36.Precision = 0;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj_2.Precision = 0;
			break;
	}
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_36['unitChanged(int)'].disconnect(this, this.Gen1LevelUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj_2['unitChanged(int)'].disconnect(this, this.Gen1LevelUnitChanged);
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_36.setUnitIndex(idx);
	this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj_2.setUnitIndex(idx);
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_Gen_Thumb.GroupBox_8.QCPNumericValueObj_36['unitChanged(int)'].connect(this, this.Gen1LevelUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).GroupBox_3.QCPNumericValueObj_2['unitChanged(int)'].connect(this, this.Gen1LevelUnitChanged);
}

Initialize.prototype.Gen2LevelUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_Gen.GroupBox_4.QCPNumericValueObj_3.Precision = 2;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_Gen.GroupBox_4.QCPNumericValueObj_3.Precision = 0;
			break;
	}
}

Initialize.prototype.MicLevelUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(1).GroupBox_2.QCPNumericValueObj_11.Precision = 2;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(1).GroupBox_2.QCPNumericValueObj_11.Precision = 0;
			break;
	}
}


Initialize.prototype.DtmfHiToneUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_30.Precision = 2;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_8.Precision = 2;
			break;
		case 1:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_30.Precision = 0;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_8.Precision = 0;
			break;
	}

    this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_30['unitChanged(int)'].disconnect(this, this.DtmfHiToneUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_8['unitChanged(int)'].disconnect(this, this.DtmfHiToneUnitChanged);
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_30.setUnitIndex(idx);
	this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_8.setUnitIndex(idx);
	
    this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_30['unitChanged(int)'].connect(this, this.DtmfHiToneUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_8['unitChanged(int)'].connect(this, this.DtmfHiToneUnitChanged);
}

Initialize.prototype.DtmfLoToneUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_31.Precision = 2;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_7.Precision = 2;
			break;
		case 1:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_31.Precision = 0;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_7.Precision = 0;
			break;
	}

	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_31['unitChanged(int)'].disconnect(this, this.DtmfLoToneUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_7['unitChanged(int)'].disconnect(this, this.DtmfLoToneUnitChanged);
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_31.setUnitIndex(idx);
	this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_7.setUnitIndex(idx);
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(1).QCPNumericValueObj_31['unitChanged(int)'].connect(this, this.DtmfLoToneUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DTMF.Tab_2.widget(1).QCPNumericValueObj_7['unitChanged(int)'].connect(this, this.DtmfLoToneUnitChanged);
}

Initialize.prototype.DcsLevelUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DCS_Thumb.GroupBox_10.QCPNumericValueObj_34.Precision = 2;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DCS.GroupBox_6.QCPNumericValueObj_9.Precision = 2;
			break;
		case 1:
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DCS_Thumb.GroupBox_10.QCPNumericValueObj_34.Precision = 0;
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DCS.GroupBox_6.QCPNumericValueObj_9.Precision = 0;
			break;
	}

	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DCS_Thumb.GroupBox_10.QCPNumericValueObj_34['unitChanged(int)'].disconnect(this, this.DcsLevelUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DCS.GroupBox_6.QCPNumericValueObj_9['unitChanged(int)'].disconnect(this, this.DcsLevelUnitChanged);
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DCS_Thumb.GroupBox_10.QCPNumericValueObj_34.setUnitIndex(idx);
	this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DCS.GroupBox_6.QCPNumericValueObj_9.setUnitIndex(idx);
	
	this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DCS_Thumb.GroupBox_10.QCPNumericValueObj_34['unitChanged(int)'].connect(this, this.DcsLevelUnitChanged);
    this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(0).stackedWidget_4.page_DCS.GroupBox_6.QCPNumericValueObj_9['unitChanged(int)'].connect(this, this.DcsLevelUnitChanged);
}

Initialize.prototype.ToneRemoteFreq1UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_15.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_15.Precision = 1;
			break;
	}
}

Initialize.prototype.ToneRemoteFreq2UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_17.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_17.Precision = 1;
			break;
	}
}

Initialize.prototype.ToneRemoteFreq3UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_19.Precision = 4;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_19.Precision = 1;
			break;
	}
}

Initialize.prototype.ToneRemoteDuration1UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_16.Precision = 3;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_16.Precision = 0;
			break;
	}
}

Initialize.prototype.ToneRemoteDuration2UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_18.Precision = 3;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_18.Precision = 0;
			break;
	}
}

Initialize.prototype.ToneRemoteDuration3UnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_20.Precision = 3;
			break;
		case 1:
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_tone_remote.ToneRemoteGroupBox.QCPNumericValueObj_20.Precision = 0;
			break;
	}
}

Initialize.prototype.DtmfStateChanged = function(idx)
{	
	if (Number(idx) == 3) //Live
	{
		this.DtmfKeypad.IsLive = true;
	}
	else //not live
	{
		this.DtmfKeypad.IsLive = false;
	}
}

Initialize.prototype.DtmfHoldingStateChanged = function(state)
{
	var filter = this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_Analog_Thumb.stackedWidget_5.page_DTMF_Thumb.Tab_3.widget(0).DtmfLivePush.getEventFilter();
	filter.submit(state);
}

Initialize.prototype.patternChanged = function(idx)
{
	if (idx == 2) //O.153
	{		
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_P25_Thumb.GroupBox_9.QCPNumeric_8.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25TGID.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25UnitId.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25Priority.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPToggleButton_P25Emergency.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.P25ResetButton.hide();
	}
	else
	{		
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_P25_Thumb.GroupBox_9.QCPNumeric_8.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25TGID.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25UnitId.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25Priority.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPToggleButton_P25Emergency.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.P25ResetButton.show();
	}
}

Initialize.prototype.patternChangeddPMR = function(idx)
{
	if (idx == 0) //O.153
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_dPMR_Thumb.GroupBox_18.QCPNumeric_15.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_dPMR_Thumb.GroupBox_18.QCPNumeric_18.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_dPMR_Thumb.GroupBox_18.QCPToggleButton_6.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPNumeric_19.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPNumeric_22.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPToggleButton_7.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPTextEntry_2.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPTextEntry_3.hide();		
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_dPMR_Thumb.GroupBox_18.QCPNumeric_15.show();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_dPMR_Thumb.GroupBox_18.QCPNumeric_18.show();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_dPMR_Thumb.GroupBox_18.QCPToggleButton_6.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPNumeric_19.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPNumeric_22.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPToggleButton_7.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPTextEntry_2.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_dPMR.GroupBox_14.QCPTextEntry_3.show();	
	}
}

Initialize.prototype.patternChangedARC = function(idx)
{
	if (idx == 0) //O.153
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ARC_Thumb.GroupBox_18arc.QCPNumeric_15arc.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ARC_Thumb.GroupBox_18arc.QCPNumeric_18arc.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ARC_Thumb.GroupBox_18arc.QCPToggleButton_6arc.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPNumeric_19arc.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPNumeric_22arc.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPToggleButton_7arc.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPNumeric_19arc2.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPNumeric_19arc3.hide();		
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ARC_Thumb.GroupBox_18arc.QCPNumeric_15arc.show();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ARC_Thumb.GroupBox_18arc.QCPNumeric_18arc.show();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_ARC_Thumb.GroupBox_18arc.QCPToggleButton_6arc.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPNumeric_19arc.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPNumeric_22arc.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPToggleButton_7arc.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPNumeric_19arc2.show();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_ARC.GroupBox_14arc.QCPNumeric_19arc3.show();	
	}
}

Initialize.prototype.patternChangedNxdn2 = function(idx)
{
	if (idx == 2 || idx == 3) //O.153 or FSW+PN9
	{		
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_NXDN_Thumb.GroupBox_19.QCPNumeric_9.hide(); //ran		
	}
	else if(idx == 1) //cal
	{		
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_NXDN_Thumb.GroupBox_19.QCPNumeric_9.show(); //ran
	}
	else
	{		
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_NXDN_Thumb.GroupBox_19.QCPNumeric_9.show(); //ran
	}
}

Initialize.prototype.patternChangedNxdn = function(idx)
{
	if (idx == 2 || idx == 3) //O.153 or FSW+PN9
	{		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPNumeric_5.hide(); //ran
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPNumeric_NXDNTGID.hide(); 
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPNumeric_NXDNUnitId.hide(); 
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPToggleButton_NXDNPriority.hide(); 
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPToggleButton_NXDNEmergency.hide(); 
	}
	else if(idx == 1) //cal
	{		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPNumeric_5.show(); //ran
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPNumeric_NXDNTGID.hide(); 
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPNumeric_NXDNUnitId.hide(); 
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPToggleButton_NXDNPriority.hide(); 
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPToggleButton_NXDNEmergency.hide(); 
	}
	else
	{		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPNumeric_5.show(); //ran
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPNumeric_NXDNTGID.show(); 
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPNumeric_NXDNUnitId.show(); 
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPToggleButton_NXDNPriority.show(); 
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_NXDN.GroupBox_15.QCPToggleButton_NXDNEmergency.show(); 
	}
}

Initialize.prototype.FGenFreqUnitChanged = function(idx)
{
	if (idx == 0) //kHz
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(2).GroupBox_FGen.QCPNumericValueObj_FgenFreq.Precision = 3;	
	}
	else //Hz
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(2).GroupBox_FGen.QCPNumericValueObj_FgenFreq.Precision = 0;
	}
}

Initialize.prototype.FGenLevelUnitChanged = function(idx)
{
	if (idx == 0) //V
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(2).GroupBox_FGen.QCPNumeric_fgen.Precision = 3;
	}
	else if (idx == 1) //mV
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(2).GroupBox_FGen.QCPNumeric_fgen.Precision = 0;
	}
	else //dB
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_Analog.Tab.widget(2).GroupBox_FGen.QCPNumeric_fgen.Precision = 2;
	}
}

Initialize.prototype.dmrPatternChanged = function()
{
	var idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_16.currentIndex();
	if (idx == 1 || idx == 2)
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_2.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_3.hide();
		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.PushButton.hide(); //all call
		
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPNumeric_10.hide();
		//this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPNumeric_11.hide();
		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_DmrPriority.hide();		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPToggleButton_DmrEmergency.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_DmrUnitId.hide();		
		
		//hide mode, hide slot
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mmode.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tmode.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mslot.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tslot.hide();		
	}
	else
	{
		if (idx == 3)
		{
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_3.hide();
			
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.PushButton.hide(); //all call
			
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_DmrPriority.hide();		
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPToggleButton_DmrEmergency.hide();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_DmrUnitId.hide();
			
			//hide mode and slot
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mmode.hide();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mslot.hide();
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tmode.hide();
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tslot.hide();
		}
		else
		{
			//show mode, check slot
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mmode.show();
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tmode.show();
			this.dmrModeChanged();		
		
			//this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_2.show();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_3.show();
			
			this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPNumeric_10.show();
			//this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPNumeric_11.show();
			
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_DmrPriority.show();		
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPToggleButton_DmrEmergency.show();
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_DmrUnitId.show();
			
			this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.PushButton.show(); //all call
		}
		
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPNumeric_2.show(); //color
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPNumeric_10.show(); //color on thumbsize
	}
	
	idx = this.ui.QCPNumeric_Configuration.value();
	if(idx == 0) //lmr
	{
		//these are for dmr repeater testing that is only supported in adv digital
    	this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mmode.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tmode.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mslot.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tslot.hide();	
	}
}

Initialize.prototype.ConfigurationChanged = function(idx)
{
	if (idx == 0) // LMR
	{
    	//this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25TGID.show();
    	//this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25UnitId.show();
    	//this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25Priority.show();
    	//this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPToggleButton_P25Emergency.show();    	
	}
	else if(idx == 1)// PTC
	{
    	this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25TGID.hide();
    	this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25UnitId.hide();
    	this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25Priority.hide();
    	this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPToggleButton_P25Emergency.hide();
	}
	else //P25 Phase 2 
	{
	    //this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25TGID.show();
    	//this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25UnitId.show();
    	//this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPNumeric_P25Priority.show();
    	//this.ui.stackedWidget.page_Min.stackedWidget_3.page_P25.GroupBox_5.QCPToggleButton_P25Emergency.show();
	}
	
}

Initialize.prototype.dmrModeChanged = function()
{
	var idx = this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mmode.currentIndex();
	if (idx == 0)
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mslot.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tslot.hide();
	}
	else
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mslot.show();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tslot.show();
	}	
}

Initialize.prototype.dmrRepeaterToggled = function()
{
	var state = this.ui.DmrRepeater.State;
	if (state)
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mmode.show();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tmode.show();
		this.dmrModeChanged();
	}
	else
	{
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mmode.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tmode.hide();
		this.ui.stackedWidget.page_Min.stackedWidget_3.page_DMR.GroupBox_16.QCPComboBox_mslot.hide();
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_DMR_Thumb.GroupBox_20.QCPComboBox_tslot.hide();
	}
}

Initialize.prototype.TetraBSSyncModeSet = function(idx)
{
	var syncstate = this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.QCPNumeric_TetraBSSync.value();
	
	if (idx == 0 || syncstate == 1) //Free Run or SYNC Active
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_TETRA_Thumb.GroupBox_7.TetraBS_Sync_Off.text = " \n ";
	    this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.TetraBS_Sync_Off.text = " \n ";
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_TETRA_Thumb.GroupBox_7.TetraBS_Sync_Off.text = "MOD OFF\nNO SYNC";
	    this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.TetraBS_Sync_Off.text = "MOD OFF\nNO SYNC";
	}	
}

Initialize.prototype.TetraBSSyncStateSet = function(idx)
{
	var syncmode = this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.QCPComboBox_SyncMode.currentIndex();
	
	if (syncmode == 0 || idx == 1) //Free Run or SYNC Active
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_TETRA_Thumb.GroupBox_7.TetraBS_Sync_Off.text = " \n ";
	    this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.TetraBS_Sync_Off.text = " \n ";
	}
	else
	{
		this.ui.stackedWidget.page_Thumb.stackedWidget_2.page_TETRA_Thumb.GroupBox_7.TetraBS_Sync_Off.text = "MOD OFF\nNO SYNC";
	    this.ui.stackedWidget.page_Min.stackedWidget_3.page_TETRA.GroupBox_TETRA1.TetraBS_Sync_Off.text = "MOD OFF\nNO SYNC";
	}	
}
