function Initialize(tile, engine, system)
{
	tile.enableState("Thumb");
    tile.configureState("Thumb", "200|200");
    tile.configureState("Min", "200|400");
    tile.setDefaultState("Thumb");
    tile.showSendToBackButton(false);
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    
    this.defaultUnitIndex = 0;
    
    this.ui.widget.Combo_Type.currentIndexChanged.connect(this, this.unitChanged);
    var idx = this.ui.widget.Combo_Type.currentIndex();
    this.unitChanged(idx);
    
    this.readingBaseUnit = this.ui.widget.QCPNumericMeterReading.BaseUnit;
    this.ui.widget.QCPNumericMeterReading['unitChanged(int)'].connect(this, this.checkReadingBaseUnit);
    this.checkReadingBaseUnit(-1);
    
    this.peakBaseUnit = this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.BaseUnit;
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj['unitChanged(int)'].connect(this, this.checkPeakBaseUnit);
    this.checkPeakBaseUnit(-1);
    
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_2.hide(); //deprecated Units field - still used by engine for callback
    this.ui.widget.Combo_Type.raise();
    
    this.ui.stackedWidget.page_2.Tab.widget(0).ZeroButton.hide();
    
    tile.WindowOpened.connect(this, this.showEvent);
	tile.WindowClosed.connect(this, this.hideEvent);
	
	this.showEvent();
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
        this.ui.stackedWidget.show();
        this.ui.widget.Combo_Type.hide();
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
    	this.ui.stackedWidget.hide();
    	this.ui.widget.Combo_Type.show();
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(0);
    	this.ui.stackedWidget.hide();
    	this.ui.widget.Combo_Type.show();	
    }   	
}

Initialize.prototype.checkReadingBaseUnit = function(idx)
{
	if (idx == -1 || this.ui.widget.QCPNumericMeterReading.BaseUnit != this.readingBaseUnit) //the base unit has changed!
	{
		this.readingBaseUnit = this.ui.widget.QCPNumericMeterReading.BaseUnit; //store new base unit
		this.ui.widget.QCPNumericMeterReading.UnitIndex = this.defaultUnitIndex;
	}
}

Initialize.prototype.checkPeakBaseUnit = function(idx)
{
	if (idx == -1 || this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.BaseUnit != this.peakBaseUnit) //the base unit has changed!
	{
		this.peakBaseUnit = this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.BaseUnit; //store new base unit
		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.UnitIndex = this.defaultUnitIndex;
	}
}

Initialize.prototype.unitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:	//volts
		case 1:	//volts
			this.defaultUnitIndex = 1;
			break;
		case 2:	//amps
		case 3:	//amps
			this.defaultUnitIndex = 3;
			break;
		case 4:	//ohms
			this.defaultUnitIndex = 7;
			break;
	}
}

Initialize.prototype.showEvent = function()
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).Button_Enable.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(true);
	}
}

Initialize.prototype.hideEvent = function()
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).Button_Enable.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(false);
	}
}