function Initialize(tile, engine, system)
{
	tile.enableState("Thumb");
    tile.configureState("Thumb", "200|200");
    tile.configureState("Min", "200|400");
    tile.setDefaultState("Thumb");
    tile.showSendToBackButton(false);
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    this.ui.stackedWidget.hide();
    
    this.ui.widget.QCPNumericMeterReading['unitChanged(int)'].connect(this, this.ReadingUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4['unitChanged(int)'].connect(this, this.UpperUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3['unitChanged(int)'].connect(this, this.LowerUnitChanged);
    
    var idx = this.ui.widget.QCPNumericMeterReading.unitIndex();
    this.ReadingUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.unitIndex();
    this.UpperUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.unitIndex();
    this.LowerUnitChanged(idx);
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
        this.ui.stackedWidget.show();
        this.ui.widget.QCPComboBox_3.hide();
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
    	this.ui.stackedWidget.hide();
    	this.ui.widget.QCPComboBox_3.show();
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(0);
    	this.ui.stackedWidget.hide();
    	this.ui.widget.QCPComboBox_3.show();	
    }   	
}

Initialize.prototype.UpperUnitChanged = function(idx)
{
	var unitIdx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_2.currentIndex();
	if (unitIdx == 0)
	{
		switch(Number(idx))
		{
			case 0:
	    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.Precision = 3;
				break;
			case 1:
	    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.Precision = 0;
				break;
		}
	}
	else
	{
		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_4.Precision = 2;
	}
}

Initialize.prototype.LowerUnitChanged = function(idx)
{
	var unitIdx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_2.currentIndex();
	if (unitIdx == 0)
	{
		switch(Number(idx))
		{
			case 0:
	    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.Precision = 3;
				break;
			case 1:
	    		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.Precision = 0;
				break;
		}
	}
	else
	{
		this.ui.stackedWidget.page_2.Tab.widget(1).QCPNumericValueObj_3.Precision = 2;
	}
}

Initialize.prototype.ReadingUnitChanged = function(idx)
{
	var unitIdx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPComboBox_2.currentIndex();
	if (unitIdx == 0)
	{
		switch(Number(idx))
		{
			case 0:
	    		this.ui.widget.QCPNumericMeterReading.Precision = 3;
				break;
			case 1:
	    		this.ui.widget.QCPNumericMeterReading.Precision = 0;
				break;
		}
	}
	else
	{
		this.ui.widget.QCPNumericMeterReading.Precision = 2;
	}
}
