function Initialize(tile, engine, system)
{
	tile.disableState("Max");
	this.ui = tile.getContainerFrame();
	
	this.ui.QCPNumericMeterReading_5['unitChanged(int)'].connect(this, this.RfErrorUnitChanged);
	var idx = this.ui.QCPNumericMeterReading_5.unitIndex();
    this.RfErrorUnitChanged(idx);
    
    this.ui.QCPNumericMeterReading_3['unitChanged(int)'].connect(this, this.ModUnitChanged);
	idx = this.ui.QCPNumericMeterReading_3.unitIndex();
    this.ModUnitChanged(idx);
    
    this.ui.QCPNumericMeterReading_6['unitChanged(int)'].connect(this, this.AfCounterUnitChanged);
	idx = this.ui.QCPNumericMeterReading_6.unitIndex();
    this.AfCounterUnitChanged(idx);
 	this.ui.MeasType.hide();
    this.ui.MeasType.currentIndexChanged.connect(this, this.updateRfPowLabel);
    this.updateRfPowLabel();
    
    this.ui.Combo_RfPowUnits.currentIndexChanged.connect(this, this.rfPowUnitChanged);
    this.rfPowUnitChanged();
    
    this.ui.Combo_RssiUnits.currentIndexChanged.connect(this, this.rssiUnitChanged);
    this.rssiUnitChanged();
    
    this.ui.Combo_DemodLevelUnits.currentIndexChanged.connect(this, this.ModUnitChanged);
    idx = this.ui.QCPNumericMeterReading_3.unitIndex();
    this.ModUnitChanged(idx);
}

Initialize.prototype.RfErrorUnitChanged = function(idx)
{
	var unitIdx = this.ui.QCPComboBox.currentIndex();
	if (unitIdx == 0)
	{
		switch(Number(idx))
		{
			case 0:
	    		this.ui.QCPNumericMeterReading_5.Precision = 3;
				break;
			case 1:
	    		this.ui.QCPNumericMeterReading_5.Precision = 0;
				break;
		}
	}
	else
	{
		this.ui.QCPNumericMeterReading_5.Precision = 2;
	}
}

Initialize.prototype.ModUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0: //dB
    		this.ui.QCPNumericMeterReading_3.Precision = 2;
			break;
		case 1: //kHz
    		this.ui.QCPNumericMeterReading_3.Precision = 3;
			break;
		case 2: //Hz
    		this.ui.QCPNumericMeterReading_3.Precision = 0;
			break;
		case 3: //%
    		this.ui.QCPNumericMeterReading_3.Precision = 1;
			break;
	}
}

Initialize.prototype.AfCounterUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.QCPNumericMeterReading_6.Precision = 3;
			break;
		case 1:
    		this.ui.QCPNumericMeterReading_6.Precision = 1;
			break;
	}
}

Initialize.prototype.updateRfPowLabel = function()
{
	var idx = this.ui.MeasType.currentIndex();
	switch(Number(idx))
	{
		case 0: //avg
			this.ui.Reading_RfPower.LabelText = "RF Power Avg";
			break;
		case 1: //min
			this.ui.Reading_RfPower.LabelText = "RF Power Min";
			break;
		case 2: //max
			this.ui.Reading_RfPower.LabelText = "RF Power Max";
			break;
	}
}

Initialize.prototype.rfPowUnitChanged = function()
{
	var idx = this.ui.Combo_RfPowUnits.currentIndex();
	if (idx == 0)
	{
		this.ui.Reading_RfPower.Precision = 1;
	}
	else
	{
		this.ui.Reading_RfPower.Precision = 2;
	}
}

Initialize.prototype.rssiUnitChanged = function()
{
	var idx = this.ui.Combo_RssiUnits.currentIndex();
	if (Number(idx) >= 0 && Number(idx) <= 2)
	{
		this.ui.QCPNumericMeterReading_9.Precision = 1;
		this.ui.QCPNumericMeterReading_9.Units = "";
	}
	else if (Number(idx) == 4)
	{
		this.ui.QCPNumericMeterReading_9.Precision = 2;
		this.ui.QCPNumericMeterReading_9.Units = "";
	}
	else
	{
		this.ui.QCPNumericMeterReading_9.Precision = 2;
		this.ui.QCPNumericMeterReading_9.Units = "0,0,13:1;;;;|0,-3,13:1;;;;|0,-6,13:1;;;;";
	}
}