function Initialize(tile, engine, system)
{
	tile.disableState("Max");
	this.ui = tile.getContainerFrame();
	
	//RfError dynamic precision
	this.ui.Tab.widget(1).QCPNumericValueObj_4['unitChanged(int)'].connect(this, this.RfErrorUpperUnitChanged);
	this.ui.Tab.widget(1).QCPNumericValueObj_3['unitChanged(int)'].connect(this, this.RfErrorLowerUnitChanged);
	
	var idx = this.ui.Tab.widget(1).QCPNumericValueObj_4.unitIndex();
    this.RfErrorUpperUnitChanged(idx);
    
    idx = this.ui.Tab.widget(1).QCPNumericValueObj_3.unitIndex();
    this.RfErrorLowerUnitChanged(idx);
    
    //Modulation dynamic precision
    this.ui.Tab.widget(2).QCPNumericValueObj_6['unitChanged(int)'].connect(this, this.ModUpperUnitChanged);
	this.ui.Tab.widget(2).QCPNumericValueObj_5['unitChanged(int)'].connect(this, this.ModLowerUnitChanged);
	
	idx = this.ui.Tab.widget(2).QCPNumericValueObj_6.unitIndex();
    this.ModUpperUnitChanged(idx);
    
    idx = this.ui.Tab.widget(2).QCPNumericValueObj_5.unitIndex();
    this.ModLowerUnitChanged(idx);
    
    //AF Counter dynamic precision
    this.ui.Tab.widget(3).QCPNumericValueObj_8['unitChanged(int)'].connect(this, this.AfCounterUpperUnitChanged);
	this.ui.Tab.widget(3).QCPNumericValueObj_7['unitChanged(int)'].connect(this, this.AfCounterLowerUnitChanged);
	
	idx = this.ui.Tab.widget(3).QCPNumericValueObj_8.unitIndex();
    this.AfCounterUpperUnitChanged(idx);
    
    idx = this.ui.Tab.widget(3).QCPNumericValueObj_7.unitIndex();
    this.AfCounterLowerUnitChanged(idx);
    
    this.ui.Tab.widget(0).RssiUnits.currentIndexChanged.connect(this, this.rssiUnitChanged);
    idx = this.ui.Tab.widget(0).RssiUnits.currentIndex();
    this.rssiUnitChanged(idx);
    
    this.ui.Tab.widget(0).RssiUnits.hide();
}

Initialize.prototype.RfErrorUpperUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.Tab.widget(1).QCPNumericValueObj_4.Precision = 3;
			break;
		case 1:
    		this.ui.Tab.widget(1).QCPNumericValueObj_4.Precision = 0;
			break;
		case 2:
    		this.ui.Tab.widget(1).QCPNumericValueObj_4.Precision = 2;
			break;
	}
}

Initialize.prototype.RfErrorLowerUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.Tab.widget(1).QCPNumericValueObj_3.Precision = 3;
			break;
		case 1:
    		this.ui.Tab.widget(1).QCPNumericValueObj_3.Precision = 0;
			break;
		case 2:
    		this.ui.Tab.widget(1).QCPNumericValueObj_3.Precision = 2;
			break;
	}
}

Initialize.prototype.ModUpperUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0: //dB
    		this.ui.Tab.widget(2).QCPNumericValueObj_6.Precision = 2;
			break;
		case 1: //kHz
    		this.ui.Tab.widget(2).QCPNumericValueObj_6.Precision = 3;
			break;
		case 2: //Hz
    		this.ui.Tab.widget(2).QCPNumericValueObj_6.Precision = 0;
			break;
		case 3: //%
    		this.ui.Tab.widget(2).QCPNumericValueObj_6.Precision = 1;
			break;
	}
}

Initialize.prototype.ModLowerUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0: //dB
    		this.ui.Tab.widget(2).QCPNumericValueObj_5.Precision = 2;
			break;
		case 1: //kHz
    		this.ui.Tab.widget(2).QCPNumericValueObj_5.Precision = 3;
			break;
		case 2: //Hz
    		this.ui.Tab.widget(2).QCPNumericValueObj_5.Precision = 0;
			break;
		case 3: //%
    		this.ui.Tab.widget(2).QCPNumericValueObj_5.Precision = 1;
			break;
	}
}

Initialize.prototype.AfCounterUpperUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.Tab.widget(3).QCPNumericValueObj_8.Precision = 3;
			break;
		case 1:
    		this.ui.Tab.widget(3).QCPNumericValueObj_8.Precision = 0;
			break;
	}
}

Initialize.prototype.AfCounterLowerUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.Tab.widget(3).QCPNumericValueObj_7.Precision = 3;
			break;
		case 1:
    		this.ui.Tab.widget(3).QCPNumericValueObj_7.Precision = 0;
			break;
	}
}

Initialize.prototype.rssiUnitChanged = function(idx)
{
	if (Number(idx) != 3) {
		switch(Number(idx))
		{
			case 0:
			case 1:
			case 4:
				print("");
				this.ui.Tab.widget(0).QCPNumericValueObj.setUnitIndex(idx);
				this.ui.Tab.widget(0).QCPNumericValueObj_2.setUnitIndex(idx);
				break;
			case 2:
				print("");
				this.ui.Tab.widget(0).QCPNumericValueObj.setUnitIndex(3);
				this.ui.Tab.widget(0).QCPNumericValueObj_2.setUnitIndex(3);
				break;
		}
	}
}