function Initialize(tile, engine, system)
{
    tile.enableState("Thumb");
    tile.configureState("Thumb", "200|200");
    tile.configureState("Min", "200|400");
    tile.setDefaultState("Thumb");
    tile.showSendToBackButton(false);
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_5['unitChanged(int)'].connect(this, this.NotchFreqChanged);
    var idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_5.unitIndex();
    this.NotchFreqChanged(idx);
    
    this.ui.NotchOptionEnabled.toggled.connect(this, this.notchOptionToggled);
    this.ui.NotchOptionEnabled.hide();
    this.notchOptionToggled();
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
    } else if (size == "Min") {
    	this.ui.stackedWidget.setCurrentIndex(0);
    } else if (size == "Thumb") {
    	this.ui.stackedWidget.setCurrentIndex(0);
    }   	
}

Initialize.prototype.NotchFreqChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_5.Precision = 3;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_5.Precision = 0;
			break;
	}
}

Initialize.prototype.notchOptionToggled = function()
{
	var state = this.ui.NotchOptionEnabled.State;
	if (state)
	{
		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_5.show();
	}
	else
	{
		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_5.hide();
	}
}