function Initialize(tile, engine, system)
{
    this.ui = tile.getContainerFrame();
    tile.changeSize.connect(this, this.resize);
    this.system = system;
    
	this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_VertScale.currentIndexChanged.connect(this, this.vertScaleChanged);
	this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_RefLevel.currentIndexChanged.connect(this, this.tosIdxChanged);
	
	var idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_VertScale.currentIndex();
	this.vertScaleChanged(idx);
	
	idx = this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_RefLevel.currentIndex();
	this.tosIdxChanged(idx);
	
	tile.WindowOpened.connect(this, this.showEvent);
	tile.WindowClosed.connect(this, this.hideEvent);
	
	try 
    { 
        this.ui.stackedWidget.page_2.Tab.widget(2).PlotMarker.attachPlot(this.ui.PlotManager);
    } 
    catch(e) 
    { 
        print("Failed to attach: "+e); 
    }
    
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_2['unitChanged(int)'].connect(this, this.centerFreqUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj['unitChanged(int)'].connect(this, this.startFreqUnitChanged);
    this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_3['unitChanged(int)'].connect(this, this.stopFreqUnitChanged);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_2.unitIndex();
    this.centerFreqUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.unitIndex();
    this.startFreqUnitChanged(idx);
    
    idx = this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_3.unitIndex();
    this.stopFreqUnitChanged(idx);
    
    this.fileBrowser = this.system.getSystemScreen("FileBrowser3550");
    this.ui.stackedWidget.page_2.Tab.widget(3).Button_Browse.clicked.connect(this, this.showFileBrowser);
}

Initialize.prototype.resize = function(size)
{
    if (size == "Max") {
        this.ui.stackedWidget.setCurrentIndex(1);
    } else if (size == "Min") {
        this.ui.stackedWidget.setCurrentIndex(0);
    }
}

Initialize.prototype.tosIdxChanged = function(idx)
{
	var ul = 0.0;
	var ll = 0.0;
	var vscaleEnum = 0.0;
	var vscale = 0.0;

	vscaleEnum = this.ui.stackedWidget.page_2.Tab.widget(1).QCPComboBox_VertScale.currentIndex();
	
	ul = Number(idx);
	
	switch (Number(vscaleEnum)) {
		case 0:
			vscale = 2.0;
			break;
		case 1:
			vscale = 5.0;
			break;
		case 2:
			vscale = 10.0;
			break;
		case 3:
			vscale = 15.0;
			break;
		case 4:
			vscale = 20.0;
			break;
	}
	
	ll = -(vscale * 8.0) + ul;
	
	this.ui.PlotManager.setYLeftScaleULimit(ul);
	this.ui.PlotManager.setYLeftScaleLLimit(ll);
	this.ui.PlotManager.YRightUpperLimit = ul;
	this.ui.PlotManager.YRightLowerLimit = ll;
	
}

Initialize.prototype.vertScaleChanged = function(idx)
{
	var ul = 0.0;
	var ll = 0.0;
	var vscale = 0.0;
	
	switch (Number(idx)) {
		case 0:
			vscale = 2.0;
			break;
		case 1:
			vscale = 5.0;
			break;
		case 2:
			vscale = 10.0;
			break;
		case 3:
			vscale = 15.0;
			break;
		case 4:
			vscale = 20.0;
			break;
	}

	ul = this.ui.PlotManager.getYLeftScaleULimit();
	var ll = -(vscale * 8.0) + ul;
	
	this.ui.PlotManager.setYLeftScaleLLimit(ll);
	this.ui.PlotManager.YRightLowerLimit = ll;
}

Initialize.prototype.showEvent = function() 
{
	var screen = this.system.getSystemScreen("3550_VSWR");
	if (screen != null)
	{
		screen.hide();
	}
	
	screen = this.system.getSystemScreen("3550_Tracking_Gen");
	if (screen != null)
	{
		screen.hide();
	}
	
	screen = this.system.getSystemScreen("3550_Analyzer");
	if (screen != null)
	{
		screen.hide();
	}
 
    var filter = this.ui.stackedWidget.page_2.Tab.widget(0).Toggle_Enable.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(true);
	}
}

Initialize.prototype.hideEvent = function()
{
	//turn off
	var filter = this.ui.stackedWidget.page_2.Tab.widget(0).Toggle_Enable.getEventFilter();
	if (filter != null) {
		filter.submitWidgetValue(false);
	}
}

Initialize.prototype.centerFreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_2.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_2.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_2.Precision = 3;
			break;
	}
}

Initialize.prototype.startFreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj.Precision = 3;
			break;
	}
}


Initialize.prototype.stopFreqUnitChanged = function(idx)
{
	switch(Number(idx))
	{
		case 0:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_3.Precision = 6;
			break;
		case 1:
    		this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_3.Precision = 6;
			break;
		case 2:
			this.ui.stackedWidget.page_2.Tab.widget(0).QCPNumericValueObj_3.Precision = 3;
			break;
	}
}

Initialize.prototype.showFileBrowser = function()
{
	this.fileBrowser.fileSelected.connect(this, this.fileSelected);
	this.fileBrowser.setRootPath("/USER/traces_wide_analyzer");
	this.fileBrowser.setButtonText("Select");
	this.fileBrowser.show();
}

Initialize.prototype.fileSelected = function(fileName)
{
	var filter = this.ui.stackedWidget.page_2.Tab.widget(3).Text_File.getEventFilter();
	filter.submitWidgetValue(fileName);
	this.fileBrowser.fileSelected.disconnect(this, this.fileSelected);
}