//var globalUi = 0; //THIS CODE IS SOMETIMES USEFUL TO DEBUG USING SCRIPT DEBUG CONSOLE

function Initialize(tile, engine, system)
{
    this.tile = tile;
    this.ui = tile.getContainerFrame();
    this.system = system;
    this.engine = engine;

    this.ui.QCPTableEnum.ReadOnly = true;
    this.tile.WindowOpened.connect(this, this.windowOpened);
    this.ui.Tab.currentChanged.connect(this, this.tabChanged);
    this.ui.Tab.widget(0).QCPConfirmationPushButton.clicked.connect(tile, tile.hide);
    this.ui.Tab.widget(0).QCPTextEntry.textChanged.connect(this, this.storeNameChanged);
    this.ui.Tab.widget(0).QCPPushButton_Cancel.clicked.connect(tile, tile.hide);
    this.ui.Tab.widget(1).QCPPushButton_Cancel_2.clicked.connect(tile, tile.hide);
    // No longer populating text field when clicking on table for now
    //this.ui.TableEnum.valueChanged.connect(this, this.storeSelected);
}

//Initialize.prototype.storeSelected = function(idx)
//{
//    this.ui.Tab.widget(0).TextEntry.setText(this.ui.TableEnum.getLiteral(idx).trim());
//    this.storeNameChanged();
//}

Initialize.prototype.storeNameChanged = function(name)
{
    if(this.ui.QCPTableEnum.literalExists(name))
        this.ui.Tab.widget(0).QCPConfirmationPushButton.PromptStyle = 1;
    else
        this.ui.Tab.widget(0).QCPConfirmationPushButton.PromptStyle = 0;
}

Initialize.prototype.windowOpened = function()
{
    this.ui.Tab.setCurrentIndex(0);
}

Initialize.prototype.tabChanged = function(idx)
{
    // Disable highlight on table when viewing the Store tab
    this.ui.QCPTableEnum.ReadOnly = (idx == 0);
}


