function Initialize(tile, engine, system)
{
    this.ui = tile.getContainerFrame(); 
    this.ui.FileBrowserStoreRecall.setCurrentPath("/USER/target/ARM/save-recall");
    this.ui.FileBrowserStoreRecall.fileSelected.connect(this, this.submitFile);
    this.ui.FileBrowserStoreRecall.clearFileName.connect(this, this.clearFile);
    this.ui.File_HIDDEN.textChanged.connect(this, this.setFileText);
    this.ui.File_HIDDEN.hide();
    
    var widgetConnector = system.getModule("WidgetConnector");
    var fileFilter = widgetConnector.connectWidget(this.ui.File);
    fileFilter.submit.connect(this, this.fileEntered);
}

Initialize.prototype.clearFile = function()
{
	var filter = this.ui.File_HIDDEN.getEventFilter();
	filter.submitWidgetValue("");
}

Initialize.prototype.submitFile = function(fileName)
{
	var filter = this.ui.File_HIDDEN.getEventFilter();
	filter.submitWidgetValue(fileName);
}

Initialize.prototype.fileEntered = function(fileName)
{
	var path = this.ui.FileBrowserStoreRecall.directoryPath();
	var filter = this.ui.File_HIDDEN.getEventFilter();
	filter.submitWidgetValue(path + "/" + fileName);
}

Initialize.prototype.setFileText = function(text)
{
	var idx = text.lastIndexOf("/");
	if (idx != -1)
	{
		text = text.substring(idx+1, text.length);
	}
	this.ui.File.text = text;
}