function Initialize(tile, engine, system)
{
    this.tile = tile;
    this.ui = tile.getContainerFrame();
    this.engine = engine;
    this.system = system;

    this.ui.Label_invalidPw.hide();

    this.ui.PushButton_Cancel.clicked.connect(this, this.closeSelf);
    this.ui.PushButton.clicked.connect(this, this.handleLogin);
    
    var widgetConnector = system.getModule("WidgetConnector");
    
    var filter = widgetConnector.connectWidget(this.ui.TextEntry_Pw);
    filter.submit.connect(this, this.handleLogin);
}

Initialize.prototype.closeSelf = function()
{
    this.ui.Label_invalidPw.hide();
    
    this.tile.close();
}

Initialize.prototype.handleLogin = function()
{
    if(this.ui.TextEntry_Pw.text == "5025") {
        this.ui.Label_invalidPw.hide();
        
        var screen = this.system.getSystemScreen("3550_Self_Test");
		if (screen != null)
		{
			screen.show();
		}
        
        this.closeSelf();
    } else
    {
        this.ui.Label_invalidPw.show();
    }
}
